/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.event;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.init.ModItems;

@Mod.EventBusSubscriber(modid="scguns")
public class ArmorBoostEventHandler {
    private static final int RESISTANCE_LEVEL = 1;
    private static final int EFFECT_DURATION = 80;

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ArmorBoostEventHandler.applyResistanceBoost(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ArmorBoostEventHandler.applyResistanceBoost(player);
        }
    }

    private static void applyResistanceBoost(Player player) {
        boolean holdingSpecialItem;
        boolean bl = holdingSpecialItem = ArmorBoostEventHandler.isSpecialItem(player.m_21205_()) || ArmorBoostEventHandler.isSpecialItem(player.m_21206_());
        if (holdingSpecialItem) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 80, 1, false, false));
        }
    }

    private static boolean isSpecialItem(ItemStack itemStack) {
        return itemStack.m_41720_() == ModItems.SHELLURKER.get();
    }
}

