/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import top.ribs.scguns.common.SulfurGasCloud;

public class SulfurGasCloudEntity
extends Entity {
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(SulfurGasCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(SulfurGasCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BASE_DURATION = SynchedEntityData.m_135353_(SulfurGasCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BASE_AMPLIFIER = SynchedEntityData.m_135353_(SulfurGasCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int ticksExisted = 0;
    private static final float DAMAGE_PHASE_RATIO = 0.85f;

    public SulfurGasCloudEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
    }

    public SulfurGasCloudEntity(EntityType<?> entityType, Level level, Vec3 position, float radius, int duration, int baseDuration, int baseAmplifier) {
        this(entityType, level);
        this.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(radius));
        this.f_19804_.m_135381_(DURATION, (Object)duration);
        this.f_19804_.m_135381_(BASE_DURATION, (Object)baseDuration);
        this.f_19804_.m_135381_(BASE_AMPLIFIER, (Object)baseAmplifier);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(6.0f));
        this.f_19804_.m_135372_(DURATION, (Object)600);
        this.f_19804_.m_135372_(BASE_DURATION, (Object)100);
        this.f_19804_.m_135372_(BASE_AMPLIFIER, (Object)2);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            float radius = ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue();
            int duration = (Integer)this.f_19804_.m_135370_(DURATION);
            int baseDuration = (Integer)this.f_19804_.m_135370_(BASE_DURATION);
            int baseAmplifier = (Integer)this.f_19804_.m_135370_(BASE_AMPLIFIER);
            Vec3 center = this.m_20182_();
            float lifecycleProgress = (float)this.ticksExisted / (float)duration;
            float intensity = this.calculateIntensity(lifecycleProgress);
            SulfurGasCloud.spawnEnhancedGasCloud(this.m_9236_(), center, radius, intensity, this.f_19796_, this.ticksExisted);
            int damagePhaseTicks = (int)((float)duration * 0.85f);
            if (this.ticksExisted < damagePhaseTicks) {
                float damageMultiplier = this.calculateDamageMultiplier(lifecycleProgress);
                int scaledDuration = (int)((float)baseDuration * damageMultiplier);
                SulfurGasCloud.applyGasEffects(this.m_9236_(), center, (double)radius, scaledDuration, baseAmplifier);
            }
            SulfurGasCloud.checkAndHandleFireExplosion(this.m_9236_(), center, radius);
            ++this.ticksExisted;
            if (this.ticksExisted >= duration) {
                this.m_146870_();
            }
        }
    }

    private float calculateIntensity(float progress) {
        if (progress < 0.1f) {
            return Mth.m_14036_((float)(progress / 0.1f), (float)0.0f, (float)1.0f);
        }
        if (progress < 0.6f) {
            return 1.0f;
        }
        float fadeProgress = (progress - 0.6f) / 0.4f;
        return Mth.m_14036_((float)(1.0f - fadeProgress), (float)0.0f, (float)1.0f);
    }

    private float calculateDamageMultiplier(float progress) {
        if (progress < 0.15f) {
            return Mth.m_14036_((float)(progress / 0.15f), (float)0.3f, (float)1.0f);
        }
        if (progress < 0.5f) {
            return 1.0f;
        }
        if (progress < 0.85f) {
            float fadeProgress = (progress - 0.5f) / 0.35000002f;
            return Mth.m_14036_((float)(1.0f - fadeProgress * 0.7f), (float)0.3f, (float)1.0f);
        }
        return 0.0f;
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("Radius")) {
            this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(compound.m_128457_("Radius")));
        }
        if (compound.m_128441_("Duration")) {
            this.f_19804_.m_135381_(DURATION, (Object)compound.m_128451_("Duration"));
        }
        if (compound.m_128441_("BaseDuration")) {
            this.f_19804_.m_135381_(BASE_DURATION, (Object)compound.m_128451_("BaseDuration"));
        }
        if (compound.m_128441_("BaseAmplifier")) {
            this.f_19804_.m_135381_(BASE_AMPLIFIER, (Object)compound.m_128451_("BaseAmplifier"));
        }
        if (compound.m_128441_("TicksExisted")) {
            this.ticksExisted = compound.m_128451_("TicksExisted");
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("Radius", ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue());
        compound.m_128405_("Duration", ((Integer)this.f_19804_.m_135370_(DURATION)).intValue());
        compound.m_128405_("BaseDuration", ((Integer)this.f_19804_.m_135370_(BASE_DURATION)).intValue());
        compound.m_128405_("BaseAmplifier", ((Integer)this.f_19804_.m_135370_(BASE_AMPLIFIER)).intValue());
        compound.m_128405_("TicksExisted", this.ticksExisted);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6783_(double distance) {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }
}

