/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import top.ribs.scguns.Config;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModDamageTypes;
import top.ribs.scguns.init.ModTags;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageBlood;
import top.ribs.scguns.network.message.S2CMessageProjectileHitBlock;
import top.ribs.scguns.network.message.S2CMessageProjectileHitEntity;
import top.ribs.scguns.util.GunEnchantmentHelper;

public class KrahgRoundProjectileEntity
extends ProjectileEntity {
    private static final float KRAHG_SHIELD_DISABLE_CHANCE = 0.6f;
    private static final float SHIELD_DAMAGE_PENETRATION = 0.4f;
    private static final float MAX_BREAKABLE_HARDNESS = 4.0f;
    private static final float BLOCK_BREAK_CHANCE = 0.65f;
    private static final float HEADSHOT_EFFECT_DURATION_MULTIPLIER = 1.5f;
    private boolean hasPassedThroughBlock = false;
    private static final List<Block> UNBREAKABLE_BLOCKS = Arrays.asList(Blocks.f_50752_, Blocks.f_50080_, Blocks.f_50723_, Blocks.f_50258_, Blocks.f_50722_, Blocks.f_220863_);

    public KrahgRoundProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public KrahgRoundProjectileEntity(EntityType<? extends Entity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
    }

    @Override
    public void m_8119_() {
        if (!this.m_9236_().m_5776_()) {
            Vec3 startVec = this.m_20182_();
            Vec3 endVec = startVec.m_82549_(this.m_20184_());
            BlockHitResult blockResult = KrahgRoundProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), IGNORE_LEAVES);
            List<ProjectileEntity.EntityResult> hitEntities = this.findEntitiesOnPath(startVec, endVec);
            while (!this.hasPassedThroughBlock || !Objects.requireNonNull(hitEntities).isEmpty()) {
                Vec3 hitLoc;
                BlockState state;
                double blockDist = blockResult.m_6662_() != HitResult.Type.MISS ? startVec.m_82557_(blockResult.m_82450_()) : Double.MAX_VALUE;
                ProjectileEntity.EntityResult closestEntity = null;
                double closestEntityDist = Double.MAX_VALUE;
                assert (hitEntities != null);
                if (!hitEntities.isEmpty()) {
                    for (ProjectileEntity.EntityResult entity : hitEntities) {
                        double dist;
                        if (entity.getEntity().m_19879_() == this.shooterId || !((dist = startVec.m_82557_(entity.getHitPos())) < closestEntityDist)) continue;
                        closestEntityDist = dist;
                        closestEntity = entity;
                    }
                }
                if (blockDist < closestEntityDist && blockResult.m_6662_() != HitResult.Type.MISS) {
                    state = this.m_9236_().m_8055_(blockResult.m_82425_());
                    if (!this.canBreakBlock(state, blockResult.m_82425_()) || this.hasPassedThroughBlock) {
                        hitLoc = blockResult.m_82450_();
                        this.onHitBlock(state, blockResult.m_82425_(), blockResult.m_82434_(), hitLoc.f_82479_, hitLoc.f_82480_, hitLoc.f_82481_);
                        this.m_142687_(Entity.RemovalReason.KILLED);
                        return;
                    }
                } else {
                    if (closestEntity == null) break;
                    this.onHitEntity(closestEntity.getEntity(), closestEntity.getHitPos(), startVec, endVec, closestEntity.isHeadshot());
                    this.m_142687_(Entity.RemovalReason.KILLED);
                    return;
                }
                hitLoc = blockResult.m_82450_();
                this.onHitBlock(state, blockResult.m_82425_(), blockResult.m_82434_(), hitLoc.f_82479_, hitLoc.f_82480_, hitLoc.f_82481_);
                this.hasPassedThroughBlock = true;
                startVec = hitLoc.m_82549_(this.m_20184_().m_82490_(0.01));
                endVec = startVec.m_82549_(this.m_20184_());
                blockResult = KrahgRoundProjectileEntity.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), IGNORE_LEAVES);
                hitEntities = this.findEntitiesOnPath(startVec, endVec);
                this.m_20256_(this.m_20184_().m_82542_(0.8, 0.8, 0.8));
            }
        }
        this.m_6034_(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
        if (this.projectile.isGravity()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, this.modifiedGravity, 0.0));
        }
        this.updateHeading();
        if (this.f_19797_ >= this.life) {
            this.onExpired();
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        boolean canBreak = this.canBreakBlock(state, pos);
        if (!this.m_9236_().f_46443_) {
            if (canBreak) {
                this.m_9236_().m_46961_(pos, true);
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), x, y, z, 20, 0.0, 0.0, 0.0, 0.15);
                this.m_9236_().m_5594_(null, pos, state.m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, x, y, z, 10, 0.0, 0.0, 0.0, 0.1);
                PacketHandler.getPlayChannel().sendToTrackingChunk(() -> this.m_9236_().m_46745_(pos), (IMessage)new S2CMessageProjectileHitBlock(x, y, z, pos, face));
            }
        }
        if (!canBreak) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private boolean canBreakBlock(BlockState state, BlockPos pos) {
        if (!((Boolean)Config.COMMON.gameplay.griefing.enableBlockBreaking.get()).booleanValue()) {
            return false;
        }
        if (UNBREAKABLE_BLOCKS.contains(state.m_60734_())) {
            return false;
        }
        float hardness = state.m_60800_((BlockGetter)this.m_9236_(), pos);
        if (hardness < 0.0f || hardness > 4.0f) {
            return false;
        }
        if (state.m_155947_()) {
            return false;
        }
        if (!state.m_60819_().m_76178_()) {
            return false;
        }
        return this.f_19796_.m_188501_() < 0.65f;
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        LivingEntity livingTarget;
        float newDamage;
        float damage = this.getDamage();
        boolean critical = damage != (newDamage = this.getCriticalDamage(this.getWeapon(), this.f_19796_, damage));
        damage = newDamage;
        ResourceLocation advantage = this.getProjectile().getAdvantage();
        damage *= this.advantageMultiplier(entity);
        if (headshot) {
            damage = (float)((double)damage * (Double)Config.COMMON.gameplay.headShotDamageMultiplier.get());
        }
        if (entity instanceof LivingEntity) {
            livingTarget = (LivingEntity)entity;
            damage = this.applyProjectileProtection(livingTarget, damage);
            damage = this.calculateArmorBypassDamage(livingTarget, damage);
        }
        if (entity instanceof LivingEntity) {
            livingTarget = (LivingEntity)entity;
            damage = GunEnchantmentHelper.getPuncturingDamageReduction(this.getWeapon(), livingTarget, damage);
            damage = this.applyProjectileProtection(livingTarget, damage);
            damage = this.calculateArmorBypassDamage(livingTarget, damage);
        }
        DamageSource source = ModDamageTypes.Sources.projectile(this.m_9236_().m_9598_(), this, (LivingEntity)this.getOwner());
        boolean blocked = ProjectileEntity.ProjectileHelper.handleShieldHit(entity, this, damage, 0.6f);
        if (blocked) {
            float penetratingDamage = damage * 0.4f;
            entity.m_6469_(source, penetratingDamage);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                ResourceLocation effectLocation = this.getProjectile().getImpactEffect();
                if (effectLocation != null) {
                    MobEffect effect;
                    float effectChance = this.getProjectile().getImpactEffectChance() * 0.4f;
                    if (this.f_19796_.m_188501_() < effectChance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
                        int reducedDuration = (int)((float)this.getProjectile().getImpactEffectDuration() * 0.4f);
                        livingEntity.m_7292_(new MobEffectInstance(effect, reducedDuration, this.getProjectile().getImpactEffectAmplifier()));
                    }
                }
            }
        } else if (!entity.m_6095_().m_204039_(ModTags.Entities.GHOST) || advantage.equals((Object)ModTags.Entities.UNDEAD.f_203868_())) {
            entity.m_6469_(source, damage);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                ResourceLocation effectLocation = this.getProjectile().getImpactEffect();
                if (effectLocation != null) {
                    MobEffect effect;
                    float effectChance = this.getProjectile().getImpactEffectChance();
                    if (headshot) {
                        effectChance = Math.min(1.0f, effectChance * 1.25f);
                    }
                    if (this.hasPassedThroughBlock) {
                        effectChance = Math.min(1.0f, effectChance * 1.15f);
                    }
                    if (this.f_19796_.m_188501_() < effectChance && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectLocation)) != null) {
                        int duration = this.getProjectile().getImpactEffectDuration();
                        if (headshot) {
                            duration = (int)((float)duration * 1.5f);
                        }
                        if (this.hasPassedThroughBlock) {
                            duration = (int)((float)duration * 1.25f);
                        }
                        livingEntity.m_7292_(new MobEffectInstance(effect, duration, this.getProjectile().getImpactEffectAmplifier()));
                    }
                }
            }
        }
        if (entity instanceof LivingEntity) {
            GunEnchantmentHelper.applyElementalPopEffect(this.getWeapon(), (LivingEntity)entity);
        }
        if (this.shooter instanceof Player) {
            int hitType = critical ? 2 : (headshot ? 1 : 0);
            PacketHandler.getPlayChannel().sendToPlayer(() -> (ServerPlayer)this.shooter, (IMessage)new S2CMessageProjectileHitEntity(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, hitType, entity instanceof Player));
        }
        PacketHandler.getPlayChannel().sendToTracking(() -> entity, (IMessage)new S2CMessageBlood(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, entity.m_6095_()));
        entity.f_19802_ = 0;
    }

    @Override
    public void onExpired() {
    }
}

