/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.entity.projectile.ProjectileEntity;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.item.GunItem;

public class FireGrenadeRoundEntity
extends ProjectileEntity {
    private static final float EXPLOSION_RADIUS = 3.5f;

    public FireGrenadeRoundEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public FireGrenadeRoundEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        if (entity instanceof Player) {
            boolean isBlockingOffHand;
            Player player = (Player)entity;
            ItemStack mainHandItem = player.m_21205_();
            ItemStack offHandItem = player.m_21206_();
            boolean isBlockingMainHand = player.m_21254_() && mainHandItem.m_41720_() instanceof ShieldItem;
            boolean bl = isBlockingOffHand = player.m_21254_() && offHandItem.m_41720_() instanceof ShieldItem;
            if (isBlockingMainHand || isBlockingOffHand) {
                ItemStack shield = isBlockingMainHand ? mainHandItem : offHandItem;
                InteractionHand hand = isBlockingMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                player.m_36335_().m_41524_(shield.m_41720_(), 100);
                player.m_5810_();
                player.m_9236_().m_7605_((Entity)player, (byte)30);
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12347_, SoundSource.PLAYERS, 1.0f, 0.8f + player.m_9236_().m_213780_().m_188501_() * 0.4f);
                shield.m_41622_(15, (LivingEntity)player, p -> p.m_21190_(hand));
            }
        }
        this.createFireGrenadeExplosion(this, 3.5f);
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        this.createFireGrenadeExplosion(this, 3.5f);
    }

    @Override
    public void onExpired() {
        this.createFireGrenadeExplosion(this, 3.5f);
    }

    private void createFireGrenadeExplosion(Entity entity, float radius) {
        Level world = entity.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        Vec3 explosionPos = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        this.playExplosionSound(world, explosionPos, radius);
        this.spawnExplosionParticles(world, explosionPos, radius);
        this.applyFireDamageAndPlacement(world, explosionPos, radius, entity);
    }

    private void playExplosionSound(Level world, Vec3 pos, float radius) {
        float volume = Math.min(3.0f, radius * 0.5f);
        float pitch = 0.9f + world.f_46441_.m_188501_() * 0.3f;
        world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11913_, SoundSource.BLOCKS, volume, pitch);
        world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11874_, SoundSource.BLOCKS, volume * 0.8f, pitch);
    }

    private void spawnExplosionParticles(Level world, Vec3 explosionPos, float radius) {
        ServerLevel serverLevel = (ServerLevel)world;
        double sizeMultiplier = (double)radius / 3.5;
        BlockPos blockPos = BlockPos.m_274561_((double)explosionPos.f_82479_, (double)explosionPos.f_82480_, (double)explosionPos.f_82481_);
        BlockState blockAtExplosion = world.m_8055_(blockPos);
        double adjustedY = !blockAtExplosion.m_60795_() ? (double)blockPos.m_123342_() + 1.0 : explosionPos.f_82480_ + 0.2;
        double renderDistance = 128.0;
        List nearbyPlayers = serverLevel.m_45976_(ServerPlayer.class, new AABB(explosionPos.f_82479_ - renderDistance, explosionPos.f_82480_ - renderDistance, explosionPos.f_82481_ - renderDistance, explosionPos.f_82479_ + renderDistance, explosionPos.f_82480_ + renderDistance, explosionPos.f_82481_ + renderDistance));
        for (ServerPlayer player : nearbyPlayers) {
            serverLevel.m_8624_(player, (ParticleOptions)((SimpleParticleType)ModParticleTypes.FIRE_GRENADE_EXPLOSION.get()), true, explosionPos.f_82479_, adjustedY, explosionPos.f_82481_, 1, sizeMultiplier, 0.0, 0.0, 0.0);
        }
        for (int burstWave = 0; burstWave < 3; ++burstWave) {
            int particlesInBurst = 8 + burstWave * 4;
            double burstRadius = (double)radius * (0.3 + (double)burstWave * 0.15);
            for (int i = 0; i < particlesInBurst; ++i) {
                double angle = (double)i / (double)particlesInBurst * 2.0 * Math.PI;
                double distance = burstRadius * (0.5 + world.f_46441_.m_188500_() * 0.5);
                double burstX = Math.cos(angle) * distance;
                double burstZ = Math.sin(angle) * distance;
                double burstY = (world.f_46441_.m_188500_() - 0.3) * (double)radius * 0.15;
                double speedX = Math.cos(angle) * (0.25 + world.f_46441_.m_188500_() * 0.35);
                double speedY = 0.2 + world.f_46441_.m_188500_() * 0.3;
                double speedZ = Math.sin(angle) * (0.25 + world.f_46441_.m_188500_() * 0.35);
                for (ServerPlayer player : nearbyPlayers) {
                    serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123744_, true, explosionPos.f_82479_ + burstX, adjustedY + burstY, explosionPos.f_82481_ + burstZ, 2, speedX, speedY, speedZ, 0.1);
                }
            }
        }
        for (int scatter = 0; scatter < 20; ++scatter) {
            double scatterRadius = (double)radius * 1.2;
            double scatterAngle = world.f_46441_.m_188500_() * 2.0 * Math.PI;
            double scatterDistance = world.f_46441_.m_188500_() * scatterRadius;
            double scatterX = Math.cos(scatterAngle) * scatterDistance;
            double scatterZ = Math.sin(scatterAngle) * scatterDistance;
            double scatterY = (world.f_46441_.m_188500_() - 0.5) * (double)radius * 0.3;
            double scatterSpeedX = (world.f_46441_.m_188500_() - 0.5) * 0.6;
            double scatterSpeedY = world.f_46441_.m_188500_() * 0.4;
            double scatterSpeedZ = (world.f_46441_.m_188500_() - 0.5) * 0.6;
            if ((double)world.f_46441_.m_188501_() < 0.7) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, explosionPos.f_82479_ + scatterX, adjustedY + scatterY, explosionPos.f_82481_ + scatterZ, 1, scatterSpeedX, scatterSpeedY, scatterSpeedZ, 0.1);
                continue;
            }
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, explosionPos.f_82479_ + scatterX, adjustedY + scatterY, explosionPos.f_82481_ + scatterZ, 1, scatterSpeedX, scatterSpeedY, scatterSpeedZ, 0.05);
        }
    }

    private void applyFireDamageAndPlacement(Level world, Vec3 explosionPos, float radius, Entity sourceEntity) {
        BlockPos centerPos = BlockPos.m_274446_((Position)explosionPos);
        AABB effectArea = new AABB(centerPos).m_82400_((double)radius);
        List nearbyEntities = world.m_45976_(LivingEntity.class, effectArea);
        for (LivingEntity livingEntity : nearbyEntities) {
            double distance = livingEntity.m_20270_(sourceEntity);
            if (!(distance <= (double)radius)) continue;
            livingEntity.m_20254_(6);
            float damage = (float)(3.0 * (1.0 - distance / (double)radius));
            livingEntity.m_6469_(world.m_269111_().m_269387_(), damage);
        }
        ServerLevel serverLevel = (ServerLevel)world;
        int radiusInt = (int)Math.ceil(radius);
        int radiusSquared = radiusInt * radiusInt;
        for (int x = -radiusInt; x <= radiusInt; ++x) {
            for (int z = -radiusInt; z <= radiusInt; ++z) {
                BlockPos columnPos;
                if (world.f_46441_.m_188501_() > 0.6f || !(centerPos.m_123331_((Vec3i)(columnPos = centerPos.m_7918_(x, 0, z))) <= (double)radiusSquared)) continue;
                double distanceFromCenter = Math.sqrt(centerPos.m_123331_((Vec3i)columnPos));
                int delay = (int)(distanceFromCenter * 2.0);
                this.scheduleFirePlacement(serverLevel, centerPos, columnPos, radiusInt, delay);
            }
        }
    }

    private void scheduleFirePlacement(ServerLevel world, BlockPos centerPos, BlockPos columnPos, int radiusInt, int delay) {
        world.m_7654_().m_6937_((Runnable)new TickTask(world.m_7654_().m_129921_() + delay, () -> {
            for (int y = -radiusInt; y <= radiusInt; ++y) {
                BlockPos pos = centerPos.m_7918_(columnPos.m_123341_() - centerPos.m_123341_(), y, columnPos.m_123343_() - centerPos.m_123343_());
                BlockState stateAtPos = world.m_8055_(pos);
                BlockState stateBelow = world.m_8055_(pos.m_7495_());
                if (!stateAtPos.m_60795_() || !stateBelow.m_60783_((BlockGetter)world, pos.m_7495_(), Direction.UP) && stateBelow.m_60795_()) continue;
                world.m_7731_(pos, Blocks.f_50083_.m_49966_(), 3);
                break;
            }
        }));
    }
}

