/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import top.ribs.scguns.entity.projectile.EnemyProjectileEntity;
import top.ribs.scguns.init.ModEntities;
import top.ribs.scguns.init.ModSounds;

public class MotherGhastEntity
extends FlyingMob
implements Enemy {
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.m_135353_(MotherGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TURRET_FLASH_TIMER = SynchedEntityData.m_135353_(MotherGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int explosionPower = 1;
    private int turretCooldown = 0;
    private int burstCounter = 0;
    private int burstPauseCooldown = 0;
    private static final int TURRET_COOLDOWN_TICKS = 3;
    private static final int BURST_SIZE = 12;
    private static final int BURST_PAUSE_TICKS = 40;
    private static final double TURRET_RANGE = 60.0;

    public MotherGhastEntity(EntityType<? extends MotherGhastEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 10;
        this.f_21342_ = new MotherGhastMoveControl(this);
        this.m_21530_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MotherGhastShootFireballGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AggressiveFloatGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new RandomFloatAroundGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new MotherGhastLookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.m_7500_() && !player.m_5833_() && Math.abs(entity.m_20186_() - this.m_20186_()) <= 4.0;
            }
            return false;
        }));
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHARGING);
    }

    public void setCharging(boolean charging) {
        this.f_19804_.m_135381_(DATA_IS_CHARGING, (Object)charging);
    }

    public int getExplosionPower() {
        return this.explosionPower;
    }

    protected boolean m_8028_() {
        return true;
    }

    private static boolean isReflectedFireball(DamageSource damageSource) {
        return damageSource.m_7640_() instanceof LargeFireball && damageSource.m_7639_() instanceof Player;
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_269533_(DamageTypeTags.f_268745_) || !MotherGhastEntity.isReflectedFireball(source) && super.m_6673_(source);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity;
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            boolean shouldTarget = true;
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                boolean bl = shouldTarget = !player.m_7500_() && !player.m_5833_();
            }
            if (shouldTarget && this.m_5448_() == null) {
                this.m_6710_(attacker);
            }
        }
        if (MotherGhastEntity.isReflectedFireball(source)) {
            return super.m_6469_(source, 25.0f);
        }
        return super.m_6469_(source, amount);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_CHARGING, (Object)false);
        this.f_19804_.m_135372_(TURRET_FLASH_TIMER, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 120.0).m_22268_(Attributes.f_22285_, 2.0).m_22268_(Attributes.f_22284_, 12.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22282_, (double)0.8f).m_22268_(Attributes.f_22277_, 100.0);
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11919_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11921_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11920_;
    }

    protected float m_6121_() {
        return 3.0f;
    }

    public float m_6100_() {
        return 0.7f;
    }

    public int m_5792_() {
        return 1;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("ExplosionPower", (byte)this.explosionPower);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("ExplosionPower", 99)) {
            this.explosionPower = compound.m_128445_("ExplosionPower");
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 4.0f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.f_19797_ % 4 == 0) {
            this.spawnVentSmoke();
        }
        if (!this.m_9236_().f_46443_) {
            double distanceSq;
            LivingEntity target;
            int flashTimer = (Integer)this.f_19804_.m_135370_(TURRET_FLASH_TIMER);
            if (flashTimer > 0) {
                this.f_19804_.m_135381_(TURRET_FLASH_TIMER, (Object)(flashTimer - 1));
            }
            if (this.turretCooldown > 0) {
                --this.turretCooldown;
            }
            if (this.burstPauseCooldown > 0) {
                --this.burstPauseCooldown;
            }
            if ((target = this.m_5448_()) != null && this.turretCooldown <= 0 && this.burstPauseCooldown <= 0 && (distanceSq = this.m_20280_((Entity)target)) < 3600.0 && this.m_142582_((Entity)target)) {
                this.fireTurret(target);
                this.turretCooldown = 3;
                ++this.burstCounter;
                if (this.burstCounter >= 12) {
                    this.burstCounter = 0;
                    this.burstPauseCooldown = 40;
                }
            }
        }
    }

    private void spawnVentSmoke() {
        float yaw = (float)Math.toRadians(this.m_146908_());
        float cos = (float)Math.cos(yaw);
        float sin = (float)Math.sin(yaw);
        double leftX = -4.5;
        double leftZ = -6.0;
        double vent1X = this.m_20185_() + (double)cos * leftX - (double)sin * leftZ;
        double vent1Y = this.m_20186_() + 6.5;
        double vent1Z = this.m_20189_() + (double)sin * leftX + (double)cos * leftZ;
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, vent1X, vent1Y, vent1Z, 0.0, 0.05, 0.0);
        double rightX = -4.5;
        double rightZ = -4.0;
        double vent2X = this.m_20185_() + (double)cos * rightX - (double)sin * rightZ;
        double vent2Y = this.m_20186_() + 6.5;
        double vent2Z = this.m_20189_() + (double)sin * rightX + (double)cos * rightZ;
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, vent2X, vent2Y, vent2Z, 0.0, 0.05, 0.0);
    }

    private void fireTurret(LivingEntity target) {
        float yaw = this.m_146908_() * ((float)Math.PI / 180);
        double rightOffsetX = Math.cos(yaw) * 3.5;
        double rightOffsetZ = -Math.sin(yaw) * 3.5;
        Vec3 turretPos = this.m_20182_().m_82520_(rightOffsetX, 4.0, rightOffsetZ);
        double deltaX = target.m_20185_() - turretPos.f_82479_;
        double deltaY = target.m_20227_(0.5) - turretPos.f_82480_;
        double deltaZ = target.m_20189_() - turretPos.f_82481_;
        double horizontalDist = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        Vec3 direction = new Vec3(deltaX, deltaY += horizontalDist * 0.02, deltaZ).m_82541_();
        EnemyProjectileEntity projectile = new EnemyProjectileEntity((EntityType<EnemyProjectileEntity>)((EntityType)ModEntities.ENEMY_PROJECTILE.get()), this.m_9236_(), (LivingEntity)this);
        projectile.m_6034_(turretPos.f_82479_, turretPos.f_82480_, turretPos.f_82481_);
        projectile.m_20256_(direction.m_82490_(6.5));
        projectile.m_20242_(true);
        this.m_9236_().m_7967_((Entity)projectile);
        this.triggerTurretFlash();
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.MACHINE_GUN_FIRE.get(), this.m_5720_(), 1.0f, 1.0f + this.f_19796_.m_188501_() * 0.2f);
    }

    public void triggerTurretFlash() {
        this.f_19804_.m_135381_(TURRET_FLASH_TIMER, (Object)2);
    }

    public boolean isTurretFlashVisible() {
        return (Integer)this.f_19804_.m_135370_(TURRET_FLASH_TIMER) > 0;
    }

    static class MotherGhastMoveControl
    extends MoveControl {
        private final MotherGhastEntity ghast;
        private int floatDuration;

        public MotherGhastMoveControl(MotherGhastEntity ghast) {
            super((Mob)ghast);
            this.ghast = ghast;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.ghast.m_217043_().m_188503_(5) + 2;
                Vec3 vec3 = new Vec3(this.f_24975_ - this.ghast.m_20185_(), this.f_24976_ - this.ghast.m_20186_(), this.f_24977_ - this.ghast.m_20189_());
                double distance = vec3.m_82553_();
                if (this.canReach(vec3 = vec3.m_82541_(), Mth.m_14165_((double)distance))) {
                    this.ghast.m_20256_(this.ghast.m_20184_().m_82549_(vec3.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 pos, int length) {
            AABB aabb = this.ghast.m_20191_();
            for (int i = 1; i < length; ++i) {
                aabb = aabb.m_82383_(pos);
                if (this.ghast.m_9236_().m_45756_((Entity)this.ghast, aabb)) continue;
                return false;
            }
            return true;
        }
    }

    static class MotherGhastShootFireballGoal
    extends Goal {
        private final MotherGhastEntity ghast;
        public int chargeTime;
        private int fireballBurstCount = 0;
        private int fireballsToShoot = 0;

        public MotherGhastShootFireballGoal(MotherGhastEntity ghast) {
            this.ghast = ghast;
        }

        public boolean m_8036_() {
            return this.ghast.m_5448_() != null;
        }

        public void m_8056_() {
            this.chargeTime = 0;
            this.fireballBurstCount = 0;
            this.fireballsToShoot = 0;
        }

        public void m_8041_() {
            this.ghast.setCharging(false);
            this.fireballBurstCount = 0;
            this.fireballsToShoot = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.ghast.m_5448_();
            if (target != null) {
                if (target.m_20280_((Entity)this.ghast) < 4096.0 && this.ghast.m_142582_((Entity)target)) {
                    Level level = this.ghast.m_9236_();
                    ++this.chargeTime;
                    if (this.chargeTime == 10 && !this.ghast.m_20067_()) {
                        level.m_5898_(null, 1015, this.ghast.m_20183_(), 0);
                        this.fireballsToShoot = 2 + this.ghast.m_217043_().m_188503_(3);
                    }
                    if ((this.chargeTime == 20 || this.fireballBurstCount > 0 && this.chargeTime % 5 == 0) && this.fireballBurstCount < this.fireballsToShoot) {
                        Vec3 viewVector = this.ghast.m_20252_(1.0f);
                        double d2 = target.m_20185_() - (this.ghast.m_20185_() + viewVector.f_82479_ * 4.0);
                        double d3 = target.m_20227_(0.5) - (0.5 + this.ghast.m_20227_(0.5));
                        double d4 = target.m_20189_() - (this.ghast.m_20189_() + viewVector.f_82481_ * 4.0);
                        if (!this.ghast.m_20067_() && this.fireballBurstCount == 0) {
                            level.m_5898_(null, 1016, this.ghast.m_20183_(), 0);
                        }
                        double speed = 2.0;
                        LargeFireball fireball = new LargeFireball(level, (LivingEntity)this.ghast, d2 * speed, d3 * speed, d4 * speed, 0);
                        fireball.m_6034_(this.ghast.m_20185_() + viewVector.f_82479_ * 4.0, this.ghast.m_20227_(0.5) + 0.5, fireball.m_20189_() + viewVector.f_82481_ * 4.0);
                        level.m_7967_((Entity)fireball);
                        ++this.fireballBurstCount;
                        if (this.fireballBurstCount >= this.fireballsToShoot) {
                            this.chargeTime = -60;
                            this.fireballBurstCount = 0;
                            this.fireballsToShoot = 0;
                        }
                    }
                } else if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
                this.ghast.setCharging(this.chargeTime > 10);
            }
        }
    }

    static class AggressiveFloatGoal
    extends Goal {
        private final MotherGhastEntity ghast;
        private static final double PREFERRED_DISTANCE = 35.0;
        private static final double MIN_DISTANCE = 25.0;
        private static final double MAX_DISTANCE = 50.0;

        public AggressiveFloatGoal(MotherGhastEntity ghast) {
            this.ghast = ghast;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double deltaZ;
            double deltaY;
            LivingEntity target = this.ghast.m_5448_();
            if (target == null) {
                return false;
            }
            MoveControl moveControl = this.ghast.m_21566_();
            if (!moveControl.m_24995_()) {
                return true;
            }
            double deltaX = moveControl.m_25000_() - this.ghast.m_20185_();
            double distanceSq = deltaX * deltaX + (deltaY = moveControl.m_25001_() - this.ghast.m_20186_()) * deltaY + (deltaZ = moveControl.m_25002_() - this.ghast.m_20189_()) * deltaZ;
            return distanceSq < 1.0 || distanceSq > 900.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            double targetZ;
            double targetY;
            double targetX;
            LivingEntity target = this.ghast.m_5448_();
            if (target == null) {
                return;
            }
            RandomSource random = this.ghast.m_217043_();
            double currentDistance = this.ghast.m_20270_((Entity)target);
            if (currentDistance < 25.0) {
                double dx = this.ghast.m_20185_() - target.m_20185_();
                double dy = this.ghast.m_20186_() - target.m_20186_();
                double dz = this.ghast.m_20189_() - target.m_20189_();
                double length = Math.sqrt(dx * dx + dy * dy + dz * dz);
                targetX = target.m_20185_() + dx / length * 35.0;
                targetY = target.m_20186_() + dy / length * 35.0 + (double)((random.m_188501_() * 2.0f - 1.0f) * 3.0f);
                targetZ = target.m_20189_() + dz / length * 35.0;
            } else if (currentDistance > 50.0) {
                double dx = target.m_20185_() - this.ghast.m_20185_();
                double dy = target.m_20186_() - this.ghast.m_20186_();
                double dz = target.m_20189_() - this.ghast.m_20189_();
                double length = Math.sqrt(dx * dx + dy * dy + dz * dz);
                targetX = this.ghast.m_20185_() + dx / length * (currentDistance - 35.0);
                targetY = this.ghast.m_20186_() + dy / length * (currentDistance - 35.0);
                targetZ = this.ghast.m_20189_() + dz / length * (currentDistance - 35.0);
            } else {
                double angle = random.m_188500_() * Math.PI * 2.0;
                double distance = 17.5;
                targetX = target.m_20185_() + Math.cos(angle) * distance;
                targetY = target.m_20186_() + (double)(random.m_188501_() * 6.0f - 3.0f);
                targetZ = target.m_20189_() + Math.sin(angle) * distance;
            }
            this.ghast.m_21566_().m_6849_(targetX, targetY, targetZ, 1.0);
        }
    }

    static class RandomFloatAroundGoal
    extends Goal {
        private final MotherGhastEntity ghast;

        public RandomFloatAroundGoal(MotherGhastEntity ghast) {
            this.ghast = ghast;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double deltaZ;
            double deltaY;
            if (this.ghast.m_5448_() != null) {
                return false;
            }
            MoveControl moveControl = this.ghast.m_21566_();
            if (!moveControl.m_24995_()) {
                return true;
            }
            double deltaX = moveControl.m_25000_() - this.ghast.m_20185_();
            double distanceSq = deltaX * deltaX + (deltaY = moveControl.m_25001_() - this.ghast.m_20186_()) * deltaY + (deltaZ = moveControl.m_25002_() - this.ghast.m_20189_()) * deltaZ;
            return distanceSq < 1.0 || distanceSq > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.ghast.m_217043_();
            double d0 = this.ghast.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.ghast.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.ghast.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            this.ghast.m_21566_().m_6849_(d0, d1, d2, 1.0);
        }
    }

    static class MotherGhastLookGoal
    extends Goal {
        private final MotherGhastEntity ghast;

        public MotherGhastLookGoal(MotherGhastEntity ghast) {
            this.ghast = ghast;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.ghast.m_5448_() == null) {
                Vec3 deltaMovement = this.ghast.m_20184_();
                this.ghast.m_146922_(-((float)Mth.m_14136_((double)deltaMovement.f_82479_, (double)deltaMovement.f_82481_)) * 57.295776f);
                this.ghast.f_20883_ = this.ghast.m_146908_();
            } else {
                LivingEntity target = this.ghast.m_5448_();
                if (target.m_20280_((Entity)this.ghast) < 4096.0) {
                    double deltaX = target.m_20185_() - this.ghast.m_20185_();
                    double deltaZ = target.m_20189_() - this.ghast.m_20189_();
                    this.ghast.m_146922_(-((float)Mth.m_14136_((double)deltaX, (double)deltaZ)) * 57.295776f);
                    this.ghast.f_20883_ = this.ghast.m_146908_();
                }
            }
        }
    }
}

