/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.entity.monster.SignalBeaconEntity;
import top.ribs.scguns.init.ModEntities;

public class BeaconProjectileEntity
extends Projectile {
    private static final EntityDataAccessor<Float> TARGET_X = SynchedEntityData.m_135353_(BeaconProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> TARGET_Z = SynchedEntityData.m_135353_(BeaconProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> HAS_LANDED = SynchedEntityData.m_135353_(BeaconProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int ticksInFlight = 0;
    private static final int MAX_FLIGHT_TIME = 100;
    private boolean hasWarned = false;

    public BeaconProjectileEntity(EntityType<? extends BeaconProjectileEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BeaconProjectileEntity(EntityType<? extends BeaconProjectileEntity> pEntityType, Level pLevel, LivingEntity pShooter) {
        this(pEntityType, pLevel);
        this.m_5602_((Entity)pShooter);
        this.m_6034_(pShooter.m_20185_(), pShooter.m_20188_() - 0.1, pShooter.m_20189_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TARGET_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TARGET_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HAS_LANDED, (Object)false);
    }

    public void setLandingTarget(double targetX, double targetZ) {
        this.f_19804_.m_135381_(TARGET_X, (Object)Float.valueOf((float)targetX));
        this.f_19804_.m_135381_(TARGET_Z, (Object)Float.valueOf((float)targetZ));
    }

    public void m_8119_() {
        super.m_8119_();
        if (((Boolean)this.f_19804_.m_135370_(HAS_LANDED)).booleanValue()) {
            return;
        }
        ++this.ticksInFlight;
        Vec3 movement = this.m_20184_();
        this.m_20334_(movement.f_82479_, movement.f_82480_ - 0.05, movement.f_82481_);
        if (this.m_20096_() || this.ticksInFlight >= 100 || this.m_20186_() <= (double)this.m_9236_().m_141937_()) {
            this.landAndSpawnBeacon();
            return;
        }
        if (!this.m_9236_().f_46443_) {
            Vec3 currentPos = this.m_20182_();
            Vec3 nextPos = currentPos.m_82549_(this.m_20184_());
            BlockPos nextBlockPos = new BlockPos((int)nextPos.f_82479_, (int)nextPos.f_82480_, (int)nextPos.f_82481_);
            if (!this.m_9236_().m_8055_(nextBlockPos).m_60795_()) {
                this.landAndSpawnBeacon();
                return;
            }
            if (this.m_20184_().f_82480_ < 0.0) {
                BlockPos belowPos = new BlockPos((int)currentPos.f_82479_, (int)(currentPos.f_82480_ - 0.5), (int)currentPos.f_82481_);
                if (!this.m_9236_().m_8055_(belowPos).m_60795_()) {
                    this.landAndSpawnBeacon();
                    return;
                }
            }
        }
        Vec3 newMovement = this.m_20184_();
        this.m_6034_(this.m_20185_() + newMovement.f_82479_, this.m_20186_() + newMovement.f_82480_, this.m_20189_() + newMovement.f_82481_);
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            if (this.f_19796_.m_188503_(2) == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 0.3, this.m_20186_() + (this.f_19796_.m_188500_() - 0.5) * 0.3, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 0.3, 0.0, 0.05, 0.0);
            }
        }
        if (!this.m_9236_().f_46443_ && !this.hasWarned && this.ticksInFlight > 20) {
            float targetX = ((Float)this.f_19804_.m_135370_(TARGET_X)).floatValue();
            float targetZ = ((Float)this.f_19804_.m_135370_(TARGET_Z)).floatValue();
            double distanceToTarget = Math.sqrt(Math.pow(this.m_20185_() - (double)targetX, 2.0) + Math.pow(this.m_20189_() - (double)targetZ, 2.0));
            if (distanceToTarget < 15.0 || this.m_20184_().f_82480_ < -0.3) {
                this.showLandingWarning(targetX, targetZ);
                this.hasWarned = true;
            }
        }
    }

    private void showLandingWarning(double targetX, double targetZ) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double groundY = this.findGroundLevel(targetX, targetZ);
            for (int i = 0; i < 20; ++i) {
                double angle = (double)i / 20.0 * Math.PI * 2.0;
                double radius = 3.0;
                double warningX = targetX + Math.cos(angle) * radius;
                double warningZ = targetZ + Math.sin(angle) * radius;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, warningX, groundY + 0.5, warningZ, 2, 0.1, 0.5, 0.1, 0.05);
            }
            this.m_9236_().m_6263_(null, targetX, groundY, targetZ, (SoundEvent)SoundEvents.f_12210_.get(), SoundSource.HOSTILE, 1.0f, 1.5f);
        }
    }

    private double findGroundLevel(double x, double z) {
        for (int y = (int)this.m_20186_(); y > this.m_9236_().m_141937_(); --y) {
            if (this.m_9236_().m_8055_(new BlockPos((int)x, y, (int)z)).m_60795_()) continue;
            return y + 1;
        }
        return this.m_20186_();
    }

    private void landAndSpawnBeacon() {
        if (((Boolean)this.f_19804_.m_135370_(HAS_LANDED)).booleanValue()) {
            return;
        }
        this.f_19804_.m_135381_(HAS_LANDED, (Object)true);
        if (!this.m_9236_().f_46443_) {
            double landX = this.m_20185_();
            double landZ = this.m_20189_();
            double landY = this.findGroundLevel(landX, landZ);
            SignalBeaconEntity beacon = new SignalBeaconEntity((EntityType<? extends Mob>)((EntityType)ModEntities.SIGNAL_BEACON.get()), this.m_9236_());
            beacon.m_7678_(landX, landY, landZ, this.f_19796_.m_188501_() * 360.0f, 0.0f);
            this.m_9236_().m_7967_((Entity)beacon);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                double offsetZ;
                double offsetY;
                double offsetX;
                int i;
                ServerLevel serverLevel = (ServerLevel)level;
                for (i = 0; i < 25; ++i) {
                    offsetX = (this.f_19796_.m_188500_() - 0.5) * 3.0;
                    offsetY = this.f_19796_.m_188500_() * 2.0;
                    offsetZ = (this.f_19796_.m_188500_() - 0.5) * 3.0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, landX + offsetX, landY + offsetY, landZ + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
                for (i = 0; i < 30; ++i) {
                    offsetX = (this.f_19796_.m_188500_() - 0.5) * 4.0;
                    offsetY = this.f_19796_.m_188500_() * 1.5;
                    offsetZ = (this.f_19796_.m_188500_() - 0.5) * 4.0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, landX + offsetX, landY + offsetY, landZ + offsetZ, 1, 0.2, 0.1, 0.2, 0.1);
                }
            }
            this.m_9236_().m_6263_(null, landX, landY, landZ, SoundEvents.f_11913_, SoundSource.HOSTILE, 1.5f, 0.8f);
            this.m_9236_().m_6263_(null, landX, landY, landZ, SoundEvents.f_11668_, SoundSource.HOSTILE, 0.8f, 1.2f);
        }
        this.m_146870_();
    }

    protected void m_6532_(@NotNull HitResult pResult) {
        super.m_6532_(pResult);
        if (!this.m_9236_().f_46443_ && !((Boolean)this.f_19804_.m_135370_(HAS_LANDED)).booleanValue()) {
            this.landAndSpawnBeacon();
        }
    }

    public boolean m_6087_() {
        return (Boolean)this.f_19804_.m_135370_(HAS_LANDED) == false;
    }

    public float m_6143_() {
        return 1.0f;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6783_(double pDistance) {
        return pDistance < 16384.0;
    }

    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("ticksInFlight", this.ticksInFlight);
        pCompound.m_128350_("targetX", ((Float)this.f_19804_.m_135370_(TARGET_X)).floatValue());
        pCompound.m_128350_("targetZ", ((Float)this.f_19804_.m_135370_(TARGET_Z)).floatValue());
        pCompound.m_128379_("hasLanded", ((Boolean)this.f_19804_.m_135370_(HAS_LANDED)).booleanValue());
        pCompound.m_128379_("hasWarned", this.hasWarned);
    }

    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.ticksInFlight = pCompound.m_128451_("ticksInFlight");
        this.f_19804_.m_135381_(TARGET_X, (Object)Float.valueOf(pCompound.m_128457_("targetX")));
        this.f_19804_.m_135381_(TARGET_Z, (Object)Float.valueOf(pCompound.m_128457_("targetZ")));
        this.f_19804_.m_135381_(HAS_LANDED, (Object)pCompound.m_128471_("hasLanded"));
        this.hasWarned = pCompound.m_128471_("hasWarned");
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

