/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.common.exosuit;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitUpgrade;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.item.exosuit.EnergyUpgradeItem;

public class ExoSuitPowerManager {
    private static final String POWER_STATES_TAG = "ExoSuitPowerStates";
    private static final Map<UUID, Map<String, Integer>> playerCooldowns = new HashMap<UUID, Map<String, Integer>>();

    public static boolean consumeEnergy(Player player, String upgradeType, int energyRequired) {
        ItemStack chestplate = ExoSuitPowerManager.getEquippedChestplate(player);
        if (chestplate.m_41619_()) {
            return false;
        }
        ItemStack powerCore = ExoSuitPowerManager.findPowerCore(chestplate);
        if (powerCore.m_41619_()) {
            return false;
        }
        CompoundTag powerCoreTag = powerCore.m_41784_();
        int currentEnergy = powerCoreTag.m_128451_("Energy");
        if (currentEnergy >= energyRequired) {
            powerCoreTag.m_128405_("Energy", currentEnergy - energyRequired);
            ExoSuitPowerManager.updatePowerCoreInChestplate(chestplate, powerCore);
            return true;
        }
        ExoSuitPowerManager.sendPowerShortageNotification(player, upgradeType);
        return false;
    }

    private static void updatePowerCoreInChestplate(ItemStack chestplate, ItemStack updatedPowerCore) {
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(chestplate, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("power_core")) continue;
            CompoundTag upgradeData = ExoSuitData.getUpgradeData(chestplate);
            if (!upgradeData.m_128441_("Upgrades")) break;
            ListTag upgradeList = upgradeData.m_128437_("Upgrades", 10);
            for (int i = 0; i < upgradeList.size(); ++i) {
                CompoundTag slotTag = upgradeList.m_128728_(i);
                if (slotTag.m_128451_("Slot") != slot) continue;
                slotTag.m_128365_("Item", (Tag)updatedPowerCore.m_41739_(new CompoundTag()));
                break;
            }
            ExoSuitData.setUpgradeData(chestplate, upgradeData);
            break;
        }
    }

    public static boolean consumeEnergyForUpgrade(Player player, String upgradeType, ItemStack upgradeItem) {
        ExoSuitUpgrade upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem);
        if (upgrade == null) {
            return false;
        }
        int energyRequired = (int)upgrade.getEffects().getEnergyUse();
        return ExoSuitPowerManager.consumeEnergy(player, upgradeType, energyRequired);
    }

    public static boolean canUpgradeFunction(Player player, String upgradeType) {
        ItemStack armorPiece = ExoSuitPowerManager.getArmorPieceForUpgradeType(player, upgradeType);
        if (armorPiece.m_41619_()) {
            return false;
        }
        ItemStack upgradeItem = ExoSuitPowerManager.findUpgradeByType(armorPiece, upgradeType);
        if (upgradeItem.m_41619_()) {
            return false;
        }
        Item item = upgradeItem.m_41720_();
        if (item instanceof EnergyUpgradeItem) {
            EnergyUpgradeItem energyUpgrade = (EnergyUpgradeItem)item;
            if (energyUpgrade.canFunctionWithoutPower()) {
                return true;
            }
            ExoSuitUpgrade upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem);
            if (upgrade == null) {
                return false;
            }
            int energyRequired = (int)upgrade.getEffects().getEnergyUse();
            ItemStack chestplate = ExoSuitPowerManager.getEquippedChestplate(player);
            if (chestplate.m_41619_()) {
                return false;
            }
            ItemStack powerCore = ExoSuitPowerManager.findPowerCore(chestplate);
            if (powerCore.m_41619_()) {
                return false;
            }
            CompoundTag powerCoreTag = powerCore.m_41783_();
            int currentEnergy = powerCoreTag != null ? powerCoreTag.m_128451_("Energy") : 0;
            return currentEnergy >= energyRequired;
        }
        return true;
    }

    public static boolean isPowerEnabled(Player player, String upgradeType) {
        ItemStack armorPiece = ExoSuitPowerManager.getArmorPieceForUpgradeType(player, upgradeType);
        if (armorPiece.m_41619_()) {
            return false;
        }
        CompoundTag powerStates = ExoSuitPowerManager.getPowerStates(armorPiece);
        return powerStates.m_128471_(upgradeType);
    }

    public static void setPowerEnabled(Player player, String upgradeType, boolean enabled) {
        ItemStack armorPiece = ExoSuitPowerManager.getArmorPieceForUpgradeType(player, upgradeType);
        if (armorPiece.m_41619_()) {
            return;
        }
        CompoundTag powerStates = ExoSuitPowerManager.getPowerStates(armorPiece);
        powerStates.m_128379_(upgradeType, enabled);
        ExoSuitPowerManager.setPowerStates(armorPiece, powerStates);
    }

    public static boolean togglePower(Player player, String upgradeType) {
        boolean currentState = ExoSuitPowerManager.isPowerEnabled(player, upgradeType);
        boolean newState = !currentState;
        ExoSuitPowerManager.setPowerEnabled(player, upgradeType, newState);
        return newState;
    }

    public static boolean canConsumeEnergy(Player player, String upgradeType, int cooldownTicks) {
        int currentTick = player.f_19797_;
        UUID playerId = player.m_20148_();
        Map upgradeCooldowns = playerCooldowns.computeIfAbsent(playerId, k -> new HashMap());
        int lastConsumption = upgradeCooldowns.getOrDefault(upgradeType, 0);
        if (currentTick - lastConsumption >= cooldownTicks) {
            upgradeCooldowns.put(upgradeType, currentTick);
            return false;
        }
        return true;
    }

    private static ItemStack getArmorPieceForUpgradeType(Player player, String upgradeType) {
        return switch (upgradeType) {
            case "hud", "breathing", "night_vision" -> ExoSuitPowerManager.getEquippedHelmet(player);
            case "pauldron", "power_core", "utility" -> ExoSuitPowerManager.getEquippedChestplate(player);
            case "knee_guard" -> ExoSuitPowerManager.getEquippedLeggings(player);
            case "mobility" -> ExoSuitPowerManager.getEquippedBoots(player);
            default -> ItemStack.f_41583_;
        };
    }

    private static ItemStack getEquippedHelmet(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.HELMET) continue;
            return armorStack;
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack getEquippedChestplate(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.CHESTPLATE) continue;
            return armorStack;
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack getEquippedLeggings(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.LEGGINGS) continue;
            return armorStack;
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack getEquippedBoots(Player player) {
        for (ItemStack armorStack : player.m_6168_()) {
            ExoSuitItem exosuit;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ExoSuitItem) || (exosuit = (ExoSuitItem)item).m_266204_() != ArmorItem.Type.BOOTS) continue;
            return armorStack;
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack findPowerCore(ItemStack chestplate) {
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(chestplate, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals("power_core")) continue;
            return upgradeItem;
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack findUpgradeByType(ItemStack armorPiece, String upgradeType) {
        for (int slot = 0; slot < 4; ++slot) {
            ExoSuitUpgrade upgrade;
            ItemStack upgradeItem = ExoSuitData.getUpgradeInSlot(armorPiece, slot);
            if (upgradeItem.m_41619_() || (upgrade = ExoSuitUpgradeManager.getUpgradeForItem(upgradeItem)) == null || !upgrade.getType().equals(upgradeType)) continue;
            return upgradeItem;
        }
        return ItemStack.f_41583_;
    }

    private static CompoundTag getPowerStates(ItemStack armorPiece) {
        CompoundTag upgradeData = ExoSuitData.getUpgradeData(armorPiece);
        return upgradeData.m_128469_(POWER_STATES_TAG);
    }

    private static void setPowerStates(ItemStack armorPiece, CompoundTag powerStates) {
        CompoundTag upgradeData = ExoSuitData.getUpgradeData(armorPiece);
        upgradeData.m_128365_(POWER_STATES_TAG, (Tag)powerStates);
        ExoSuitData.setUpgradeData(armorPiece, upgradeData);
    }

    public static void cleanupPlayerData(UUID playerId) {
        playerCooldowns.remove(playerId);
    }

    private static void sendPowerShortageNotification(Player player, String upgradeType) {
        if (ExoSuitPowerManager.canConsumeEnergy(player, upgradeType + "_notification", 800)) {
            return;
        }
        MutableComponent feedbackMessage = Component.m_237115_((String)"exosuit.message.prefix").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237110_((String)"exosuit.message.power_shortage", (Object[])new Object[]{Component.m_237115_((String)("exosuit.upgrade." + upgradeType))}).m_130940_(ChatFormatting.RED));
        player.m_213846_((Component)feedbackMessage);
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 0.3f, 0.6f);
    }
}

