/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.render.gun.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.ribs.scguns.client.SpecialModels;
import top.ribs.scguns.client.render.gun.IOverrideModel;
import top.ribs.scguns.client.util.RenderUtil;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.event.GunFireEvent;
import top.ribs.scguns.init.ModItems;
import top.ribs.scguns.item.attachment.IAttachment;

public class MangalitsaModel
implements IOverrideModel {
    private static final float BOLT_MOVEMENT_DISTANCE = 1.0f;

    @Override
    public void render(float partialTicks, ItemDisplayContext transformType, ItemStack stack, ItemStack parent, LivingEntity entity, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        RenderUtil.renderModel(SpecialModels.MANGALITSA_MAIN.getModel(), stack, matrixStack, buffer, light, overlay);
        if (Gun.getScope(stack) == null) {
            RenderUtil.renderModel(SpecialModels.MANGALITSA_SIGHTS.getModel(), stack, matrixStack, buffer, light, overlay);
        } else {
            RenderUtil.renderModel(SpecialModels.MANGALITSA_NO_SIGHTS.getModel(), stack, matrixStack, buffer, light, overlay);
        }
        this.renderStockAttachments(stack, matrixStack, buffer, light, overlay);
        this.renderBarrelAndAttachments(stack, matrixStack, buffer, light, overlay);
        if (entity.equals((Object)Minecraft.m_91087_().f_91074_)) {
            this.renderAnimatedParts(stack, matrixStack, buffer, light, overlay);
        }
        this.renderNonAnimatedUnderbarrelAttachments(stack, matrixStack, buffer, light, overlay);
    }

    private void renderStockAttachments(ItemStack stack, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.STOCK)) {
            if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.WEIGHTED_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.MANGALITSA_STOCK_HEAVY.getModel(), stack, matrixStack, buffer, light, overlay);
            }
            if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.BUMP_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.MANGALITSA_STOCK_HEAVY.getModel(), stack, matrixStack, buffer, light, overlay);
            }
            if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.LIGHT_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.MANGALITSA_STOCK_LIGHT.getModel(), stack, matrixStack, buffer, light, overlay);
            }
            if (Gun.getAttachment(IAttachment.Type.STOCK, stack).m_41720_() == ModItems.WOODEN_STOCK.get()) {
                RenderUtil.renderModel(SpecialModels.MANGALITSA_STOCK_WOODEN.getModel(), stack, matrixStack, buffer, light, overlay);
            }
        } else {
            RenderUtil.renderModel(SpecialModels.MANGALITSA_STAN_GRIP.getModel(), stack, matrixStack, buffer, light, overlay);
        }
    }

    private void renderBarrelAndAttachments(ItemStack stack, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        boolean hasExtendedBarrel = false;
        if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.BARREL)) {
            if (Gun.getAttachment(IAttachment.Type.BARREL, stack).m_41720_() == ModItems.EXTENDED_BARREL.get()) {
                RenderUtil.renderModel(SpecialModels.MANGALITSA_EXT_BARREL.getModel(), stack, matrixStack, buffer, light, overlay);
                hasExtendedBarrel = true;
            } else if (Gun.getAttachment(IAttachment.Type.BARREL, stack).m_41720_() == ModItems.SILENCER.get()) {
                RenderUtil.renderModel(SpecialModels.MANGALITSA_SILENCER.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.BARREL, stack).m_41720_() == ModItems.MUZZLE_BRAKE.get()) {
                RenderUtil.renderModel(SpecialModels.MANGALITSA_MUZZLE_BRAKE.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.BARREL, stack).m_41720_() == ModItems.ADVANCED_SILENCER.get()) {
                RenderUtil.renderModel(SpecialModels.MANGALITSA_ADVANCED_SILENCER.getModel(), stack, matrixStack, buffer, light, overlay);
            }
        }
        if (!hasExtendedBarrel) {
            RenderUtil.renderModel(SpecialModels.MANGALITSA_STAN_BARREL.getModel(), stack, matrixStack, buffer, light, overlay);
        }
    }

    private void renderAnimatedParts(ItemStack stack, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, -0.3625, 0.0);
        ItemCooldowns tracker = Minecraft.m_91087_().f_91074_.m_36335_();
        float cooldown = tracker.m_41521_(stack.m_41720_(), Minecraft.m_91087_().m_91296_());
        cooldown = (float)this.ease(cooldown);
        matrixStack.m_252880_(0.0f, 0.0f, cooldown / 8.0f);
        matrixStack.m_85837_(0.0, 0.3625, 0.0);
        RenderUtil.renderModel(SpecialModels.MANGALITSA_BOLT.getModel(), stack, matrixStack, buffer, light, overlay);
        this.renderAnimatedUnderbarrelAttachments(stack, matrixStack, buffer, light, overlay);
        matrixStack.m_85849_();
    }

    private void renderAnimatedUnderbarrelAttachments(ItemStack stack, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.UNDER_BARREL)) {
            if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.VERTICAL_GRIP.get()) {
                RenderUtil.renderModel(SpecialModels.MANGALITSA_TACT_GRIP.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.LIGHT_GRIP.get()) {
                RenderUtil.renderModel(SpecialModels.MANGALITSA_LIGHT_GRIP.getModel(), stack, matrixStack, buffer, light, overlay);
            }
        }
    }

    private void renderNonAnimatedUnderbarrelAttachments(ItemStack stack, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        if (Gun.hasAttachmentEquipped(stack, IAttachment.Type.UNDER_BARREL)) {
            if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.IRON_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.MANGALITSA_IRON_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.ANTHRALITE_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.MANGALITSA_ANTHRALITE_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.DIAMOND_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.MANGALITSA_DIAMOND_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).m_41720_() == ModItems.NETHERITE_BAYONET.get()) {
                RenderUtil.renderModel(SpecialModels.MANGALITSA_NETHERITE_BAYONET.getModel(), stack, matrixStack, buffer, light, overlay);
            }
        }
    }

    public static float getBoltMovementDistance() {
        return 1.0f;
    }

    private double ease(double x) {
        return 1.0 - Math.pow(1.0 - 2.0 * x, 4.0);
    }

    @Mod.EventBusSubscriber(modid="scguns", value={Dist.CLIENT})
    public static class GunFireEventCombatShotgunHandler {
        private static float pumpProgress = 0.0f;

        @SubscribeEvent
        public static void onGunFire(GunFireEvent.Post event) {
            if (event.isClient()) {
                pumpProgress = 1.0f;
            }
        }

        public static float getPumpProgress(float partialTicks) {
            return pumpProgress > 0.0f ? (pumpProgress = pumpProgress - partialTicks * 0.1f) : 0.0f;
        }
    }
}

