/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class BeamRenderer {
    private static final ResourceLocation BEAM_LOCATION = new ResourceLocation("textures/entity/beacon_beam.png");

    public static void renderBeam(PoseStack pPoseStack, MultiBufferSource pBuffer, float partialTicks, Vec3 start, Vec3 end, Vec3 lastStart, Vec3 lastEnd, float[] color, float fadeProgress) {
        Vec3 interpolatedStart = BeamRenderer.lerpVec3(partialTicks, lastStart, start);
        Vec3 interpolatedEnd = BeamRenderer.lerpVec3(partialTicks, lastEnd, end);
        Vec3 beamVec = interpolatedEnd.m_82546_(interpolatedStart);
        float length = (float)beamVec.m_82553_();
        Vec3 beamNormal = beamVec.m_82541_();
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(interpolatedStart.f_82479_, interpolatedStart.f_82480_, interpolatedStart.f_82481_);
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        Vec3 axis = up.m_82537_(beamNormal);
        float angle = (float)Math.acos(up.m_82526_(beamNormal));
        if (!axis.equals((Object)Vec3.f_82478_)) {
            pPoseStack.m_252781_(Axis.m_253057_((Vector3f)new Vector3f((float)axis.f_82479_, (float)axis.f_82480_, (float)axis.f_82481_)).m_252977_((float)Math.toDegrees(angle)));
        }
        assert (Minecraft.m_91087_().f_91073_ != null);
        BeamRenderer.renderBeamSegment(pPoseStack, pBuffer, partialTicks, Minecraft.m_91087_().f_91073_.m_46467_(), 0.0f, length, color);
        pPoseStack.m_85849_();
    }

    public static Vec3 lerpVec3(float partialTicks, Vec3 lastPos, Vec3 currentPos) {
        double x = Mth.m_14139_((double)partialTicks, (double)lastPos.f_82479_, (double)currentPos.f_82479_);
        double y = Mth.m_14139_((double)partialTicks, (double)lastPos.f_82480_, (double)currentPos.f_82480_);
        double z = Mth.m_14139_((double)partialTicks, (double)lastPos.f_82481_, (double)currentPos.f_82481_);
        return new Vec3(x, y, z);
    }

    public static void renderBeamSegment(PoseStack pPoseStack, MultiBufferSource pBufferSource, float pPartialTick, long pGameTime, float pYOffset, float pHeight, float[] pColors) {
        BeamRenderer.renderBeamPart(pPoseStack, pBufferSource, BEAM_LOCATION, pPartialTick, 1.0f, pGameTime, 0, Math.round(pHeight), pColors, 0.015f, 0.02f);
    }

    public static void renderBeamPart(PoseStack pPoseStack, MultiBufferSource pBufferSource, ResourceLocation pBeamLocation, float pPartialTick, float pTextureScale, long pGameTime, int pYOffset, int pHeight, float[] pColors, float pBeamRadius, float pGlowRadius) {
        int maxY = pYOffset + pHeight;
        pPoseStack.m_85836_();
        float f = (float)Math.floorMod(pGameTime, 40) + pPartialTick;
        float f1 = pHeight < 0 ? f : -f;
        float f2 = Mth.m_14187_((float)(f1 * 0.2f - (float)Mth.m_14143_((float)(f1 * 0.1f))));
        float r = pColors[0];
        float g = pColors[1];
        float b = pColors[2];
        pPoseStack.m_85836_();
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(f * 2.25f - 45.0f));
        float f6 = 0.0f;
        float f8 = 0.0f;
        float f9 = -pBeamRadius;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = -pBeamRadius;
        float f16 = 0.0f;
        float f17 = 1.0f;
        float f18 = -1.0f + f2;
        float f19 = (float)pHeight * pTextureScale * (0.5f / pBeamRadius) + f18;
        BeamRenderer.renderPart(pPoseStack, pBufferSource.m_6299_(RenderType.m_110460_((ResourceLocation)pBeamLocation, (boolean)false)), r, g, b, 1.0f, pYOffset, maxY, 0.0f, pBeamRadius, pBeamRadius, 0.0f, f9, 0.0f, 0.0f, f15, 0.0f, 1.0f, f19, f18);
        pPoseStack.m_85849_();
        f6 = -pGlowRadius;
        float f7 = -pGlowRadius;
        f8 = -pGlowRadius;
        f9 = -pGlowRadius;
        f16 = 0.0f;
        f17 = 1.0f;
        f18 = -1.0f + f2;
        f19 = (float)pHeight * pTextureScale + f18;
        BeamRenderer.renderPart(pPoseStack, pBufferSource.m_6299_(RenderType.m_110460_((ResourceLocation)pBeamLocation, (boolean)true)), r, g, b, 0.125f, pYOffset, maxY, f6, f7, pGlowRadius, f8, f9, pGlowRadius, pGlowRadius, pGlowRadius, 0.0f, 1.0f, f19, f18);
        pPoseStack.m_85849_();
    }

    private static void renderPart(PoseStack pPoseStack, VertexConsumer pConsumer, float pRed, float pGreen, float pBlue, float pAlpha, int pMinY, int pMaxY, float pX0, float pZ0, float pX1, float pZ1, float pX2, float pZ2, float pX3, float pZ3, float pMinU, float pMaxU, float pMinV, float pMaxV) {
        PoseStack.Pose pose = pPoseStack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        BeamRenderer.renderQuad(matrix4f, matrix3f, pConsumer, pRed, pGreen, pBlue, pAlpha, pMinY, pMaxY, pX0, pZ0, pX1, pZ1, pMinU, pMaxU, pMinV, pMaxV);
        BeamRenderer.renderQuad(matrix4f, matrix3f, pConsumer, pRed, pGreen, pBlue, pAlpha, pMinY, pMaxY, pX3, pZ3, pX2, pZ2, pMinU, pMaxU, pMinV, pMaxV);
        BeamRenderer.renderQuad(matrix4f, matrix3f, pConsumer, pRed, pGreen, pBlue, pAlpha, pMinY, pMaxY, pX1, pZ1, pX3, pZ3, pMinU, pMaxU, pMinV, pMaxV);
        BeamRenderer.renderQuad(matrix4f, matrix3f, pConsumer, pRed, pGreen, pBlue, pAlpha, pMinY, pMaxY, pX2, pZ2, pX0, pZ0, pMinU, pMaxU, pMinV, pMaxV);
    }

    private static void renderQuad(Matrix4f pPose, Matrix3f pNormal, VertexConsumer pConsumer, float pRed, float pGreen, float pBlue, float pAlpha, int pMinY, int pMaxY, float pMinX, float pMinZ, float pMaxX, float pMaxZ, float pMinU, float pMaxU, float pMinV, float pMaxV) {
        BeamRenderer.addVertex(pPose, pNormal, pConsumer, pRed, pGreen, pBlue, pAlpha, pMaxY, pMinX, pMinZ, pMaxU, pMinV);
        BeamRenderer.addVertex(pPose, pNormal, pConsumer, pRed, pGreen, pBlue, pAlpha, pMinY, pMinX, pMinZ, pMaxU, pMaxV);
        BeamRenderer.addVertex(pPose, pNormal, pConsumer, pRed, pGreen, pBlue, pAlpha, pMinY, pMaxX, pMaxZ, pMinU, pMaxV);
        BeamRenderer.addVertex(pPose, pNormal, pConsumer, pRed, pGreen, pBlue, pAlpha, pMaxY, pMaxX, pMaxZ, pMinU, pMinV);
    }

    private static void addVertex(Matrix4f pPose, Matrix3f pNormal, VertexConsumer pConsumer, float pRed, float pGreen, float pBlue, float pAlpha, int pY, float pX, float pZ, float pU, float pV) {
        pConsumer.m_252986_(pPose, pX, (float)pY, pZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_7421_(pU, pV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

