/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.ribs.scguns.entity.block.PrimedPowderKeg;
import top.ribs.scguns.init.ModBlocks;

@OnlyIn(value=Dist.CLIENT)
public class PowderKegRenderer
extends EntityRenderer<PrimedPowderKeg> {
    private final BlockRenderDispatcher blockRenderer;

    public PowderKegRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.5f;
        this.blockRenderer = context.m_234597_();
    }

    public void render(PrimedPowderKeg entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.5f, 0.0f);
        int fuse = entity.getFuse();
        if ((float)fuse - partialTicks + 1.0f < 10.0f) {
            float scale = 1.0f - ((float)fuse - partialTicks + 1.0f) / 10.0f;
            scale = Mth.m_14036_((float)scale, (float)0.0f, (float)1.0f);
            scale *= scale;
            scale *= scale;
            float scaleFactor = 1.0f + scale * 0.3f;
            poseStack.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
        poseStack.m_252880_(-0.5f, -0.5f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        BlockState powderKegState = ((Block)ModBlocks.POWDER_KEG.get()).m_49966_();
        this.renderBlock(powderKegState, poseStack, buffer, packedLight, fuse / 5 % 2 == 0);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void renderBlock(BlockState state, PoseStack poseStack, MultiBufferSource buffer, int packedLight, boolean flash) {
        if (flash) {
            int flashColor = OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)1.0f), (int)10);
            this.blockRenderer.m_110912_(state, poseStack, buffer, packedLight, flashColor);
        } else {
            this.blockRenderer.m_110912_(state, poseStack, buffer, packedLight, OverlayTexture.f_118083_);
        }
    }

    public ResourceLocation getTextureLocation(PrimedPowderKeg entity) {
        return TextureAtlas.f_118259_;
    }
}

