/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.client.network;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animation.AnimationController;
import top.ribs.scguns.Config;
import top.ribs.scguns.client.BulletTrail;
import top.ribs.scguns.client.CustomGunManager;
import top.ribs.scguns.client.audio.GunShotSound;
import top.ribs.scguns.client.handler.BeamHandler;
import top.ribs.scguns.client.handler.BulletTrailRenderingHandler;
import top.ribs.scguns.client.handler.GunRenderingHandler;
import top.ribs.scguns.client.handler.HUDRenderHandler;
import top.ribs.scguns.client.particle.BloodParticle;
import top.ribs.scguns.common.Gun;
import top.ribs.scguns.common.NetworkGunManager;
import top.ribs.scguns.common.exosuit.ExoSuitData;
import top.ribs.scguns.common.exosuit.ExoSuitUpgradeManager;
import top.ribs.scguns.init.ModParticleTypes;
import top.ribs.scguns.init.ModSyncedDataKeys;
import top.ribs.scguns.item.GunItem;
import top.ribs.scguns.item.animated.AnimatedGunItem;
import top.ribs.scguns.item.animated.ExoSuitItem;
import top.ribs.scguns.network.message.S2CMessageBeamPenetration;
import top.ribs.scguns.network.message.S2CMessageBeamUpdate;
import top.ribs.scguns.network.message.S2CMessageBlood;
import top.ribs.scguns.network.message.S2CMessageBulletTrail;
import top.ribs.scguns.network.message.S2CMessageDualWieldShotCount;
import top.ribs.scguns.network.message.S2CMessageEntityCasingEject;
import top.ribs.scguns.network.message.S2CMessageGunSound;
import top.ribs.scguns.network.message.S2CMessageProjectileHitBlock;
import top.ribs.scguns.network.message.S2CMessageProjectileHitEntity;
import top.ribs.scguns.network.message.S2CMessageRaidFlareBurst;
import top.ribs.scguns.network.message.S2CMessageRemoveProjectile;
import top.ribs.scguns.network.message.S2CMessageStopBeam;
import top.ribs.scguns.network.message.S2CMessageStopReload;
import top.ribs.scguns.network.message.S2CMessageStunGrenade;
import top.ribs.scguns.network.message.S2CMessageSyncExoSuitUpgrades;
import top.ribs.scguns.network.message.S2CMessageSyncUpgradeRegistry;
import top.ribs.scguns.network.message.S2CMessageUpdateGuns;
import top.ribs.scguns.particles.BulletHoleData;

public class ClientPlayHandler {
    public static void handleEntityCasingEject(S2CMessageEntityCasingEject message) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(message.getEntityId());
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        Vec3 lookVec = livingEntity.m_20154_();
        Vec3 rightVec = new Vec3(-lookVec.f_82481_, 0.0, lookVec.f_82479_).m_82541_();
        Vec3 forwardVec = new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_).m_82541_();
        double offsetX = rightVec.f_82479_ * 0.5 + forwardVec.f_82479_ * 0.5;
        double offsetY = (double)livingEntity.m_20192_() - 0.4;
        double offsetZ = rightVec.f_82481_ * 0.5 + forwardVec.f_82481_ * 0.5;
        Vec3 particlePos = livingEntity.m_20318_(1.0f).m_82520_(offsetX, offsetY, offsetZ);
        ParticleType particleType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(message.getParticleLocation());
        if (particleType instanceof SimpleParticleType) {
            SimpleParticleType simpleParticleType = (SimpleParticleType)particleType;
            level.m_7106_((ParticleOptions)simpleParticleType, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public static void handleRaidFlareBurst(S2CMessageRaidFlareBurst message) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        if (world == null) {
            return;
        }
        double centerX = message.getX();
        double centerY = message.getY();
        double centerZ = message.getZ();
        String patternType = message.getPatternType();
        double scale = message.getScale();
        int repetitions = message.getRepetitions();
        switch (patternType) {
            case "star": {
                ClientPlayHandler.spawnStarPattern((Level)world, centerX, centerY, centerZ, scale, repetitions, message.getParticles());
                break;
            }
            case "circle": {
                ClientPlayHandler.spawnCirclePattern((Level)world, centerX, centerY, centerZ, scale, repetitions, message.getParticles());
                break;
            }
            case "union_jack": {
                ClientPlayHandler.spawnUnionJackPattern((Level)world, centerX, centerY, centerZ, scale, message.getParticles());
                break;
            }
            case "spiral": {
                ClientPlayHandler.spawnSpiralPattern((Level)world, centerX, centerY, centerZ, scale, repetitions, message.getParticles());
                break;
            }
            case "wave": {
                ClientPlayHandler.spawnWavePattern((Level)world, centerX, centerY, centerZ, scale, repetitions, message.getParticles());
                break;
            }
            case "cross": {
                ClientPlayHandler.spawnCrossPattern((Level)world, centerX, centerY, centerZ, scale, message.getParticles());
                break;
            }
            case "double_helix": {
                ClientPlayHandler.spawnDoubleHelixPattern((Level)world, centerX, centerY, centerZ, scale, repetitions, message.getParticles());
                break;
            }
            case "burst": {
                ClientPlayHandler.spawnBurstPattern((Level)world, centerX, centerY, centerZ, scale, repetitions, message.getParticles());
                break;
            }
            case "ring": {
                ClientPlayHandler.spawnRingPattern((Level)world, centerX, centerY, centerZ, scale, repetitions, message.getParticles());
                break;
            }
            case "pig_snout": {
                ClientPlayHandler.spawnPigSnoutPattern((Level)world, centerX, centerY, centerZ, scale, message.getParticles());
                break;
            }
            case "skulk_pulse": {
                ClientPlayHandler.spawnSkulkPulsePattern((Level)world, centerX, centerY, centerZ, scale, repetitions, message.getParticles());
                break;
            }
            default: {
                ClientPlayHandler.spawnDefaultBurst((Level)world, centerX, centerY, centerZ, message.getParticles());
            }
        }
    }

    private static void spawnPigSnoutPattern(Level world, double centerX, double centerY, double centerZ, double scale, List<S2CMessageRaidFlareBurst.ParticleData> particleTypes) {
        double z;
        double x;
        double angle;
        int i;
        int segments = 25;
        double nostrilRadius = scale * 0.25;
        double nostrilOffset = scale * 0.35;
        for (i = 0; i < segments; ++i) {
            angle = Math.PI * 2 * (double)i / (double)segments;
            x = centerX - nostrilOffset + Math.cos(angle) * nostrilRadius;
            z = centerZ + Math.sin(angle) * nostrilRadius;
            ClientPlayHandler.spawnBurstParticlesAt(world, x, centerY, z, particleTypes);
        }
        for (i = 0; i < segments; ++i) {
            angle = Math.PI * 2 * (double)i / (double)segments;
            x = centerX + nostrilOffset + Math.cos(angle) * nostrilRadius;
            z = centerZ + Math.sin(angle) * nostrilRadius;
            ClientPlayHandler.spawnBurstParticlesAt(world, x, centerY, z, particleTypes);
        }
        int outerSegments = 40;
        for (int i2 = 0; i2 < outerSegments; ++i2) {
            double angle2 = Math.PI * 2 * (double)i2 / (double)outerSegments;
            double x2 = centerX + Math.cos(angle2) * scale;
            double z2 = centerZ + Math.sin(angle2) * scale * 0.7;
            ClientPlayHandler.spawnBurstParticlesAt(world, x2, centerY, z2, particleTypes);
        }
    }

    private static void spawnSkulkPulsePattern(Level world, double centerX, double centerY, double centerZ, double scale, int repetitions, List<S2CMessageRaidFlareBurst.ParticleData> particleTypes) {
        int segments = 30;
        for (int rep = 0; rep < repetitions; ++rep) {
            double pulseRadius = scale * (((double)rep + 1.0) / (double)repetitions);
            for (int i = 0; i < segments; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)segments;
                double x = centerX + Math.cos(angle) * pulseRadius;
                double z = centerZ + Math.sin(angle) * pulseRadius;
                ClientPlayHandler.spawnBurstParticlesAt(world, x, centerY, z, particleTypes);
            }
            if (rep % 2 != 0) continue;
            int tendrils = 8;
            for (int t = 0; t < tendrils; ++t) {
                double tendrilAngle = Math.PI * 2 * (double)t / (double)tendrils + (double)rep * 0.3;
                int points = 5;
                for (int p = 0; p < points; ++p) {
                    double distance = pulseRadius + (double)p * scale * 0.2;
                    double x = centerX + Math.cos(tendrilAngle) * distance;
                    double z = centerZ + Math.sin(tendrilAngle) * distance;
                    ClientPlayHandler.spawnBurstParticlesAt(world, x, centerY, z, particleTypes);
                }
            }
        }
    }

    private static void spawnSpiralPattern(Level world, double centerX, double centerY, double centerZ, double radius, int repetitions, List<S2CMessageRaidFlareBurst.ParticleData> particleTypes) {
        int segments = 40;
        for (int rep = 0; rep < repetitions; ++rep) {
            for (int i = 0; i < segments; ++i) {
                double t = (double)i / (double)segments;
                double angle = t * Math.PI * 4.0;
                double r = radius * t;
                double x = centerX + Math.cos(angle) * r;
                double z = centerZ + Math.sin(angle) * r;
                ClientPlayHandler.spawnBurstParticlesAt(world, x, centerY, z, particleTypes);
            }
        }
    }

    private static void spawnWavePattern(Level world, double centerX, double centerY, double centerZ, double scale, int repetitions, List<S2CMessageRaidFlareBurst.ParticleData> particleTypes) {
        int segments = 30;
        for (int rep = 0; rep < repetitions; ++rep) {
            for (int i = 0; i < segments; ++i) {
                double t = (double)i / (double)segments;
                double angle = t * Math.PI * 2.0;
                double waveHeight = Math.sin(angle * 3.0) * scale * 0.3;
                double x = centerX + (t - 0.5) * scale * 2.0;
                double y = centerY + waveHeight;
                double z = centerZ;
                ClientPlayHandler.spawnBurstParticlesAt(world, x, y, z, particleTypes);
                x = centerX;
                z = centerZ + (t - 0.5) * scale * 2.0;
                ClientPlayHandler.spawnBurstParticlesAt(world, x, y, z, particleTypes);
            }
        }
    }

    private static void spawnCrossPattern(Level world, double centerX, double centerY, double centerZ, double scale, List<S2CMessageRaidFlareBurst.ParticleData> particleTypes) {
        int segments = 30;
        for (int i = 0; i < segments; ++i) {
            double t = (double)i / (double)segments;
            double offset = (t - 0.5) * scale * 2.0;
            ClientPlayHandler.spawnBurstParticlesAt(world, centerX + offset, centerY, centerZ, particleTypes);
            ClientPlayHandler.spawnBurstParticlesAt(world, centerX, centerY, centerZ + offset, particleTypes);
        }
    }

    private static void spawnDoubleHelixPattern(Level world, double centerX, double centerY, double centerZ, double radius, int repetitions, List<S2CMessageRaidFlareBurst.ParticleData> particleTypes) {
        int segments = 50;
        for (int rep = 0; rep < repetitions; ++rep) {
            for (int i = 0; i < segments; ++i) {
                double t = (double)i / (double)segments;
                double angle = t * Math.PI * 4.0;
                double height = (t - 0.5) * radius * 2.0;
                double x1 = centerX + Math.cos(angle) * radius * 0.5;
                double z1 = centerZ + Math.sin(angle) * radius * 0.5;
                ClientPlayHandler.spawnBurstParticlesAt(world, x1, centerY + height, z1, particleTypes);
                double x2 = centerX + Math.cos(angle + Math.PI) * radius * 0.5;
                double z2 = centerZ + Math.sin(angle + Math.PI) * radius * 0.5;
                ClientPlayHandler.spawnBurstParticlesAt(world, x2, centerY + height, z2, particleTypes);
            }
        }
    }

    private static void spawnBurstPattern(Level world, double centerX, double centerY, double centerZ, double scale, int repetitions, List<S2CMessageRaidFlareBurst.ParticleData> particleTypes) {
        int rays = 12;
        int pointsPerRay = 8;
        for (int rep = 0; rep < repetitions; ++rep) {
            for (int ray = 0; ray < rays; ++ray) {
                double angle = Math.PI * 2 * (double)ray / (double)rays;
                for (int point = 0; point < pointsPerRay; ++point) {
                    double distance = scale / (double)pointsPerRay * (double)(point + 1);
                    double x = centerX + Math.cos(angle) * distance;
                    double z = centerZ + Math.sin(angle) * distance;
                    ClientPlayHandler.spawnBurstParticlesAt(world, x, centerY, z, particleTypes);
                }
            }
        }
    }

    private static void spawnRingPattern(Level world, double centerX, double centerY, double centerZ, double radius, int repetitions, List<S2CMessageRaidFlareBurst.ParticleData> particleTypes) {
        int particleCount = 40;
        for (int rep = 0; rep < repetitions; ++rep) {
            double ringHeight = centerY + ((double)rep - (double)repetitions / 2.0) * 0.5;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)particleCount;
                double x = centerX + Math.cos(angle) * radius;
                double z = centerZ + Math.sin(angle) * radius;
                ClientPlayHandler.spawnBurstParticlesAt(world, x, ringHeight, z, particleTypes);
            }
        }
    }

    private static void spawnStarPattern(Level world, double centerX, double centerY, double centerZ, double radius, int repetitions, List<S2CMessageRaidFlareBurst.ParticleData> particleTypes) {
        int points = 5;
        for (int rep = 0; rep < repetitions; ++rep) {
            for (int i = 0; i < points * 2; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)(points * 2);
                double r = i % 2 == 0 ? radius : radius * 0.4;
                double x = centerX + Math.cos(angle) * r;
                double z = centerZ + Math.sin(angle) * r;
                ClientPlayHandler.spawnBurstParticlesAt(world, x, centerY, z, particleTypes);
            }
        }
    }

    private static void spawnUnionJackPattern(Level world, double centerX, double centerY, double centerZ, double scale, List<S2CMessageRaidFlareBurst.ParticleData> particleTypes) {
        double z;
        double x;
        double t;
        int i;
        int segments = 30;
        for (i = 0; i < segments; ++i) {
            t = (double)i / (double)segments;
            x = centerX + (t - 0.5) * scale * 2.0;
            z = centerZ + (t - 0.5) * scale * 2.0;
            ClientPlayHandler.spawnBurstParticlesAt(world, x, centerY, z, particleTypes);
        }
        for (i = 0; i < segments; ++i) {
            t = (double)i / (double)segments;
            x = centerX + (t - 0.5) * scale * 2.0;
            z = centerZ - (t - 0.5) * scale * 2.0;
            ClientPlayHandler.spawnBurstParticlesAt(world, x, centerY, z, particleTypes);
        }
        for (i = 0; i < segments; ++i) {
            t = (double)i / (double)segments;
            x = centerX + (t - 0.5) * scale * 2.0;
            ClientPlayHandler.spawnBurstParticlesAt(world, x, centerY, centerZ, particleTypes);
        }
        for (i = 0; i < segments; ++i) {
            t = (double)i / (double)segments;
            double z2 = centerZ + (t - 0.5) * scale * 2.0;
            ClientPlayHandler.spawnBurstParticlesAt(world, centerX, centerY, z2, particleTypes);
        }
        for (i = 0; i <= segments / 4; ++i) {
            t = (double)i / (double)(segments / 4);
            double offset = t * scale * 0.3;
            ClientPlayHandler.spawnBurstParticlesAt(world, centerX - scale + offset, centerY, centerZ + scale - offset, particleTypes);
            ClientPlayHandler.spawnBurstParticlesAt(world, centerX + scale - offset, centerY, centerZ + scale - offset, particleTypes);
            ClientPlayHandler.spawnBurstParticlesAt(world, centerX - scale + offset, centerY, centerZ - scale + offset, particleTypes);
            ClientPlayHandler.spawnBurstParticlesAt(world, centerX + scale - offset, centerY, centerZ - scale + offset, particleTypes);
        }
    }

    private static void spawnCirclePattern(Level world, double centerX, double centerY, double centerZ, double radius, int repetitions, List<S2CMessageRaidFlareBurst.ParticleData> particleTypes) {
        int particleCount = 20;
        for (int rep = 0; rep < repetitions; ++rep) {
            double repRadius = radius * (double)(rep + 1) / (double)repetitions;
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)particleCount;
                double x = centerX + Math.cos(angle) * repRadius;
                double z = centerZ + Math.sin(angle) * repRadius;
                ClientPlayHandler.spawnBurstParticlesAt(world, x, centerY, z, particleTypes);
            }
        }
    }

    private static void spawnDefaultBurst(Level world, double x, double y, double z, List<S2CMessageRaidFlareBurst.ParticleData> particleTypes) {
        ClientPlayHandler.spawnBurstParticlesAt(world, x, y, z, particleTypes);
    }

    private static void spawnBurstParticlesAt(Level world, double x, double y, double z, List<S2CMessageRaidFlareBurst.ParticleData> particleTypes) {
        for (S2CMessageRaidFlareBurst.ParticleData particleData : particleTypes) {
            ParticleOptions particle = ClientPlayHandler.getParticleWithColor(particleData.particleId, particleData.color);
            if (particle == null) continue;
            for (int i = 0; i < particleData.count; ++i) {
                double offsetX = (world.f_46441_.m_188500_() - 0.5) * particleData.spread;
                double offsetY = (world.f_46441_.m_188500_() - 0.5) * particleData.spread;
                double offsetZ = (world.f_46441_.m_188500_() - 0.5) * particleData.spread;
                double velX = (world.f_46441_.m_188500_() - 0.5) * particleData.speed * 2.0;
                double velY = (world.f_46441_.m_188500_() - 0.5) * particleData.speed * 2.0;
                double velZ = (world.f_46441_.m_188500_() - 0.5) * particleData.speed * 2.0;
                world.m_7106_(particle, x + offsetX, y + offsetY, z + offsetZ, velX, velY, velZ);
            }
        }
    }

    private static ParticleOptions getParticleTypeFromString(String particleId) {
        try {
            ResourceLocation location = new ResourceLocation(particleId);
            return (ParticleOptions)BuiltInRegistries.f_257034_.m_7745_(location);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ParticleOptions getParticleWithColor(String particleId, int color) {
        if (particleId.equals("minecraft:dust")) {
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            return new DustParticleOptions(new Vector3f(r, g, b), 1.0f);
        }
        return ClientPlayHandler.getParticleTypeFromString(particleId);
    }

    public static void handleSyncUpgradeRegistry(S2CMessageSyncUpgradeRegistry message) {
        Minecraft.m_91087_().execute(() -> ExoSuitUpgradeManager.deserializeUpgrades(message.getUpgradeData()));
    }

    public static void handleSyncExoSuitUpgrades(S2CMessageSyncExoSuitUpgrades message) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (localPlayer == null || level == null) {
            return;
        }
        Player targetPlayer = null;
        for (Player player : level.m_6907_()) {
            if (!player.m_20148_().equals(message.getPlayerId())) continue;
            targetPlayer = player;
            break;
        }
        if (targetPlayer != null) {
            ItemStack armorPiece = targetPlayer.m_6844_(message.getArmorSlot());
            if (armorPiece.m_41619_() && !message.getUpgradeData().m_128456_()) {
                return;
            }
            if (armorPiece.m_41720_() instanceof ExoSuitItem) {
                ExoSuitData.setUpgradeData(armorPiece, message.getUpgradeData());
                targetPlayer.m_8061_(message.getArmorSlot(), armorPiece.m_41777_());
                if (targetPlayer == localPlayer) {
                    localPlayer.f_36095_.m_38946_();
                }
            }
        }
    }

    public static void handleMessageDualWieldShotCount(S2CMessageDualWieldShotCount message) {
        GunRenderingHandler.get().updateDualWieldShotCount(message.getEntityId(), message.getShotCount());
    }

    public static void handleReloadState(boolean reloading) {
        ItemStack heldItem;
        if (Minecraft.m_91087_().f_91074_ != null && (heldItem = Minecraft.m_91087_().f_91074_.m_21205_()).m_41720_() instanceof GunItem) {
            CompoundTag tag = heldItem.m_41784_();
            if (!reloading) {
                tag.m_128473_("IsReloading");
                tag.m_128473_("scguns:IsReloading");
                tag.m_128379_("scguns:ReloadComplete", true);
                ModSyncedDataKeys.RELOADING.setValue((Entity)Minecraft.m_91087_().f_91074_, (Object)false);
            } else {
                ModSyncedDataKeys.RELOADING.setValue((Entity)Minecraft.m_91087_().f_91074_, (Object)true);
            }
        }
    }

    public static void handleStopReload(S2CMessageStopReload message) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (!(item instanceof AnimatedGunItem)) {
            return;
        }
        AnimatedGunItem gunItem = (AnimatedGunItem)item;
        CompoundTag tag = heldItem.m_41784_();
        tag.m_128359_("scguns:ReloadState", "STOPPING");
        tag.m_128379_("scguns:IsPlayingReloadStop", true);
        tag.m_128473_("InReloadLoop");
        tag.m_128473_("scguns:IsReloading");
        ModSyncedDataKeys.RELOADING.setValue((Entity)player, (Object)false);
        long id = GeoItem.getId((ItemStack)heldItem);
        AnimationController animationController = (AnimationController)gunItem.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
        if (animationController != null) {
            animationController.stop();
            animationController.setAnimationSpeed(1.0);
            animationController.tryTriggerAnimation(gunItem.isInCarbineMode(heldItem) ? "carbine_reload_stop" : "reload_stop");
        }
    }

    public static void handleMessageGunSound(S2CMessageGunSound message) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        if (message.showMuzzleFlash()) {
            GunRenderingHandler.get().showMuzzleFlashForPlayer(message.getShooterId());
        }
        if (message.getShooterId() == mc.f_91074_.m_19879_()) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(message.getId(), SoundSource.PLAYERS, message.getVolume(), message.getPitch(), mc.f_91073_.m_213780_(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true));
        } else {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new GunShotSound(message.getId(), SoundSource.PLAYERS, message.getX(), message.getY(), message.getZ(), message.getVolume(), message.getPitch(), message.isReload(), mc.f_91073_.m_213780_()));
        }
    }

    public static void handleBeamPenetration(S2CMessageBeamPenetration message) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return;
        }
        BeamHandler.BeamInfo beamInfo = BeamHandler.activeBeams.get(message.getPlayerId());
        if (beamInfo == null) {
            return;
        }
        beamInfo.glassPenetrationPoints = message.getPenetrations().stream().map(S2CMessageBeamPenetration.GlassPenetrationData::getPosition).collect(Collectors.toList());
        Player player = level.m_46003_(message.getPlayerId());
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (modifiedGun == null) {
            return;
        }
        float[] interpolatedColor = BeamHandler.getBeamColorForWeapon(heldItem, modifiedGun);
        for (S2CMessageBeamPenetration.GlassPenetrationData penetration : message.getPenetrations()) {
            Vec3 pos = penetration.getPosition();
            for (int i = 0; i < 1; ++i) {
                double offsetX = (level.f_46441_.m_188500_() - 0.5) * 0.1;
                double offsetY = (level.f_46441_.m_188500_() - 0.5) * 0.1;
                double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 0.1;
                level.m_6493_((ParticleOptions)ModParticleTypes.BLOOD.get(), false, pos.f_82479_ + offsetX, pos.f_82480_ + offsetY, pos.f_82481_ + offsetZ, (double)interpolatedColor[0], (double)interpolatedColor[1], (double)interpolatedColor[2]);
            }
        }
    }

    public static void handleMessageBlood(S2CMessageBlood message) {
        if (!((Boolean)Config.CLIENT.particle.enableBlood.get()).booleanValue()) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            EntityType<?> entityType = message.getEntityType();
            for (int i = 0; i < 10; ++i) {
                Particle particle = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ModParticleTypes.BLOOD.get(), message.getX(), message.getY(), message.getZ(), 0.5, 0.0, 0.5);
                if (!(particle instanceof BloodParticle)) continue;
                ((BloodParticle)particle).setColorBasedOnEntity(entityType);
            }
        }
    }

    public static void handleBeamUpdate(S2CMessageBeamUpdate message) {
        UUID playerId = message.getPlayerId();
        Vec3 startPos = message.getStartPos();
        Vec3 endPos = message.getEndPos();
        BeamHandler.updateBeam(playerId, startPos, endPos);
    }

    public static void handleMessageBulletTrail(S2CMessageBulletTrail message) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            int[] entityIds = message.getEntityIds();
            Vec3[] positions = message.getPositions();
            Vec3[] motions = message.getMotions();
            ItemStack item = message.getItem();
            int trailColor = message.getTrailColor();
            double trailLengthMultiplier = message.getTrailLengthMultiplier();
            int life = message.getLife();
            double gravity = message.getGravity();
            int shooterId = message.getShooterId();
            boolean enchanted = message.isEnchanted();
            ParticleOptions data = message.getParticleData();
            boolean isVisible = message.isVisible();
            double trailThickness = message.getTrailThickness();
            for (int i = 0; i < message.getCount(); ++i) {
                BulletTrailRenderingHandler.get().add(new BulletTrail(entityIds[i], positions[i], motions[i], item, trailColor, trailLengthMultiplier, life, gravity, shooterId, enchanted, data, isVisible, trailThickness));
            }
        }
    }

    public static void handleExplosionStunGrenade(S2CMessageStunGrenade message) {
        int i;
        Minecraft mc = Minecraft.m_91087_();
        ParticleEngine particleManager = mc.f_91061_;
        Level world = (Level)Objects.requireNonNull(mc.f_91073_);
        double x = message.getX();
        double y = message.getY();
        double z = message.getZ();
        for (i = 0; i < 30; ++i) {
            ClientPlayHandler.spawnParticle(particleManager, (ParticleOptions)ParticleTypes.f_123796_, x, y, z, world.f_46441_, 0.2);
        }
        for (i = 0; i < 30; ++i) {
            Particle smoke = ClientPlayHandler.spawnParticle(particleManager, (ParticleOptions)ParticleTypes.f_123762_, x, y, z, world.f_46441_, 4.0);
            smoke.m_107257_((int)(8.0 / (Math.random() * 0.1 + 0.4) * 0.5));
            ClientPlayHandler.spawnParticle(particleManager, (ParticleOptions)ParticleTypes.f_123797_, x, y, z, world.f_46441_, 4.0);
        }
    }

    private static Particle spawnParticle(ParticleEngine manager, ParticleOptions data, double x, double y, double z, RandomSource rand, double velocityMultiplier) {
        return manager.m_107370_(data, x, y, z, (rand.m_188500_() - 0.5) * velocityMultiplier, (rand.m_188500_() - 0.5) * velocityMultiplier, (rand.m_188500_() - 0.5) * velocityMultiplier);
    }

    public static void handleProjectileHitBlock(S2CMessageProjectileHitBlock message) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        if (world != null) {
            BlockState state = world.m_8055_(message.getPos());
            double holeX = message.getX() + 0.005 * (double)message.getFace().m_122429_();
            double holeY = message.getY() + 0.005 * (double)message.getFace().m_122430_();
            double holeZ = message.getZ() + 0.005 * (double)message.getFace().m_122431_();
            double distance = Math.sqrt(mc.f_91074_.m_20275_(message.getX(), message.getY(), message.getZ()));
            world.m_6493_((ParticleOptions)new BulletHoleData(message.getFace(), message.getPos()), false, holeX, holeY, holeZ, 0.0, 0.0, 0.0);
            if (distance < (Double)Config.CLIENT.particle.impactParticleDistance.get()) {
                for (int i = 0; i < 4; ++i) {
                    Vec3i normal = message.getFace().m_122436_();
                    Vec3 motion = new Vec3((double)normal.m_123341_(), (double)normal.m_123342_(), (double)normal.m_123343_());
                    motion.m_82520_(ClientPlayHandler.getRandomDir(world.f_46441_), ClientPlayHandler.getRandomDir(world.f_46441_), ClientPlayHandler.getRandomDir(world.f_46441_));
                    world.m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), false, message.getX(), message.getY(), message.getZ(), motion.f_82479_, motion.f_82480_, motion.f_82481_);
                }
            }
            if (distance <= (Double)Config.CLIENT.sounds.impactSoundDistance.get()) {
                world.m_7785_(message.getX(), message.getY(), message.getZ(), state.m_60827_().m_56775_(), SoundSource.BLOCKS, 2.0f, 2.0f, false);
            }
        }
    }

    private static double getRandomDir(RandomSource random) {
        return -0.25 + random.m_188500_() * 0.5;
    }

    public static void handleProjectileHitEntity(S2CMessageProjectileHitEntity message) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        if (world == null) {
            return;
        }
        HUDRenderHandler.playHitMarker(message.isCritical() || message.isHeadshot());
        SoundEvent event = ClientPlayHandler.getHitSound(message.isCritical(), message.isHeadshot(), message.isPlayer());
        if (event == null) {
            return;
        }
        mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)event, (float)1.0f, (float)(1.0f + world.f_46441_.m_188501_() * 0.2f)));
    }

    @Nullable
    private static SoundEvent getHitSound(boolean critical, boolean headshot, boolean player) {
        if (critical) {
            if (((Boolean)Config.CLIENT.sounds.playSoundWhenCritical.get()).booleanValue()) {
                SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation((String)Config.CLIENT.sounds.criticalSound.get()));
                return event != null ? event : SoundEvents.f_12313_;
            }
        } else if (headshot) {
            if (((Boolean)Config.CLIENT.sounds.playSoundWhenHeadshot.get()).booleanValue()) {
                SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation((String)Config.CLIENT.sounds.headshotSound.get()));
                return event != null ? event : SoundEvents.f_12314_;
            }
        } else if (player) {
            return SoundEvents.f_12323_;
        }
        return null;
    }

    public static void handleRemoveProjectile(S2CMessageRemoveProjectile message) {
        BulletTrailRenderingHandler.get().remove(message.getEntityId());
    }

    public static void handleUpdateGuns(S2CMessageUpdateGuns message) {
        NetworkGunManager.updateRegisteredGuns(message);
        CustomGunManager.updateCustomGuns(message);
    }

    public static void handleStopBeam(S2CMessageStopBeam message) {
        BeamHandler.stopBeam(message.getPlayerId());
    }
}

