/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.blockentity;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.Config;
import top.ribs.scguns.block.DamageModuleBlock;
import top.ribs.scguns.block.FireRateModuleBlock;
import top.ribs.scguns.block.HostileTurretTargetingBlock;
import top.ribs.scguns.block.PlayerTurretTargetingBlock;
import top.ribs.scguns.block.RangeModuleBlock;
import top.ribs.scguns.block.ShellCatcherModuleBlock;
import top.ribs.scguns.block.TurretTargetingBlock;
import top.ribs.scguns.blockentity.ShellCatcherModuleBlockEntity;
import top.ribs.scguns.common.Turret;
import top.ribs.scguns.common.TurretManager;
import top.ribs.scguns.entity.projectile.turret.TurretProjectileEntity;
import top.ribs.scguns.init.ModTags;
import top.ribs.scguns.item.EnemyLogItem;
import top.ribs.scguns.item.TeamLogItem;
import top.ribs.scguns.network.PacketHandler;
import top.ribs.scguns.network.message.S2CMessageMuzzleFlash;

public abstract class TurretBlockEntity
extends BlockEntity
implements MenuProvider {
    protected final ResourceLocation turretId;
    protected Turret config;
    protected double targetingRadius;
    protected int cooldown;
    public final ItemStackHandler itemHandler = new ItemStackHandler(10){

        protected void onContentsChanged(int slot) {
            TurretBlockEntity.this.m_6596_();
            if (TurretBlockEntity.this.f_58857_ != null && !TurretBlockEntity.this.f_58857_.m_5776_()) {
                TurretBlockEntity.this.f_58857_.m_7260_(TurretBlockEntity.this.m_58899_(), TurretBlockEntity.this.m_58900_(), TurretBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    protected LivingEntity target;
    protected UUID ownerUUID;
    protected String ownerName;
    protected float yaw;
    protected double smoothedTargetX;
    protected double smoothedTargetZ;
    protected float pitch;
    protected double smoothedTargetY;
    protected float previousYaw;
    protected float previousPitch;
    public float recoilPitchOffset = 0.0f;
    protected boolean hasFireRateModule;
    protected boolean hasDamageModule;
    protected boolean hasRangeModule;
    protected boolean hasShellCatchingModule;
    public boolean disabled = false;
    public int disableCooldown = 0;
    private static final int DAMAGE_INCREASE = 2;
    private static final double RANGE_INCREASE = 8.0;
    private static final int IDLE_BEFORE_SCAN = 60;
    private static final float SCAN_ANGLE = 60.0f;
    private static final float SCAN_SPEED = 0.02f;
    private static final float SCAN_PITCH = 0.0f;
    private int idleTicks = 0;
    private boolean isScanning = false;
    private boolean scanningRight = true;
    private float scanStartYaw = 0.0f;
    private boolean returningToScanPitch = false;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler);

    public TurretBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, ResourceLocation turretId) {
        super(type, pos, state);
        this.turretId = turretId;
        this.config = TurretManager.getTurret(turretId);
        if (this.config != null) {
            this.targetingRadius = this.config.getTargeting().getRange();
            this.cooldown = this.config.getCombat().getCooldown();
        } else {
            this.targetingRadius = 12.0;
            this.cooldown = 16;
        }
    }

    public void reloadConfig() {
        this.config = TurretManager.getTurret(this.turretId);
        if (this.config != null) {
            this.targetingRadius = this.config.getTargeting().getRange();
            this.cooldown = this.config.getCombat().getCooldown();
        }
    }

    public void tick() {
        double rangeModifier;
        if (this.f_58857_ == null) {
            return;
        }
        if (this.config == null) {
            this.reloadConfig();
            if (this.config == null) {
                return;
            }
        }
        this.hasFireRateModule = this.isAdjacentToFireRateModule((BlockGetter)this.f_58857_, this.f_58858_);
        this.hasDamageModule = this.isAdjacentToDamageModule((BlockGetter)this.f_58857_, this.f_58858_);
        this.hasRangeModule = this.isAdjacentToRangeModule((BlockGetter)this.f_58857_, this.f_58858_);
        this.hasShellCatchingModule = this.isAdjacentToShellCatchingModule();
        int fireRateModifier = this.hasFireRateModule ? 2 : 1;
        int damageModifier = this.hasDamageModule ? 2 : 0;
        double d = rangeModifier = this.hasRangeModule ? 8.0 : 0.0;
        if (this.cooldown > 0) {
            this.cooldown -= fireRateModifier;
        }
        this.tickRecoil();
        if (this.disabled) {
            --this.disableCooldown;
            if (this.disableCooldown <= 0) {
                this.disabled = false;
                this.disableCooldown = 0;
            }
            this.resetToRestPosition();
            this.idleTicks = 0;
            this.isScanning = false;
        } else if (!this.isPowered(this.m_58900_())) {
            this.updateTargetRange(rangeModifier);
            if (!this.isTargetValid()) {
                this.target = null;
            }
            this.findTarget(this.f_58857_, this.f_58858_);
            if (this.target != null) {
                this.idleTicks = 0;
                this.isScanning = false;
                this.returningToScanPitch = false;
                this.updateYaw();
                this.updatePitch();
                if (this.cooldown <= 0 && this.isReadyToFire()) {
                    this.fireWeapon(damageModifier);
                }
            } else {
                ++this.idleTicks;
                if (this.idleTicks < 60) {
                    this.previousYaw = this.yaw;
                    this.previousPitch = this.pitch;
                } else {
                    this.updateScanningBehavior();
                }
            }
        } else {
            this.resetToRestPosition();
            this.idleTicks = 0;
            this.isScanning = false;
            this.returningToScanPitch = false;
        }
    }

    protected void updateScanningBehavior() {
        float currentDiff;
        float targetYaw;
        float yawDiff;
        if (this.config == null) {
            return;
        }
        this.previousYaw = this.yaw;
        this.previousPitch = this.pitch;
        if (!this.returningToScanPitch) {
            float pitchDiff = 0.0f - this.pitch;
            if (Math.abs(pitchDiff) > 0.5f) {
                this.pitch += pitchDiff * this.config.getTargeting().getRotationSpeed();
                return;
            }
            this.pitch = 0.0f;
            this.returningToScanPitch = true;
        }
        this.pitch = 0.0f;
        if (!this.isScanning) {
            this.isScanning = true;
            this.scanStartYaw = this.yaw;
            this.scanningRight = true;
        }
        if ((yawDiff = (targetYaw = this.scanningRight ? this.scanStartYaw + 60.0f : this.scanStartYaw - 60.0f) - this.yaw) > 180.0f) {
            yawDiff -= 360.0f;
        } else if (yawDiff < -180.0f) {
            yawDiff += 360.0f;
        }
        this.yaw += yawDiff * 0.02f;
        this.yaw %= 360.0f;
        if (this.yaw < 0.0f) {
            this.yaw += 360.0f;
        }
        if ((currentDiff = Math.abs(Mth.m_14177_((float)(this.yaw - this.scanStartYaw)))) >= 59.0f) {
            this.scanningRight = !this.scanningRight;
        }
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TurretBlockEntity) {
            TurretBlockEntity turret = (TurretBlockEntity)t;
            turret.tick();
        }
    }

    protected abstract boolean isPowered(BlockState var1);

    protected void fireWeapon(int damageModifier) {
        Turret.Ammunition.AmmoType ammoType = this.findAndConsumeAmmo();
        if (ammoType != null) {
            this.fire(ammoType, damageModifier);
            this.cooldown = this.config.getCombat().getCooldown();
        }
    }

    protected void fire(Turret.Ammunition.AmmoType ammoType, int damageModifier) {
        int pelletCount;
        if (this.f_58857_ == null || this.target == null || this.config == null) {
            return;
        }
        float yaw = this.getYaw();
        float pitch = this.getPitch();
        Vec3 muzzlePos = this.getMuzzlePosition(yaw, pitch);
        if (!this.f_58857_.f_46443_) {
            PacketHandler.getPlayChannel().sendToTrackingChunk(() -> this.f_58857_.m_46745_(this.f_58858_), (IMessage)new S2CMessageMuzzleFlash(muzzlePos, yaw, pitch));
        }
        SoundEvent fireSound = null;
        ResourceLocation soundLoc = this.config.getCombat().getFireSound();
        if (soundLoc != null) {
            fireSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLoc);
        }
        if (fireSound != null) {
            this.f_58857_.m_5594_(null, this.f_58858_, fireSound, SoundSource.BLOCKS, 0.7f, 0.7f);
        }
        Vec3 targetPos = new Vec3(this.target.m_20185_(), this.target.m_20186_() + (double)this.target.m_20192_() * 0.5, this.target.m_20189_());
        Vec3 direction = targetPos.m_82546_(muzzlePos).m_82541_();
        float inaccuracy = this.config.getCombat().getInaccuracy();
        if (inaccuracy > 0.0f) {
            direction = direction.m_82520_(this.f_58857_.f_46441_.m_216328_(0.0, (double)inaccuracy), this.f_58857_.f_46441_.m_216328_(0.0, (double)inaccuracy), this.f_58857_.f_46441_.m_216328_(0.0, (double)inaccuracy)).m_82541_();
        }
        if ((pelletCount = this.config.getCombat().getPelletCount()) > 1) {
            this.fireCluster(ammoType, muzzlePos, direction, damageModifier, pelletCount);
        } else {
            this.fireSingleProjectile(ammoType, muzzlePos, direction, damageModifier);
        }
        this.recoilPitchOffset = this.config.getCombat().getRecoilMax();
        this.handleCasingEjection(ammoType);
    }

    protected void fireSingleProjectile(Turret.Ammunition.AmmoType ammoType, Vec3 muzzlePos, Vec3 direction, int damageModifier) {
        TurretProjectileEntity projectile = this.createProjectile();
        projectile.m_6034_(muzzlePos.f_82479_, muzzlePos.f_82480_, muzzlePos.f_82481_);
        double speed = this.config.getCombat().getProjectileSpeed();
        projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, (float)speed, 0.0f);
        double finalDamage = this.getDamageForAmmoType(ammoType) + (double)damageModifier;
        projectile.m_36781_(finalDamage);
        projectile.setArmorPenetration(ammoType.getArmorPenetration());
        String bulletType = ammoType.getBulletType().toString();
        if (bulletType.equals("scguns:bear_pack_shell")) {
            projectile.setMobPenetration(1);
        } else if (bulletType.equals("scguns:gibbs_round")) {
            projectile.setGibbsRound(true);
        } else if (bulletType.equals("scguns:shatter_round")) {
            projectile.setShatterRound(true);
        }
        assert (this.f_58857_ != null);
        this.f_58857_.m_7967_((Entity)projectile);
    }

    protected void fireCluster(Turret.Ammunition.AmmoType ammoType, Vec3 muzzlePos, Vec3 baseDirection, int damageModifier, int pelletCount) {
        double baseDamage = this.getDamageForAmmoType(ammoType);
        double finalDamage = baseDamage + (double)damageModifier;
        double pelletDamage = finalDamage / (double)pelletCount;
        float spreadAngle = this.config.getCombat().getSpreadAngle();
        String bulletType = ammoType.getBulletType().toString();
        boolean isBearPackShell = bulletType.equals("scguns:bear_pack_shell");
        boolean isGibbsRound = bulletType.equals("scguns:gibbs_round");
        boolean isShatterRound = bulletType.equals("scguns:shatter_round");
        for (int i = 0; i < pelletCount; ++i) {
            Vec3 spreadDirection = this.applySpread(baseDirection, spreadAngle);
            TurretProjectileEntity projectile = this.createProjectile();
            projectile.m_6034_(muzzlePos.f_82479_, muzzlePos.f_82480_, muzzlePos.f_82481_);
            double speed = this.config.getCombat().getProjectileSpeed();
            projectile.m_6686_(spreadDirection.f_82479_, spreadDirection.f_82480_, spreadDirection.f_82481_, (float)speed, 0.0f);
            projectile.m_36781_(pelletDamage);
            projectile.setArmorPenetration(ammoType.getArmorPenetration());
            if (isBearPackShell) {
                projectile.setMobPenetration(1);
            } else if (isGibbsRound) {
                projectile.setGibbsRound(true);
            } else if (isShatterRound) {
                projectile.setShatterRound(true);
            }
            assert (this.f_58857_ != null);
            this.f_58857_.m_7967_((Entity)projectile);
        }
    }

    protected Vec3 applySpread(Vec3 baseDirection, float spreadAngle) {
        assert (this.f_58857_ != null);
        float angleX = (float)(this.f_58857_.f_46441_.m_188583_() * (double)spreadAngle);
        float angleY = (float)(this.f_58857_.f_46441_.m_188583_() * (double)spreadAngle);
        double yawRad = Math.toRadians(angleX);
        double pitchRad = Math.toRadians(angleY);
        double x = baseDirection.f_82479_;
        double y = baseDirection.f_82480_;
        double z = baseDirection.f_82481_;
        double tempX = x * Math.cos(yawRad) - z * Math.sin(yawRad);
        double tempZ = x * Math.sin(yawRad) + z * Math.cos(yawRad);
        x = tempX;
        z = tempZ;
        double tempY = y * Math.cos(pitchRad) - z * Math.sin(pitchRad);
        tempZ = y * Math.sin(pitchRad) + z * Math.cos(pitchRad);
        y = tempY;
        z = tempZ;
        return new Vec3(x, y, z).m_82541_();
    }

    protected TurretProjectileEntity createProjectile() {
        return new TurretProjectileEntity(this.f_58857_);
    }

    protected double getDamageForAmmoType(Turret.Ammunition.AmmoType ammoType) {
        double baseDamage = ammoType.getDamage();
        return baseDamage *= ((Double)Config.COMMON.gameplay.globalTurretDamageMultiplier.get()).doubleValue();
    }

    protected void handleCasingEjection(Turret.Ammunition.AmmoType ammoType) {
        if (this.hasShellCatchingModule) {
            boolean inserted = this.tryInsertIntoShellCatcher(ammoType);
            if (!inserted) {
                this.spawnCasing(ammoType);
            }
        } else {
            float ejectChance = this.config.getAmmunition().getCasingEjectChance();
            assert (this.f_58857_ != null);
            if (this.f_58857_.f_46441_.m_188501_() < ejectChance) {
                this.spawnCasing(ammoType);
            }
        }
    }

    protected void spawnCasing(Turret.Ammunition.AmmoType ammoType) {
        ResourceLocation casingType = ammoType.getCasingType();
        if (casingType == null) {
            return;
        }
        ItemStack casingStack = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(casingType)));
        assert (this.f_58857_ != null);
        ItemEntity casingEntity = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5, casingStack);
        double ejectSpeed = 0.1;
        double ejectX = (double)Direction.NORTH.m_122429_() * ejectSpeed;
        double ejectY = 0.15;
        double ejectZ = (double)Direction.NORTH.m_122431_() * ejectSpeed;
        casingEntity.m_20334_(ejectX, ejectY, ejectZ);
        this.f_58857_.m_7967_((Entity)casingEntity);
    }

    protected boolean tryInsertIntoShellCatcher(Turret.Ammunition.AmmoType ammoType) {
        ResourceLocation casingType = ammoType.getCasingType();
        if (casingType == null) {
            return false;
        }
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = this.f_58858_.m_121945_(direction);
            assert (this.f_58857_ != null);
            BlockEntity blockEntity = this.f_58857_.m_7702_(neighborPos);
            if (!(blockEntity instanceof ShellCatcherModuleBlockEntity)) continue;
            ShellCatcherModuleBlockEntity shellCatcher = (ShellCatcherModuleBlockEntity)blockEntity;
            ItemStack casingStack = new ItemStack((ItemLike)Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(casingType)));
            for (int i = 0; i < shellCatcher.m_6643_(); ++i) {
                ItemStack existingStack = shellCatcher.getItemStackHandler().getStackInSlot(i);
                if (existingStack.m_41619_()) {
                    shellCatcher.getItemStackHandler().setStackInSlot(i, casingStack);
                    return true;
                }
                if (!ItemStack.m_150942_((ItemStack)existingStack, (ItemStack)casingStack) || existingStack.m_41613_() >= existingStack.m_41741_()) continue;
                existingStack.m_41769_(1);
                shellCatcher.getItemStackHandler().setStackInSlot(i, existingStack);
                return true;
            }
        }
        return false;
    }

    protected Vec3 getMuzzlePosition(float yaw, float pitch) {
        double muzzleLength = this.config.getDisplay().getMuzzleLength();
        double muzzleOffsetY = this.config.getDisplay().getMuzzleOffsetY();
        double yawRad = Math.toRadians(yaw);
        double pitchRad = Math.toRadians(pitch);
        double muzzleX = -Math.sin(yawRad) * Math.cos(pitchRad) * muzzleLength;
        double muzzleY = Math.sin(pitchRad) * muzzleLength + muzzleOffsetY;
        double muzzleZ = -Math.cos(yawRad) * Math.cos(pitchRad) * muzzleLength;
        return new Vec3((double)this.f_58858_.m_123341_() + 0.5 + muzzleX, (double)this.f_58858_.m_123342_() + muzzleY, (double)this.f_58858_.m_123343_() + 0.5 + muzzleZ);
    }

    protected void updateTargetRange(double rangeModifier) {
        this.targetingRadius = this.config.getTargeting().getRange() + rangeModifier;
    }

    public boolean isReadyToFire() {
        if (this.target == null || this.config == null) {
            return false;
        }
        double dx = this.smoothedTargetX - ((double)this.f_58858_.m_123341_() + 0.5);
        double dy = this.smoothedTargetY - ((double)this.f_58858_.m_123342_() + 1.0);
        double dz = this.smoothedTargetZ - ((double)this.f_58858_.m_123343_() + 0.5);
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        float targetYaw = (float)(Math.atan2(dx, dz) * 57.29577951308232) + 180.0f;
        targetYaw = (targetYaw + 360.0f) % 360.0f;
        float targetPitch = (float)(Math.atan2(dy, horizontalDistance) * 57.29577951308232);
        targetPitch = Mth.m_14036_((float)targetPitch, (float)this.config.getTargeting().getMinPitch(), (float)this.config.getTargeting().getMaxPitch());
        float yawDifference = Math.abs(targetYaw - this.yaw);
        if (yawDifference > 180.0f) {
            yawDifference = 360.0f - yawDifference;
        }
        float pitchDifference = Math.abs(targetPitch - this.pitch);
        double distanceSquared = dx * dx + dy * dy + dz * dz;
        double minDist = this.config.getTargeting().getMinFiringDistance();
        if (distanceSquared < minDist * minDist) {
            return false;
        }
        return yawDifference < 2.0f && pitchDifference < 2.0f;
    }

    public void tickRecoil() {
        if (this.config == null) {
            return;
        }
        if (this.recoilPitchOffset > 0.0f) {
            this.recoilPitchOffset -= this.config.getCombat().getRecoilSpeed();
            if (this.recoilPitchOffset < 0.0f) {
                this.recoilPitchOffset = 0.0f;
            }
        }
    }

    public void resetToRestPosition() {
        if (this.config == null) {
            return;
        }
        this.target = null;
        float restingYaw = this.config.getBehavior().getRestingYaw();
        float restingPitch = this.config.getBehavior().getRestingPitch();
        this.previousYaw = this.yaw;
        this.previousPitch = this.pitch;
        float yawDifference = restingYaw - this.yaw;
        if (yawDifference > 180.0f) {
            yawDifference -= 360.0f;
        } else if (yawDifference < -180.0f) {
            yawDifference += 360.0f;
        }
        float rotSpeed = this.config.getTargeting().getRotationSpeed();
        this.yaw += yawDifference * rotSpeed;
        this.yaw %= 360.0f;
        if (this.yaw < 0.0f) {
            this.yaw += 360.0f;
        }
        float pitchDifference = restingPitch - this.pitch;
        this.pitch += pitchDifference * rotSpeed;
        this.smoothedTargetX = 0.0;
        this.smoothedTargetY = 0.0;
        this.smoothedTargetZ = 0.0;
    }

    public void onHitByLightningProjectile() {
        if (this.config == null) {
            return;
        }
        this.disabled = true;
        this.disableCooldown = this.config.getBehavior().getDisableTime();
        this.resetToRestPosition();
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.spawnDisableParticles();
        }
    }

    protected void spawnDisableParticles() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x = (double)this.f_58858_.m_123341_() + 0.5;
            double y = (double)this.f_58858_.m_123342_() + 1.0;
            double z = (double)this.f_58858_.m_123343_() + 0.5;
            for (int i = 0; i < 20; ++i) {
                double offsetX = this.f_58857_.f_46441_.m_188500_() * 0.5 - 0.25;
                double offsetY = this.f_58857_.f_46441_.m_188500_() * 0.5;
                double offsetZ = this.f_58857_.f_46441_.m_188500_() * 0.5 - 0.25;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175830_, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.05);
            }
            serverLevel.m_5594_(null, this.f_58858_, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Nullable
    protected Turret.Ammunition.AmmoType findAndConsumeAmmo() {
        if (this.config == null) {
            return null;
        }
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            for (Turret.Ammunition.AmmoType ammoType : this.config.getAmmunition().getAcceptedAmmo()) {
                if (stack.m_41720_() != ammoType.getItem()) continue;
                this.consumeAmmo(i);
                return ammoType;
            }
        }
        return null;
    }

    protected void consumeAmmo(int slot) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        stack.m_41774_(1);
        if (stack.m_41619_()) {
            this.itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
        }
    }

    protected void findTarget(Level level, BlockPos pos) {
        boolean finalIsHostileTargetingModule;
        boolean finalIsPlayerTargetingModule;
        CompoundTag tag;
        if (this.config == null) {
            return;
        }
        this.target = null;
        boolean hasTargetingModule = false;
        boolean isPlayerTargetingModule = false;
        boolean isHostileTargetingModule = false;
        for (Direction direction : Direction.values()) {
            BlockState blockState = level.m_8055_(pos.m_121945_(direction));
            if (!(blockState.m_60734_() instanceof TurretTargetingBlock)) continue;
            hasTargetingModule = true;
            if (blockState.m_60734_() instanceof PlayerTurretTargetingBlock) {
                isPlayerTargetingModule = true;
                break;
            }
            if (!(blockState.m_60734_() instanceof HostileTurretTargetingBlock)) break;
            isHostileTargetingModule = true;
            break;
        }
        if (!hasTargetingModule) {
            return;
        }
        ItemStack logStack = this.itemHandler.getStackInSlot(9);
        boolean hasTeamLog = logStack.m_41720_() instanceof TeamLogItem && !(logStack.m_41720_() instanceof EnemyLogItem);
        boolean hasEnemyLog = logStack.m_41720_() instanceof EnemyLogItem;
        ArrayList<UUID> loggedEntityUUIDs = new ArrayList<UUID>();
        ArrayList<String> blacklistedEntityTypes = new ArrayList<String>();
        ArrayList<UUID> whitelistedEntityUUIDs = new ArrayList<UUID>();
        ArrayList<String> whitelistedEntityTypes = new ArrayList<String>();
        if ((hasTeamLog || hasEnemyLog) && (tag = logStack.m_41783_()) != null) {
            if (hasTeamLog) {
                int i;
                if (tag.m_128425_("Entities", 9)) {
                    listTag = tag.m_128437_("Entities", 10);
                    for (i = 0; i < listTag.size(); ++i) {
                        entityTag = listTag.m_128728_(i);
                        loggedEntityUUIDs.add(entityTag.m_128342_("UUID"));
                    }
                }
                if (tag.m_128425_("Blacklist", 9)) {
                    ListTag blacklistTag = tag.m_128437_("Blacklist", 8);
                    for (i = 0; i < blacklistTag.size(); ++i) {
                        blacklistedEntityTypes.add(blacklistTag.m_128778_(i));
                    }
                }
            } else {
                int i;
                if (tag.m_128425_("Whitelist", 9)) {
                    listTag = tag.m_128437_("Whitelist", 10);
                    for (i = 0; i < listTag.size(); ++i) {
                        entityTag = listTag.m_128728_(i);
                        whitelistedEntityUUIDs.add(entityTag.m_128342_("UUID"));
                    }
                }
                if (tag.m_128425_("WhitelistEntityTypes", 9)) {
                    ListTag whitelistTag = tag.m_128437_("WhitelistEntityTypes", 8);
                    for (i = 0; i < whitelistTag.size(); ++i) {
                        whitelistedEntityTypes.add(whitelistTag.m_128778_(i));
                    }
                }
            }
        }
        Vec3 turretPos = new Vec3((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5);
        double verticalSearchRange = this.config.getTargeting().getVerticalRange();
        AABB searchBox = new AABB(pos).m_82377_(this.targetingRadius, verticalSearchRange, this.targetingRadius);
        List potentialTargets = level.m_6443_(LivingEntity.class, searchBox, arg_0 -> this.lambda$findTarget$1(hasTeamLog, hasEnemyLog, loggedEntityUUIDs, blacklistedEntityTypes, whitelistedEntityUUIDs, whitelistedEntityTypes, finalIsPlayerTargetingModule = isPlayerTargetingModule, finalIsHostileTargetingModule = isHostileTargetingModule, arg_0));
        if (!potentialTargets.isEmpty()) {
            this.target = this.config.getTargeting().requiresLineOfSight() ? (LivingEntity)potentialTargets.stream().filter(entity -> this.hasLineOfSight(level, turretPos, (LivingEntity)entity)).min(Comparator.comparingDouble(entity -> entity.m_20238_(turretPos))).orElse(null) : (LivingEntity)potentialTargets.stream().min(Comparator.comparingDouble(entity -> entity.m_20238_(turretPos))).orElse(null);
            if (this.target != null) {
                int predMult = this.config.getTargeting().getPredictionMultiplier();
                double predictedX = this.target.m_20185_() + this.target.m_20184_().f_82479_ * (double)predMult;
                double predictedY = this.target.m_20186_() + (double)(this.target.m_20206_() / 2.0f);
                double predictedZ = this.target.m_20189_() + this.target.m_20184_().f_82481_ * (double)predMult;
                float smoothing = this.config.getTargeting().getPositionSmoothing();
                double resultX = TurretBlockEntity.lerp(this.smoothedTargetX, predictedX, smoothing);
                double resultY = TurretBlockEntity.lerp(this.smoothedTargetY, predictedY, smoothing);
                double resultZ = TurretBlockEntity.lerp(this.smoothedTargetZ, predictedZ, smoothing);
                this.smoothedTargetX = resultX;
                this.smoothedTargetY = resultY;
                this.smoothedTargetZ = resultZ;
            }
        }
    }

    protected boolean hasLineOfSight(Level level, Vec3 turretPos, LivingEntity target) {
        Vec3 targetPos = target.m_146892_();
        Vec3 toTarget = targetPos.m_82546_(turretPos);
        double distance = toTarget.m_82553_();
        Vec3 rayVector = toTarget.m_82541_().m_82490_(distance);
        Vec3 adjustedTurretPos = turretPos.m_82520_(0.0, 0.5, 0.0);
        ClipContext clipContext = new ClipContext(adjustedTurretPos, adjustedTurretPos.m_82549_(rayVector), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
        BlockHitResult hitResult = level.m_45547_(clipContext);
        return hitResult.m_6662_() == HitResult.Type.MISS;
    }

    protected boolean isTargetValid() {
        if (this.target == null || !this.target.m_6084_() || this.target.m_213877_()) {
            return false;
        }
        ChunkPos targetChunkPos = new ChunkPos(this.target.m_20183_());
        assert (this.f_58857_ != null);
        if (!this.f_58857_.m_7232_(targetChunkPos.f_45578_, targetChunkPos.f_45579_)) {
            return false;
        }
        double distanceSquared = this.target.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5);
        return distanceSquared <= this.targetingRadius * this.targetingRadius;
    }

    protected static double lerp(double a, double b, double t) {
        return a + t * (b - a);
    }

    protected void updateYaw() {
        if (this.config == null) {
            return;
        }
        this.previousYaw = this.yaw;
        if (this.smoothedTargetX != 0.0 || this.smoothedTargetZ != 0.0) {
            double dx = this.smoothedTargetX - ((double)this.f_58858_.m_123341_() + 0.5);
            double dz = this.smoothedTargetZ - ((double)this.f_58858_.m_123343_() + 0.5);
            float targetYaw = (float)(Math.atan2(dx, dz) * 57.29577951308232) + 180.0f;
            targetYaw = (targetYaw + 360.0f) % 360.0f;
            this.yaw = (this.yaw + 360.0f) % 360.0f;
            float yawDifference = targetYaw - this.yaw;
            if (yawDifference > 180.0f) {
                yawDifference -= 360.0f;
            } else if (yawDifference < -180.0f) {
                yawDifference += 360.0f;
            }
            float rotSpeed = this.config.getTargeting().getRotationSpeed();
            this.yaw += yawDifference * rotSpeed;
            this.yaw %= 360.0f;
            if (this.yaw < 0.0f) {
                this.yaw += 360.0f;
            }
        }
    }

    protected void updatePitch() {
        if (this.config == null) {
            return;
        }
        this.previousPitch = this.pitch;
        if (this.smoothedTargetY != 0.0) {
            double dx = this.smoothedTargetX - ((double)this.f_58858_.m_123341_() + 0.5);
            float pitchDifference = this.getPitchDifference(dx);
            float rotSpeed = this.config.getTargeting().getRotationSpeed();
            this.pitch += pitchDifference * rotSpeed;
        }
    }

    private float getPitchDifference(double dx) {
        double dy = this.smoothedTargetY - ((double)this.f_58858_.m_123342_() + 1.0);
        double dz = this.smoothedTargetZ - ((double)this.f_58858_.m_123343_() + 0.5);
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        float targetPitch = (float)(Math.atan2(dy, horizontalDistance) * 57.29577951308232);
        targetPitch = Mth.m_14036_((float)targetPitch, (float)this.config.getTargeting().getMinPitch(), (float)this.config.getTargeting().getMaxPitch());
        return targetPitch - this.pitch;
    }

    protected boolean isAdjacentToFireRateModule(BlockGetter world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.m_121945_(direction);
            if (!(world.m_8055_(neighborPos).m_60734_() instanceof FireRateModuleBlock)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAdjacentToDamageModule(BlockGetter world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.m_121945_(direction);
            if (!(world.m_8055_(neighborPos).m_60734_() instanceof DamageModuleBlock)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAdjacentToRangeModule(BlockGetter world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.m_121945_(direction);
            if (!(world.m_8055_(neighborPos).m_60734_() instanceof RangeModuleBlock)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAdjacentToShellCatchingModule() {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = this.f_58858_.m_121945_(direction);
            assert (this.f_58857_ != null);
            if (!(this.f_58857_.m_8055_(neighborPos).m_60734_() instanceof ShellCatcherModuleBlock)) continue;
            return true;
        }
        return false;
    }

    protected boolean isOwner(LivingEntity entity) {
        return entity.m_20148_().equals(this.ownerUUID);
    }

    public float getPreviousYaw() {
        return this.previousYaw;
    }

    public float getPreviousPitch() {
        return this.previousPitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getRecoilPitchOffset() {
        return this.recoilPitchOffset;
    }

    public void setOwner(ServerPlayer player) {
        this.ownerUUID = player.m_20148_();
        this.ownerName = player.m_7755_().getString();
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128350_("Yaw", this.yaw);
        tag.m_128350_("Pitch", this.pitch);
        tag.m_128379_("Disabled", this.disabled);
        tag.m_128405_("DisableCooldown", this.disableCooldown);
        tag.m_128405_("IdleTicks", this.idleTicks);
        tag.m_128379_("IsScanning", this.isScanning);
        tag.m_128379_("ScanningRight", this.scanningRight);
        tag.m_128350_("ScanStartYaw", this.scanStartYaw);
        tag.m_128379_("ReturningToScanPitch", this.returningToScanPitch);
        if (this.ownerUUID != null) {
            tag.m_128362_("OwnerUUID", this.ownerUUID);
            tag.m_128359_("OwnerName", this.ownerName);
        }
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.previousYaw = this.yaw = tag.m_128457_("Yaw");
        this.previousPitch = this.pitch = tag.m_128457_("Pitch");
        this.disabled = tag.m_128471_("Disabled");
        this.disableCooldown = tag.m_128451_("DisableCooldown");
        this.idleTicks = tag.m_128451_("IdleTicks");
        this.isScanning = tag.m_128471_("IsScanning");
        this.scanningRight = tag.m_128471_("ScanningRight");
        this.scanStartYaw = tag.m_128457_("ScanStartYaw");
        this.returningToScanPitch = tag.m_128471_("ReturningToScanPitch");
        this.itemHandler.deserializeNBT(tag.m_128469_("Inventory"));
        if (tag.m_128403_("OwnerUUID")) {
            this.ownerUUID = tag.m_128342_("OwnerUUID");
            this.ownerName = tag.m_128461_("OwnerName");
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public SimpleContainer getContainer() {
        SimpleContainer container = new SimpleContainer(10);
        for (int i = 0; i < 10; ++i) {
            container.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return container;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && side != Direction.UP) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private /* synthetic */ boolean lambda$findTarget$1(boolean hasTeamLog, boolean hasEnemyLog, List loggedEntityUUIDs, List blacklistedEntityTypes, List whitelistedEntityUUIDs, List whitelistedEntityTypes, boolean finalIsPlayerTargetingModule, boolean finalIsHostileTargetingModule, LivingEntity entity) {
        return !(entity == null || !entity.m_6084_() || this.isOwner(entity) || !(!hasTeamLog && !hasEnemyLog || hasTeamLog && !loggedEntityUUIDs.contains(entity.m_20148_()) && !blacklistedEntityTypes.contains(EntityType.m_20613_((EntityType)entity.m_6095_()).toString())) && (!hasEnemyLog || !whitelistedEntityUUIDs.contains(entity.m_20148_()) && !whitelistedEntityTypes.contains(EntityType.m_20613_((EntityType)entity.m_6095_()).toString())) || entity instanceof EnderMan || entity.m_20145_() && !this.hasRangeModule || finalIsPlayerTargetingModule && (!(entity instanceof Player) || ((Player)entity).m_7500_()) || finalIsHostileTargetingModule && entity.m_6095_().m_20674_() != MobCategory.MONSTER && !entity.m_6095_().m_204039_(ModTags.Entities.TURRET_ENEMY_WHITELIST) || entity.m_6095_().m_204039_(ModTags.Entities.TURRET_BLACKLIST));
    }
}

