/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import top.ribs.scguns.blockentity.ShockCoilBlockEntity;
import top.ribs.scguns.init.ModBlockEntities;
import top.ribs.scguns.util.ShockCoilTooltipHelper;

public class ShockCoilBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public ShockCoilBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_) {
            boolean hasRedstonePower = level.m_276867_(pos);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ShockCoilBlockEntity) {
                ShockCoilBlockEntity shockCoil = (ShockCoilBlockEntity)blockEntity;
                shockCoil.setRedstoneDisabled(hasRedstonePower);
            }
        }
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ShockCoilBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : ShockCoilBlock.createTickerHelper(type, (BlockEntityType)ModBlockEntities.SHOCK_COIL.get(), ShockCoilBlockEntity::serverTick);
    }

    public void m_5871_(ItemStack stack, @javax.annotation.Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        ShockCoilTooltipHelper.addShockCoilTooltip(stack, level instanceof Level ? (Level)level : null, tooltip, flag);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> givenType, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
        return expectedType == givenType ? ticker : null;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ShockCoilBlockEntity) {
                ((ShockCoilBlockEntity)blockEntity).drops();
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }
}

