/*
 * Decompiled with CFR 0.152.
 */
package top.ribs.scguns.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import top.ribs.scguns.block.NiterLayerBlock;
import top.ribs.scguns.block.VentBlock;
import top.ribs.scguns.block.VentCollectorBlock;
import top.ribs.scguns.init.ModBlocks;

public class GeothermalVentBlock
extends VentBlock
implements SimpleWaterloggedBlock {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape GEOTHERMAL_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public GeothermalVentBlock(BlockBehaviour.Properties properties) {
        super(properties, new ResourceLocation("scguns", "geothermal_vent"));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)VENT_TYPE, (Comparable)((Object)VentBlock.VentType.BASE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)VENT_POWER, (Comparable)Integer.valueOf(1)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        FluidState fluidState = level.m_6425_(pos = context.m_8083_());
        boolean waterlogged = fluidState.m_76152_() == Fluids.f_76193_;
        boolean isActive = this.isActive((LevelAccessor)level, pos);
        int ventPower = this.calculateVentPower((LevelAccessor)level, pos);
        return (BlockState)((BlockState)((BlockState)this.updateState(level.m_8055_(pos.m_7495_()), level.m_8055_(pos.m_7494_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(isActive))).m_61124_((Property)VENT_POWER, (Comparable)Integer.valueOf(ventPower));
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        BlockState updatedState = super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
        return (BlockState)updatedState.m_61124_((Property)WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)WATERLOGGED)));
    }

    @Override
    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
    }

    @Override
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return GEOTHERMAL_SHAPE;
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!world.f_46443_ && ((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && !this.hasVentCollectorAbove((LevelReader)world, pos) && this.config != null && this.config.getPlacement().isEnabled() && this.shouldPlaceBlock(random) && this.hasWaterAround((LevelReader)world, pos)) {
            this.placeLayerBlock(world, pos, random);
        }
        world.m_186460_(pos, (Block)this, this.calculateNextTickInterval());
    }

    private boolean shouldPlaceBlock(RandomSource random) {
        if (this.config == null) {
            return false;
        }
        return random.m_188501_() < this.config.getPlacement().getPlacementChance();
    }

    private boolean hasWaterAround(LevelReader world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos adjacentPos;
            if (direction == Direction.UP || direction == Direction.DOWN || !world.m_6425_(adjacentPos = pos.m_121945_(direction)).m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        return false;
    }

    private void placeLayerBlock(ServerLevel world, BlockPos pos, RandomSource random) {
        if (this.config == null) {
            return;
        }
        ResourceLocation blockToPlace = this.config.getPlacement().getBlockToPlace();
        if (blockToPlace == null) {
            return;
        }
        Block layerBlock = blockToPlace.toString().equals("scguns:niter_layer") ? (Block)ModBlocks.NITER_LAYER.get() : (blockToPlace.toString().equals("scguns:sulfur_layer") ? (Block)ModBlocks.SULFUR_LAYER.get() : (Block)ForgeRegistries.BLOCKS.getValue(blockToPlace));
        if (layerBlock == null || layerBlock == Blocks.f_50016_) {
            return;
        }
        int radius = this.config.getPlacement().getRadius();
        double angle = random.m_188500_() * 2.0 * Math.PI;
        double distance = Math.sqrt(random.m_188500_()) * (double)radius;
        int x = (int)Math.round(Math.cos(angle) * distance);
        int z = (int)Math.round(Math.sin(angle) * distance);
        int y = random.m_188503_(3) - 1;
        BlockPos randomPos = pos.m_7918_(x, y, z);
        if (this.canPlaceLayerBlock(world, randomPos)) {
            BlockPos abovePos = randomPos.m_7494_();
            BlockState currentState = world.m_8055_(abovePos);
            boolean isWater = currentState.m_60819_().m_205070_(FluidTags.f_13131_);
            if (currentState.m_60795_() || isWater) {
                BlockState layerState = layerBlock.m_49966_();
                if (layerState.m_61138_((Property)NiterLayerBlock.f_56581_)) {
                    layerState = (BlockState)layerState.m_61124_((Property)NiterLayerBlock.f_56581_, (Comparable)Integer.valueOf(1));
                }
                if (layerState.m_61138_((Property)NiterLayerBlock.WATERLOGGED) && isWater) {
                    layerState = (BlockState)layerState.m_61124_((Property)NiterLayerBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                }
                world.m_7731_(abovePos, layerState, 3);
            }
        }
    }

    private boolean canPlaceLayerBlock(ServerLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        BlockState aboveState = world.m_8055_(pos.m_7494_());
        return state.m_60783_((BlockGetter)world, pos, Direction.UP) && (aboveState.m_60795_() || aboveState.m_60819_().m_205070_(FluidTags.f_13131_)) && !(state.m_60734_() instanceof GeothermalVentBlock) && !(aboveState.m_60734_() instanceof GeothermalVentBlock);
    }

    public void m_214162_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        double offsetZ;
        double offsetY;
        double offsetX;
        int i;
        if (!this.isTopOrBaseWithoutTop(state, level, pos) || !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            return;
        }
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = level.m_8055_(abovePos);
        if (aboveState.m_60734_() instanceof VentCollectorBlock) {
            return;
        }
        if (!this.shouldShowParticles()) {
            return;
        }
        this.playAmbientSound(level, pos, random);
        for (i = 0; i < random.m_188503_(2) + 2; ++i) {
            offsetX = random.m_188500_() * 0.05 - 0.025;
            offsetY = 0.05 + random.m_188500_() * 0.05;
            offsetZ = random.m_188500_() * 0.05 - 0.025;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, offsetX, offsetY, offsetZ);
        }
        for (i = 0; i < random.m_188503_(2) + 2; ++i) {
            offsetX = random.m_188500_() * 0.2 - 0.1;
            offsetY = 0.05 + random.m_188500_() * 0.05;
            offsetZ = random.m_188500_() * 0.2 - 0.1;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, offsetX, offsetY, offsetZ);
        }
        for (i = 0; i < random.m_188503_(2) + 2; ++i) {
            offsetX = random.m_188500_() * 0.2 - 0.1;
            offsetY = 0.05 + random.m_188500_() * 0.05;
            offsetZ = random.m_188500_() * 0.2 - 0.1;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123795_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, offsetX, offsetY, offsetZ);
        }
        for (i = 0; i < random.m_188503_(2) + 1; ++i) {
            offsetX = random.m_188500_() * 0.05 - 0.025;
            offsetY = 0.2 + random.m_188500_() * 0.2;
            offsetZ = random.m_188500_() * 0.05 - 0.025;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, offsetX, offsetY, offsetZ);
        }
    }

    @Override
    protected boolean isActive(LevelAccessor level, BlockPos pos) {
        if (this.config == null) {
            this.reloadConfig();
            if (this.config == null) {
                return false;
            }
        }
        BlockPos basePos = this.getBasePos(level, pos);
        BlockState belowState = level.m_8055_(basePos.m_7495_());
        ResourceLocation configBaseBlock = this.config.getActivation().getBaseBlock();
        Block baseBlock = (Block)ForgeRegistries.BLOCKS.getValue(configBaseBlock);
        if (baseBlock == null || !belowState.m_60713_(baseBlock)) {
            return false;
        }
        if (this.config.getActivation().requiresWaterlogged()) {
            BlockState currentState = level.m_8055_(basePos);
            if (currentState.m_61138_((Property)WATERLOGGED)) {
                return (Boolean)currentState.m_61143_((Property)WATERLOGGED);
            }
            return false;
        }
        return true;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

