/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.ILocalResearchTree;
import com.minecolonies.api.research.IResearchEffect;
import com.minecolonies.api.research.IResearchEffectManager;
import com.minecolonies.api.research.util.ResearchState;
import net.minecraft.resources.ResourceLocation;

public class LocalResearch
implements ILocalResearch {
    private final int depth;
    private ResearchState state;
    private final ResourceLocation id;
    private final ResourceLocation branch;
    private int progress;

    public LocalResearch(ResourceLocation id, ResourceLocation branch, int depth) {
        this.id = id;
        this.depth = depth;
        this.branch = branch;
    }

    @Override
    public boolean research(IResearchEffectManager effects, ILocalResearchTree tree) {
        if (this.state == ResearchState.IN_PROGRESS) {
            ++this.progress;
            if (this.progress >= IGlobalResearchTree.getInstance().getBranchData(this.branch).getBaseTime(this.depth)) {
                this.state = ResearchState.FINISHED;
                for (IResearchEffect effect : IGlobalResearchTree.getInstance().getResearch(this.branch, this.getId()).getEffects()) {
                    effects.applyEffect(effect);
                }
                tree.finishResearch(this.id);
                return true;
            }
        }
        return false;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public ResearchState getState() {
        return this.state;
    }

    @Override
    public ResourceLocation getBranch() {
        return this.branch;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public void setState(ResearchState value) {
        this.state = value;
    }

    @Override
    public void setProgress(int progress) {
        this.progress = progress;
    }
}

