/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactivateBuildingMessage
implements IMessage {
    private BlockPos pos;

    public ReactivateBuildingMessage() {
    }

    public ReactivateBuildingMessage(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        BlockEntity tileEntity;
        AbstractBuilding building;
        ServerPlayer player = ctxIn.getSender();
        Level world = player.m_20193_();
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, this.pos);
        if (colony != null && colony.getPermissions().hasPermission((Player)player, Action.MANAGE_HUTS) && (building = (AbstractBuilding)colony.getBuildingManager().getBuilding(this.pos)) == null && (tileEntity = world.m_7702_(this.pos)) instanceof TileEntityColonyBuilding) {
            TileEntityColonyBuilding hut = (TileEntityColonyBuilding)tileEntity;
            if (!colony.getBuildingManager().canPlaceAt(tileEntity.m_58900_().m_60734_(), this.pos, (Player)player)) {
                return;
            }
            hut.reactivate();
            colony.getBuildingManager().addNewBuilding(hut, world);
        }
    }
}

