/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.util;

import com.ldtteam.structurize.placement.structure.AbstractStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.IBuilderWorkOrder;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.StatsUtil;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.core.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.core.colony.jobs.AbstractJobStructure;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIStructure;
import com.minecolonies.core.entity.ai.workers.util.BuildingProgressStage;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.util.WorkerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingStructureHandler<J extends AbstractJobStructure<?, J>, B extends AbstractBuildingStructureBuilder>
extends AbstractStructureHandler {
    private static final double XP_EACH_BLOCK = 0.05;
    private final AbstractEntityAIStructure<J, B> structureAI;
    private final BuildingProgressStage[] stages;
    private IBuilding building;
    private int stage = 0;
    private IBuilderWorkOrder workOrder;

    public BuildingStructureHandler(Level world, IWorkOrder workOrder, AbstractEntityAIStructure<J, B> entityAIStructure, BuildingProgressStage[] stages) {
        super(world, workOrder.getLocation(), workOrder.getBlueprint(), new PlacementSettings(workOrder.isMirrored() ? Mirror.FRONT_BACK : Mirror.NONE, BlockPosUtil.getRotationFromRotations(workOrder.getRotation())));
        this.setupBuilding();
        this.workOrder = (IBuilderWorkOrder)workOrder;
        this.structureAI = entityAIStructure;
        this.stages = stages;
        for (int i = 0; i < stages.length; ++i) {
            BuildingProgressStage stage = stages[i];
            if (stage != workOrder.getStage()) continue;
            this.stage = i;
            break;
        }
        this.workOrder.setStage(this.getStage());
    }

    private void setupBuilding() {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(this.getWorld(), this.getWorldPos());
        if (colony != null) {
            this.building = colony.getBuildingManager().getBuilding(this.getWorldPos());
        }
    }

    @Nullable
    public BuildingProgressStage getStage() {
        if (this.stage >= this.stages.length) {
            return null;
        }
        return this.stages[this.stage];
    }

    public boolean nextStage() {
        return ++this.stage < this.stages.length;
    }

    public void setStage(BuildingProgressStage stage) {
        for (int i = 0; i < this.stages.length; ++i) {
            if (this.stages[i] != stage) continue;
            this.stage = i;
            this.workOrder.setStage(stage);
            return;
        }
    }

    public void prePlacementLogic(BlockPos worldPos, BlockState blockState, List<ItemStack> requiredItems) {
        WorkerUtil.faceBlock(worldPos, this.structureAI.getWorker());
        this.structureAI.getWorker().m_8061_(EquipmentSlot.MAINHAND, requiredItems.isEmpty() ? ItemStackUtils.EMPTY : requiredItems.get(0));
        if (Mth.m_14107_((double)this.structureAI.getWorker().m_20185_()) == worldPos.m_123341_() && Mth.m_14040_((int)(worldPos.m_123342_() - (int)this.structureAI.getWorker().m_20186_())) <= 1 && Mth.m_14107_((double)this.structureAI.getWorker().m_20189_()) == worldPos.m_123343_() && this.structureAI.getWorker().getNavigation().m_26571_()) {
            EntityNavigationUtils.walkAwayFrom(this.structureAI.getWorker(), worldPos, 1, 1.0);
        }
        this.structureAI.getWorker().m_6674_(InteractionHand.MAIN_HAND);
    }

    @Nullable
    public IItemHandler getInventory() {
        return this.structureAI.getWorker().getInventoryCitizen();
    }

    public void triggerSuccess(BlockPos pos, List<ItemStack> list, boolean placement) {
        BlockPos worldPos = this.getProgressPosInWorld(pos);
        BlockState state = this.getBluePrint().m_8055_(pos);
        if (this.building != null) {
            this.building.registerBlockPosition(state, worldPos, this.getWorld());
        }
        if (placement) {
            this.structureAI.getWorker().getCitizenExperienceHandler().addExperience(0.05);
            for (ItemStack stack : list) {
                StatsUtil.trackStat(this.structureAI.getWorker().getCitizenData().getWorkBuilding(), "blocks_placed", 1);
                this.structureAI.reduceNeededResources(stack);
                this.structureAI.getWorker().getCitizenColonyHandler().getColonyOrRegister().getStatisticsManager().increment("blocks_placed", this.structureAI.getWorker().getCitizenColonyHandler().getColonyOrRegister().getDay());
            }
            BlockState blockStateForSound = state.m_60734_() == com.ldtteam.structurize.blocks.ModBlocks.blockSolidSubstitution.get() ? this.structureAI.getSolidSubstitution(pos) : state;
            this.structureAI.getWorker().queueSound(blockStateForSound.m_60827_().m_56777_(), worldPos, 10, 0, (blockStateForSound.m_60827_().m_56773_() + 1.0f) * 0.5f, blockStateForSound.m_60827_().m_56774_() * 0.8f);
        }
        if (state.m_60734_() == ModBlocks.blockWayPoint) {
            this.structureAI.getWorker().getCitizenColonyHandler().getColonyOrRegister().addWayPoint(worldPos, state);
        }
    }

    public void triggerEntitySuccess(BlockPos blockPos, List<ItemStack> list, boolean placement) {
        if (placement) {
            this.structureAI.getWorker().getCitizenExperienceHandler().addExperience(0.05);
            for (ItemStack stack : list) {
                this.structureAI.reduceNeededResources(stack);
            }
        }
    }

    public boolean hasRequiredItems(@NotNull List<ItemStack> requiredItems) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (ItemStack stack : requiredItems) {
            if (((EquipmentTypeEntry)ModEquipmentTypes.flint_and_steel.get()).checkIsEquipment(stack) && this.structureAI.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.flint_and_steel.get())) {
                return false;
            }
            itemList.add(stack);
        }
        return AbstractEntityAIStructure.hasListOfResInInvOrRequest(this.structureAI, itemList, itemList.size() > 1) == AbstractEntityAIStructure.ItemCheckResult.SUCCESS;
    }

    public void consume(List<ItemStack> requiredItems) {
        if (this.getInventory() != null) {
            for (ItemStack tempStack : requiredItems) {
                if (ItemStackUtils.isEmpty(tempStack)) continue;
                InventoryUtils.reduceBucketAwareStackInItemHandler(this.getInventory(), tempStack, tempStack.m_41613_());
            }
        }
    }

    public boolean isCreative() {
        return Constants.BUILDER_INF_RESOURECES;
    }

    public int getStepsPerCall() {
        return 1;
    }

    public int getMaxBlocksCheckedPerCall() {
        return 10000;
    }

    public boolean isStackFree(@Nullable ItemStack itemStack) {
        return itemStack == null || itemStack.m_41619_() || itemStack.m_204117_(ItemTags.f_13143_) || itemStack.m_41720_() == new ItemStack(ModBlocks.blockDecorationPlaceholder, 1).m_41720_();
    }

    public boolean allowReplace() {
        return this.getStage() != null && this.getStage() != BuildingProgressStage.CLEAR;
    }

    public ItemStack getHeldItem() {
        return this.structureAI.getWorker().m_21205_();
    }

    public BlockState getSolidBlockForPos(BlockPos blockPos) {
        return this.structureAI.getSolidSubstitution(blockPos);
    }

    public BlockState getSolidBlockForPos(BlockPos worldPos, @Nullable Function<BlockPos, BlockState> virtualBlocks) {
        return this.structureAI.getSolidSubstitution(worldPos);
    }

    public boolean replaceWithSolidBlock(BlockState blockState) {
        return !BlockUtils.isGoodFloorBlock((BlockState)blockState) || this.structureAI.shallReplaceSolidSubstitutionBlock(blockState.m_60734_(), blockState);
    }

    public boolean fancyPlacement() {
        return true;
    }

    public boolean shouldBlocksBeConsideredEqual(BlockState state1, BlockState state2) {
        Block block1 = state1.m_60734_();
        Block block2 = state2.m_60734_();
        if (block1 == Blocks.f_50276_ || block2 == Blocks.f_50276_) {
            return block1 == block2;
        }
        return block1 == Blocks.f_50440_ && block2 == Blocks.f_50493_ || block2 == Blocks.f_50440_ && block1 == Blocks.f_50493_ || block1 == ModBlocks.blockRack && block2 == ModBlocks.blockRack;
    }
}

