/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production.agriculture;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildingextensions.plantation.IPlantationModule;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.requestable.IConcreteDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.entity.ai.JobStatus;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.colony.buildingextensions.PlantationField;
import com.minecolonies.core.colony.buildings.modules.BuildingExtensionsModule;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingPlantation;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobPlanter;
import com.minecolonies.core.entity.ai.workers.crafting.AbstractEntityAICrafting;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkPlanter
extends AbstractEntityAICrafting<JobPlanter, BuildingPlantation> {
    protected static final int BONEMEAL_TO_KEEP = 16;
    private static final double XP_PER_HARVEST = 1.0;
    private int currentFieldActionCount = 0;
    private IPlantationModule.PlantationModuleResult activeModuleResult = null;
    private IConcreteDeliverable currentDeliverable;

    public EntityAIWorkPlanter(@NotNull JobPlanter job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.PREPARING, this::prepare, 5), new AITarget<Object>(AIWorkerState.PLANTATION_PICK_FIELD, this::pickField, 20), new AITarget<Object>(AIWorkerState.PLANTATION_MOVE_TO_FIELD, this::moveToField, 20), new AITarget<Object>(AIWorkerState.PLANTATION_DECIDE_FIELD_WORK, this::decideFieldWork, 20), new AITarget<Object>(AIWorkerState.PLANTATION_WORK_FIELD, this::workField, 20), new AITarget<Object>(AIWorkerState.PLANTATION_RETURN_TO_BUILDING, this::returnToBuilding, 20));
        this.worker.m_21553_(true);
    }

    private IAIState prepare() {
        if (this.activeModuleResult != null) {
            return AIWorkerState.PLANTATION_WORK_FIELD;
        }
        return AIWorkerState.PLANTATION_PICK_FIELD;
    }

    private IAIState pickField() {
        this.worker.getCitizenData().setJobStatus(JobStatus.IDLE);
        if (this.building == null || ((BuildingPlantation)this.building).getBuildingLevel() < 1) {
            this.worker.getCitizenData().setJobStatus(JobStatus.STUCK);
            return AIWorkerState.IDLE;
        }
        BuildingExtensionsModule module = (BuildingExtensionsModule)((BuildingPlantation)this.building).getFirstModuleOccurance(BuildingExtensionsModule.class);
        if (module.hasNoExtensions()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"entity.farmer.nofreefields"), ChatPriority.BLOCKING));
            }
            this.worker.getCitizenData().setJobStatus(JobStatus.STUCK);
            return AIWorkerState.IDLE;
        }
        IBuildingExtension lastField = module.getCurrentExtension();
        IBuildingExtension fieldToWork = module.getExtensionToWorkOn();
        if (fieldToWork != null) {
            if (lastField != fieldToWork) {
                this.currentFieldActionCount = 0;
            }
            this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
            this.worker.getCitizenData().setJobStatus(JobStatus.WORKING);
            return AIWorkerState.PLANTATION_MOVE_TO_FIELD;
        }
        return AIWorkerState.IDLE;
    }

    @Override
    public void onBlockDropReception(List<ItemStack> blockDrops) {
        super.onBlockDropReception(blockDrops);
        for (ItemStack stack : blockDrops) {
            ((BuildingPlantation)this.building).getModule(BuildingModules.STATS_MODULE).incrementBy("item_obtained;" + stack.m_41720_().m_5524_(), stack.m_41613_());
        }
    }

    private IAIState moveToField() {
        PlantationField currentPlantationField = this.getCurrentField();
        if (currentPlantationField == null) {
            return AIWorkerState.PLANTATION_PICK_FIELD;
        }
        if (!this.walkToSafePos(currentPlantationField.getPosition())) {
            return this.getState();
        }
        return AIWorkerState.PLANTATION_DECIDE_FIELD_WORK;
    }

    private IAIState decideFieldWork() {
        PlantationField currentPlantationField = this.getCurrentField();
        if (currentPlantationField == null) {
            return AIWorkerState.PLANTATION_PICK_FIELD;
        }
        IPlantationModule planterModule = currentPlantationField.getModule();
        BlockPos position = planterModule.getNextWorkingPosition(this.world);
        if (position == null) {
            this.resetActiveField();
            return AIWorkerState.IDLE;
        }
        IPlantationModule.PlantationModuleResult.Builder result = planterModule.decideFieldWork(this.world, position);
        this.activeModuleResult = result.build(planterModule, position);
        return AIWorkerState.PLANTATION_WORK_FIELD;
    }

    private IAIState workField() {
        ActionHandlerResult handlerResult;
        IPlantationModule planterModule = this.activeModuleResult.getModule();
        if (!Objects.isNull(this.activeModuleResult.getActionPosition()) && !this.walkToSafePos(planterModule.getPositionToWalkTo(this.world, this.activeModuleResult.getActionPosition()))) {
            return AIWorkerState.PLANTATION_WORK_FIELD;
        }
        switch (this.activeModuleResult.getAction()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NONE: {
                ActionHandlerResult actionHandlerResult = ActionHandlerResult.FINISHED;
                break;
            }
            case PLANT: {
                ActionHandlerResult actionHandlerResult = this.handlePlantingAction();
                break;
            }
            case BONEMEAL: {
                ActionHandlerResult actionHandlerResult = this.handleBonemealAction();
                break;
            }
            case HARVEST: {
                ActionHandlerResult actionHandlerResult = this.handleMiningAction(true);
                break;
            }
            case CLEAR: {
                ActionHandlerResult actionHandlerResult = handlerResult = this.handleMiningAction(false);
            }
        }
        if (handlerResult.equals((Object)ActionHandlerResult.FINISHED)) {
            CitizenItemUtils.removeHeldItem(this.worker);
            if (this.activeModuleResult.getAction().increasesActionCount()) {
                ++this.currentFieldActionCount;
                this.incrementActionsDone();
                this.worker.decreaseSaturationForContinuousAction();
            }
            AIWorkerState result = AIWorkerState.PLANTATION_WORK_FIELD;
            if (this.activeModuleResult.shouldResetWorkingPosition()) {
                result = AIWorkerState.PLANTATION_DECIDE_FIELD_WORK;
            }
            if (this.activeModuleResult.shouldResetCurrentField() || this.currentFieldActionCount >= planterModule.getActionLimit()) {
                this.resetActiveField();
                result = AIWorkerState.PLANTATION_PICK_FIELD;
            }
            this.activeModuleResult = null;
            return result;
        }
        if (handlerResult.equals((Object)ActionHandlerResult.NEEDS_ITEM)) {
            this.activeModuleResult = null;
            return AIWorkerState.PLANTATION_RETURN_TO_BUILDING;
        }
        return AIWorkerState.PLANTATION_WORK_FIELD;
    }

    private IAIState returnToBuilding() {
        if (!this.walkToBuilding()) {
            return this.getState();
        }
        if (this.needsCurrently != null) {
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        return AIWorkerState.IDLE;
    }

    @Nullable
    private PlantationField getCurrentField() {
        BuildingExtensionsModule fieldsModule = (BuildingExtensionsModule)((BuildingPlantation)this.building).getFirstModuleOccurance(BuildingExtensionsModule.class);
        IBuildingExtension iBuildingExtension = fieldsModule.getCurrentExtension();
        if (iBuildingExtension instanceof PlantationField) {
            PlantationField field = (PlantationField)iBuildingExtension;
            return field;
        }
        return null;
    }

    private void resetActiveField() {
        BuildingExtensionsModule fieldsModule = (BuildingExtensionsModule)((BuildingPlantation)this.building).getFirstModuleOccurance(BuildingExtensionsModule.class);
        fieldsModule.resetCurrentExtension();
        this.currentFieldActionCount = 0;
    }

    private ActionHandlerResult handlePlantingAction() {
        if (!Objects.isNull(this.activeModuleResult.getActionPosition())) {
            IPlantationModule planterModule = this.activeModuleResult.getModule();
            ItemStack currentStack = new ItemStack((ItemLike)planterModule.getItem());
            if (this.checkIfItemsUnavailable(new Stack(currentStack, planterModule.getPlantsToRequest(), 1))) {
                return ActionHandlerResult.NEEDS_ITEM;
            }
            int slot = InventoryUtils.findFirstSlotInItemHandlerWith(this.worker.getItemHandlerCitizen(), currentStack.m_41720_());
            CitizenItemUtils.setMainHeldItem(this.worker, slot);
            BlockState blockState = planterModule.getPlantingBlockState(this.world, this.activeModuleResult.getWorkingPosition(), BlockUtils.getBlockStateFromStack((ItemStack)currentStack));
            if (this.world.m_46597_(this.activeModuleResult.getActionPosition(), blockState)) {
                InventoryUtils.reduceStackInItemHandler(this.worker.getItemHandlerCitizen(), currentStack);
                CitizenItemUtils.removeHeldItem(this.worker);
                return ActionHandlerResult.FINISHED;
            }
            return ActionHandlerResult.BUSY;
        }
        return ActionHandlerResult.FINISHED;
    }

    private ActionHandlerResult handleBonemealAction() {
        if (!Objects.isNull(this.activeModuleResult.getActionPosition())) {
            IPlantationModule planterModule = this.activeModuleResult.getModule();
            List<ItemStack> bonemeal = planterModule.getValidBonemeal().stream().map(ItemStack::new).toList();
            if (this.checkIfItemsUnavailable(new StackList(bonemeal, "com.minecolonies.coremod.request.fertilizer", 16, 1))) {
                return ActionHandlerResult.NEEDS_ITEM;
            }
            int boneMealSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), stack -> planterModule.getValidBonemeal().contains(stack.m_41720_()));
            ItemStack stackInSlot = this.worker.getInventoryCitizen().getStackInSlot(boneMealSlot);
            planterModule.applyBonemeal(this.worker, this.activeModuleResult.getActionPosition(), stackInSlot, (Player)this.getFakePlayer());
        }
        return ActionHandlerResult.FINISHED;
    }

    private ActionHandlerResult handleMiningAction(boolean isHarvest) {
        if (!Objects.isNull(this.activeModuleResult.getActionPosition())) {
            if (!this.holdEfficientTool(this.world.m_8055_(this.activeModuleResult.getActionPosition()), this.activeModuleResult.getActionPosition())) {
                return ActionHandlerResult.NEEDS_ITEM;
            }
            boolean mineResult = this.mineBlock(this.activeModuleResult.getActionPosition());
            if (mineResult) {
                CitizenItemUtils.pickupItems(this.worker);
                if (isHarvest) {
                    this.worker.getCitizenExperienceHandler().addExperience(1.0);
                }
            }
            return mineResult ? ActionHandlerResult.FINISHED : ActionHandlerResult.BUSY;
        }
        return ActionHandlerResult.FINISHED;
    }

    private boolean checkIfItemsUnavailable(IConcreteDeliverable deliverable) {
        int invCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), deliverable::matches);
        if (invCount >= deliverable.getMinimumCount()) {
            return false;
        }
        this.currentDeliverable = deliverable;
        this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(deliverable::matches, deliverable.getCount());
        return true;
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata(this.getState() == AIWorkerState.CRAFT || this.getState() == AIWorkerState.PLANTATION_WORK_FIELD || this.getState() == AIWorkerState.PLANTATION_DECIDE_FIELD_WORK ? "working" : "");
    }

    @Override
    protected IAIState decide() {
        IAIState state = super.decide();
        if (state == AIWorkerState.IDLE) {
            return AIWorkerState.PREPARING;
        }
        return state;
    }

    @Override
    public IAIState getStateAfterPickUp() {
        if (this.currentDeliverable != null && !InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this.currentDeliverable.getResult().m_41720_()) && ((BuildingPlantation)this.building).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.DELIVERABLE, r -> this.currentDeliverable.getRequestedItems().stream().anyMatch(((IDeliverable)r.getRequest())::matches)).isEmpty() && ((BuildingPlantation)this.building).getCompletedRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.DELIVERABLE, r -> this.currentDeliverable.getRequestedItems().stream().anyMatch(((IDeliverable)r.getRequest())::matches)).isEmpty()) {
            this.worker.getCitizenData().createRequestAsync(this.currentDeliverable);
        }
        this.currentDeliverable = null;
        this.needsCurrently = null;
        return super.getStateAfterPickUp();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        if (this.getState() != AIWorkerState.PLANTATION_DECIDE_FIELD_WORK && this.getState() != AIWorkerState.PLANTATION_WORK_FIELD) {
            return super.getActionsDoneUntilDumping();
        }
        PlantationField currentPlantationField = this.getCurrentField();
        if (currentPlantationField == null) {
            return super.getActionsDoneUntilDumping();
        }
        return currentPlantationField.getModule().getActionLimit();
    }

    @Override
    public Class<BuildingPlantation> getExpectedBuildingClass() {
        return BuildingPlantation.class;
    }

    @Override
    public boolean hasWorkToDo() {
        return true;
    }

    @Override
    public boolean canGoIdle() {
        if (((BuildingPlantation)this.building).getModule(BuildingModules.PLANTATION_FIELDS).getExtensionToWorkOn() == null) {
            return !super.hasWorkToDo();
        }
        return false;
    }

    private static enum ActionHandlerResult {
        FINISHED,
        BUSY,
        NEEDS_ITEM;

    }
}

