/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.minimal;

import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.CitizenAIState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAICitizenAvoidEntity
implements IStateAI {
    private static final double TOO_CLOSE_TO_MOB = 4.0;
    private static final int CHECKS_BEFORE_SAFE = 40;
    private static final float MIN_MOVE_AWAY_DIST = 7.0f;
    private static final float MED_MOVE_AWAY_DIST = 15.0f;
    private static final float MAX_MOVE_AWAY_DIST = 20.0f;
    private final EntityCitizen citizen;
    private final double farSpeed;
    private final double nearSpeed;
    private final float distanceFromEntity;
    private final Class<? extends Entity> targetEntityClass;
    @Nullable
    private Entity closestLivingEntity;
    private int safeTime = 0;
    private PathResult moveAwayPath;
    private BlockPos startingPos;
    private final Random rand = new Random();

    public EntityAICitizenAvoidEntity(@NotNull EntityCitizen entity, @NotNull Class<? extends Entity> targetEntityClass, float distanceFromEntity, double farSpeed, double nearSpeed) {
        this.citizen = entity;
        this.startingPos = entity.m_20183_();
        this.targetEntityClass = targetEntityClass;
        this.distanceFromEntity = distanceFromEntity;
        this.farSpeed = farSpeed;
        this.nearSpeed = nearSpeed;
        this.citizen.getCitizenAI().addTransition(new AITarget<Object>(CitizenAIState.FLEE, () -> true, () -> {
            this.startingPos = this.citizen.m_20183_();
            return FleeStates.CHECK_ENTITIES;
        }, 1));
        this.citizen.getCitizenAI().addTransition(new AITarget<Object>(FleeStates.CHECK_ENTITIES, () -> true, this::isEntityClose, 5));
        this.citizen.getCitizenAI().addTransition(new AITarget<Object>(FleeStates.RUNNING, this::updateMoving, () -> FleeStates.CHECK_ENTITIES, 5));
    }

    public IState isEntityClose() {
        ++this.safeTime;
        if (this.safeTime > 40) {
            this.reset();
            return CitizenAIState.IDLE;
        }
        Entity currentClosest = this.getClosestToAvoid();
        if (currentClosest != null) {
            this.closestLivingEntity = currentClosest;
            this.safeTime = 0;
            this.performMoveAway();
            return FleeStates.RUNNING;
        }
        return FleeStates.CHECK_ENTITIES;
    }

    private Entity getClosestToAvoid() {
        if (this.targetEntityClass == Player.class) {
            return CompatibilityUtils.getWorldFromCitizen(this.citizen).m_45930_((Entity)this.citizen, (double)this.distanceFromEntity);
        }
        Optional<Entity> entityOptional = CompatibilityUtils.getWorldFromCitizen(this.citizen).m_6249_((Entity)this.citizen, this.citizen.m_20191_().m_82377_((double)this.distanceFromEntity, 3.0, (double)this.distanceFromEntity), target -> target.m_6084_() && this.citizen.m_21574_().m_148306_(target)).stream().filter(this.targetEntityClass::isInstance).findFirst();
        return entityOptional.orElse(null);
    }

    private boolean performMoveAway() {
        if ((this.moveAwayPath == null || !this.moveAwayPath.isInProgress()) && this.citizen.getNavigation().m_26571_()) {
            EntityNavigationUtils.walkAwayFrom(this.citizen, this.citizen.m_20183_().m_7918_(this.rand.nextInt(2), 0, this.rand.nextInt(2)), (int)(this.distanceFromEntity + this.getMoveAwayDist(this.citizen)), this.nearSpeed);
            this.moveAwayPath = this.citizen.getNavigation().getPathResult();
            return true;
        }
        return false;
    }

    private float getMoveAwayDist(AbstractEntityCitizen citizen) {
        if (citizen.m_21223_() >= citizen.m_21233_() - 4.0f) {
            return 7.0f;
        }
        if (citizen.m_21223_() >= citizen.m_21233_() / 2.0f) {
            return 15.0f;
        }
        return 20.0f;
    }

    private boolean updateMoving() {
        this.citizen.playMoveAwaySound();
        @Nullable Entity newClosest = this.getClosestToAvoid();
        if (newClosest != null) {
            if (newClosest.m_19879_() != this.closestLivingEntity.m_19879_()) {
                this.citizen.callForHelp(newClosest, 90000);
                this.closestLivingEntity = newClosest;
            }
            this.performMoveAway();
        }
        if (this.moveAwayPath == null || !this.moveAwayPath.isInProgress()) {
            this.safeTime = 0;
            return true;
        }
        if ((double)this.citizen.m_20270_(this.closestLivingEntity) < 4.0) {
            this.citizen.getNavigation().m_26517_(this.nearSpeed);
        } else {
            this.citizen.getNavigation().m_26517_(this.farSpeed);
        }
        return false;
    }

    public void reset() {
        this.safeTime = 0;
        if (this.startingPos != null) {
            EntityNavigationUtils.walkToPos(this.citizen, this.startingPos, 1, true);
        }
        this.closestLivingEntity = null;
        this.moveAwayPath = null;
        this.startingPos = null;
    }

    public static enum FleeStates implements IState
    {
        CHECK_ENTITIES,
        RUNNING;

    }
}

