/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.resolvers.factory;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.jobs.registry.IJobRegistry;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolverFactory;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.colony.requestsystem.resolvers.PublicWorkerCraftingProductionResolver;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class PublicWorkerCraftingProductionResolverFactory
implements IRequestResolverFactory<PublicWorkerCraftingProductionResolver> {
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_LOCATION = "Location";
    private static final String NBT_JOB = "Job";

    @Override
    @NotNull
    public TypeToken<? extends PublicWorkerCraftingProductionResolver> getFactoryOutputType() {
        return TypeToken.of(PublicWorkerCraftingProductionResolver.class);
    }

    @Override
    @NotNull
    public TypeToken<? extends ILocation> getFactoryInputType() {
        return TypeConstants.ILOCATION;
    }

    @Override
    @NotNull
    public PublicWorkerCraftingProductionResolver getNewInstance(@NotNull IFactoryController factoryController, @NotNull ILocation iLocation, Object ... context) {
        return new PublicWorkerCraftingProductionResolver(iLocation, factoryController.getNewInstance(TypeConstants.ITOKEN), (JobEntry)context[0]);
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull PublicWorkerCraftingProductionResolver publicWorkerCraftingProductionResolverFactory) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_(NBT_TOKEN, (Tag)controller.serialize(publicWorkerCraftingProductionResolverFactory.getId()));
        compound.m_128365_(NBT_LOCATION, (Tag)controller.serialize(publicWorkerCraftingProductionResolverFactory.getLocation()));
        compound.m_128359_(NBT_JOB, IJobRegistry.getInstance().getKey((Object)publicWorkerCraftingProductionResolverFactory.getJobEntry()).toString());
        return compound;
    }

    @Override
    @NotNull
    public PublicWorkerCraftingProductionResolver deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        IToken token = (IToken)controller.deserialize(nbt.m_128469_(NBT_TOKEN));
        ILocation location = (ILocation)controller.deserialize(nbt.m_128469_(NBT_LOCATION));
        JobEntry entry = (JobEntry)IJobRegistry.getInstance().getValue(new ResourceLocation(nbt.m_128461_(NBT_JOB)));
        return new PublicWorkerCraftingProductionResolver(location, token, entry);
    }

    @Override
    public void serialize(IFactoryController controller, PublicWorkerCraftingProductionResolver input, FriendlyByteBuf packetBuffer) {
        controller.serialize(packetBuffer, input.getId());
        controller.serialize(packetBuffer, input.getLocation());
        packetBuffer.writeRegistryId(IMinecoloniesAPI.getInstance().getJobRegistry(), (Object)input.getJobEntry());
    }

    @Override
    public PublicWorkerCraftingProductionResolver deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
        IToken token = (IToken)controller.deserialize(buffer);
        ILocation location = (ILocation)controller.deserialize(buffer);
        JobEntry entry = (JobEntry)buffer.readRegistryId();
        return new PublicWorkerCraftingProductionResolver(location, token, entry);
    }

    @Override
    public short getSerializationId() {
        return 22;
    }
}

