/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.crafting;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.colony.crafting.ToolUsage;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;

public final class ToolsAnalyzer {
    @NotNull
    public static List<ToolUsage> findTools() {
        HashMap<EquipmentTypeEntry, ToolUsage> toolItems = new HashMap<EquipmentTypeEntry, ToolUsage>();
        for (ItemStack stack : IColonyManager.getInstance().getCompatibilityManager().getListOfAllItems()) {
            for (EquipmentTypeEntry toolType : ModEquipmentTypes.getRegistry()) {
                if (toolType == ModEquipmentTypes.none.get() || !toolType.checkIsEquipment(stack)) continue;
                ToolsAnalyzer.tryAddingToolWithLevel(toolItems, toolType, stack);
                if (!stack.m_41792_()) continue;
                for (int enchantLevel = 1; enchantLevel < 4; ++enchantLevel) {
                    ToolsAnalyzer.tryAddingEnchantedTool(toolItems, toolType, stack, enchantLevel);
                }
            }
        }
        return toolItems.values().stream().sorted(Comparator.comparing(ToolUsage::tool, new EquipmentTypeEntry.Comparator())).toList();
    }

    private static void tryAddingEnchantedTool(@NotNull Map<EquipmentTypeEntry, ToolUsage> toolItems, @NotNull EquipmentTypeEntry tool, @NotNull ItemStack stack, int enchantLevel) {
        ItemStack enchantedStack = stack.m_41777_();
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Enchantments.f_44986_, enchantLevel);
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Enchantments.f_44982_, enchantLevel);
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Enchantments.f_44990_, enchantLevel);
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Enchantments.f_44987_, enchantLevel);
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Enchantments.f_44965_, enchantLevel);
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Enchantments.f_44954_, enchantLevel);
        ToolsAnalyzer.tryAddingToolWithLevel(toolItems, tool, enchantedStack);
    }

    private static void tryEnchantStack(@NotNull ItemStack stack, @NotNull Enchantment enchantment, int enchantLevel) {
        if (enchantment.m_6081_(stack) && enchantLevel >= enchantment.m_44702_() && enchantLevel <= enchantment.m_6586_()) {
            stack.m_41663_(enchantment, enchantLevel);
        }
    }

    private static void tryAddingToolWithLevel(@NotNull Map<EquipmentTypeEntry, ToolUsage> toolItems, @NotNull EquipmentTypeEntry tool, @NotNull ItemStack stack) {
        int level = tool.getMiningLevel(stack);
        if (level < 0) {
            return;
        }
        level = Math.min(5, level + ItemStackUtils.getMaxEnchantmentLevel(stack));
        ToolUsage usage = toolItems.computeIfAbsent(tool, ToolUsage::create);
        if (stack.m_41793_()) {
            usage.enchantedToolLevels().get(level).add(stack);
        } else {
            usage.toolLevels().get(level).add(stack);
        }
    }
}

