/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IItemListModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.crafting.ItemStorage;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemListModule
extends AbstractBuildingModule
implements IItemListModule,
IPersistentModule {
    private static final String TAG_ITEMLIST = "itemList";
    private ImmutableList<ItemStorage> itemsAllowed = ImmutableList.of();
    private ImmutableList<ItemStorage> defaultValues = ImmutableList.of();
    private final String id;

    public ItemListModule(String id) {
        this.id = id;
    }

    public ItemListModule(String id, ItemStorage ... defaultStacks) {
        this(id);
        this.defaultValues = ImmutableList.copyOf((Object[])defaultStacks);
        this.itemsAllowed = ImmutableList.copyOf((Object[])defaultStacks);
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        if (compound.m_128441_(this.id)) {
            compound = compound.m_128469_(this.id);
        }
        ArrayList<ItemStorage> allowedItems = new ArrayList<ItemStorage>();
        ListTag filterableList = compound.m_128437_(TAG_ITEMLIST, 10);
        for (int i = 0; i < filterableList.size(); ++i) {
            allowedItems.add(new ItemStorage(ItemStack.m_41712_((CompoundTag)filterableList.m_128728_(i))));
        }
        this.itemsAllowed = ImmutableList.copyOf(allowedItems);
    }

    @Override
    public void serializeNBT(CompoundTag compound) {
        @NotNull ListTag filteredItems = new ListTag();
        for (ItemStorage item : this.itemsAllowed) {
            @NotNull CompoundTag itemCompound = new CompoundTag();
            item.getItemStack().m_41739_(itemCompound);
            filteredItems.add((Object)itemCompound);
        }
        compound.m_128365_(TAG_ITEMLIST, (Tag)filteredItems);
    }

    @Override
    public void addItem(ItemStorage item) {
        if (!this.itemsAllowed.contains((Object)item)) {
            this.itemsAllowed = ImmutableList.builder().addAll(this.itemsAllowed).add((Object)item).build();
            this.markDirty();
        }
    }

    @Override
    public boolean isItemInList(ItemStorage item) {
        return this.itemsAllowed.contains((Object)item);
    }

    @Override
    public void removeItem(ItemStorage item) {
        ArrayList<ItemStorage> allowedItems = new ArrayList<ItemStorage>((Collection<ItemStorage>)this.itemsAllowed);
        allowedItems.remove(item);
        this.itemsAllowed = ImmutableList.copyOf(allowedItems);
        this.markDirty();
    }

    public ImmutableList<ItemStorage> getList() {
        return this.itemsAllowed;
    }

    @Override
    public String getListIdentifier() {
        return this.id;
    }

    @Override
    public void clearItems() {
        this.itemsAllowed = ImmutableList.of();
        this.markDirty();
    }

    @Override
    public void resetToDefaults() {
        this.itemsAllowed = ImmutableList.copyOf(this.defaultValues);
    }

    @Override
    public void serializeToView(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.itemsAllowed.size());
        for (ItemStorage item : this.itemsAllowed) {
            buf.m_130055_(item.getItemStack());
        }
    }

    @Override
    public String getId() {
        return this.id;
    }
}

