/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IAltersRequiredItems;
import com.minecolonies.api.colony.buildings.modules.IModuleWithExternalBlocks;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;

public class FurnaceUserModule
extends AbstractBuildingModule
implements IPersistentModule,
IModuleWithExternalBlocks,
IAltersRequiredItems {
    private static final String TAG_POS = "pos";
    private static final String TAG_POS_COMPAT = "furnacePos";
    private static final String TAG_FURNACES = "furnaces";
    private final List<BlockPos> furnaces = new ArrayList<BlockPos>();

    @Override
    public void deserializeNBT(CompoundTag compound) {
        ListTag furnaceTagList = compound.m_128437_(TAG_FURNACES, 10);
        for (int i = 0; i < furnaceTagList.size(); ++i) {
            if (furnaceTagList.m_128728_(i).m_128441_(TAG_POS)) {
                this.furnaces.add(NbtUtils.m_129239_((CompoundTag)furnaceTagList.m_128728_(i).m_128469_(TAG_POS)));
            }
            if (!furnaceTagList.m_128728_(i).m_128441_(TAG_POS_COMPAT)) continue;
            this.furnaces.add(NbtUtils.m_129239_((CompoundTag)furnaceTagList.m_128728_(i).m_128469_(TAG_POS_COMPAT)));
        }
    }

    @Override
    public void serializeNBT(CompoundTag compound) {
        @NotNull ListTag furnacesTagList = new ListTag();
        for (BlockPos entry : this.furnaces) {
            @NotNull CompoundTag furnaceCompound = new CompoundTag();
            furnaceCompound.m_128365_(TAG_POS, (Tag)NbtUtils.m_129224_((BlockPos)entry));
            furnacesTagList.add((Object)furnaceCompound);
        }
        compound.m_128365_(TAG_FURNACES, (Tag)furnacesTagList);
    }

    @Override
    public void alterItemsToBeKept(TriConsumer<Predicate<ItemStack>, Integer, Boolean> consumer) {
        consumer.accept(this::isAllowedFuel, (Object)(64 * this.building.getBuildingLevel()), (Object)false);
    }

    public void removeFromFurnaces(BlockPos pos) {
        this.furnaces.remove(pos);
    }

    public boolean isAllowedFuel(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack)) {
            return false;
        }
        return ((ItemListModule)this.building.getModuleMatching(ItemListModule.class, m -> m.getId().equals("fuel"))).isItemInList(new ItemStorage(stack));
    }

    public List<BlockPos> getFurnaces() {
        return new ArrayList<BlockPos>(this.furnaces);
    }

    @Override
    public void onBlockPlacedInBuilding(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull Level world) {
        if (blockState.m_60734_() instanceof FurnaceBlock && !this.furnaces.contains(pos)) {
            this.furnaces.add(pos);
        }
    }

    @Override
    public List<BlockPos> getRegisteredBlocks() {
        return new ArrayList<BlockPos>(this.furnaces);
    }
}

