/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildingextensions.registry;

import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildingextensions.registry.BuildingExtensionRegistries;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public final class BuildingExtensionDataManager {
    private static final String TAG_EXTENSION_NAME = "name";
    private static final String TAG_EXTENSION_POSITION = "position";
    private static final String TAG_EXTENSION_DATA = "data";

    private BuildingExtensionDataManager() {
    }

    public static IBuildingExtension compoundToExtension(@NotNull CompoundTag compound) {
        BlockPos position;
        ResourceLocation name = new ResourceLocation(compound.m_128461_(TAG_EXTENSION_NAME));
        IBuildingExtension extension = BuildingExtensionDataManager.resourceLocationToExtension(name, position = BlockPosUtil.read(compound, TAG_EXTENSION_POSITION));
        if (extension != null) {
            extension.deserializeNBT(compound.m_128469_(TAG_EXTENSION_DATA));
        }
        return extension;
    }

    public static IBuildingExtension resourceLocationToExtension(@NotNull ResourceLocation registryName, @NotNull BlockPos position) {
        BuildingExtensionRegistries.BuildingExtensionEntry entry = (BuildingExtensionRegistries.BuildingExtensionEntry)BuildingExtensionRegistries.getBuildingExtensionRegistry().getValue(registryName);
        if (entry == null) {
            Log.getLogger().error("Unknown building extension type '{}'.", (Object)registryName);
            return null;
        }
        return entry.produceExtension(position);
    }

    public static IBuildingExtension bufferToExtension(@NotNull FriendlyByteBuf buf) {
        BuildingExtensionRegistries.BuildingExtensionEntry entry = (BuildingExtensionRegistries.BuildingExtensionEntry)buf.readRegistryIdSafe(BuildingExtensionRegistries.BuildingExtensionEntry.class);
        BlockPos position = buf.m_130135_();
        IBuildingExtension extension = entry.produceExtension(position);
        extension.deserialize(buf);
        return extension;
    }

    public static FriendlyByteBuf extensionToBuffer(@NotNull IBuildingExtension extension) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeRegistryId(BuildingExtensionRegistries.getBuildingExtensionRegistry(), (Object)extension.getBuildingExtensionType());
        buf.m_130064_(extension.getPosition());
        extension.serialize(buf);
        return buf;
    }

    public static CompoundTag extensionToCompound(@NotNull IBuildingExtension extension) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_(TAG_EXTENSION_NAME, extension.getBuildingExtensionType().getRegistryName().toString());
        BlockPosUtil.write(compound, TAG_EXTENSION_POSITION, extension.getPosition());
        compound.m_128365_(TAG_EXTENSION_DATA, (Tag)extension.serializeNBT());
        return compound;
    }
}

