/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules.building;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.EntityIcon;
import com.ldtteam.blockui.controls.Gradient;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.View;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.client.gui.citizen.CitizenWindowUtils;
import com.minecolonies.core.colony.buildings.modules.expedition.ExpeditionLog;
import com.minecolonies.core.colony.buildings.moduleviews.ExpeditionLogModuleView;
import com.minecolonies.core.network.messages.server.colony.building.MarkBuildingDirtyMessage;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ExpeditionLogModuleWindow
extends AbstractModuleWindow<ExpeditionLogModuleView> {
    private int tick = 1;

    public ExpeditionLogModuleWindow(@NotNull ExpeditionLogModuleView module) {
        super(module, new ResourceLocation("minecolonies", "gui/layouthuts/layoutexpeditionlog.xml"));
    }

    @Override
    public void onUpdate() {
        if (this.tick > 0 && --this.tick == 0) {
            Network.getNetwork().sendToServer(new MarkBuildingDirtyMessage(this.buildingView));
        }
        if (((ExpeditionLogModuleView)this.moduleView).checkAndResetUpdated()) {
            this.tick = 20;
            this.refreshLog();
        }
        super.onUpdate();
    }

    private void refreshLog() {
        ExpeditionLog expeditionLog = ((ExpeditionLogModuleView)this.moduleView).getLog();
        ((Text)this.findPaneOfTypeByID("name", Text.class)).setText(Component.m_237113_((String)Objects.requireNonNullElse(expeditionLog.getName(), "")));
        ((Text)this.findPaneOfTypeByID("status", Text.class)).setText(Component.m_237115_((String)("com.minecolonies.gui.workerhuts.expedition." + expeditionLog.getStatus().name().toLowerCase(Locale.US))));
        Gradient bg = (Gradient)this.findPaneOfTypeByID("resourcesbg", Gradient.class);
        if (expeditionLog.getStatus().equals((Object)ExpeditionLog.Status.KILLED)) {
            ((Image)this.findPaneOfTypeByID("rip", Image.class)).setVisible(true);
            bg.setGradientStart(221, 102, 102, 255);
            bg.setGradientEnd(170, 85, 85, 255);
        } else {
            ((Image)this.findPaneOfTypeByID("rip", Image.class)).setVisible(false);
            bg.setGradientStart(211, 211, 211, 255);
            bg.setGradientEnd(169, 169, 169, 255);
        }
        this.clearChildren((View)this.findPaneOfTypeByID("healthBar", View.class), 1);
        this.clearChildren((View)this.findPaneOfTypeByID("saturationBar", View.class), 0);
        CitizenWindowUtils.createHealthBar((int)expeditionLog.getStat(ExpeditionLog.StatType.HEALTH), (View)this.findPaneOfTypeByID("healthBar", View.class));
        CitizenWindowUtils.createSaturationBar(expeditionLog.getStat(ExpeditionLog.StatType.SATURATION), (View)this);
        List<ItemStack> equipment = expeditionLog.getEquipment();
        this.createEquipmentList((View)this.findPaneOfTypeByID("equipment", View.class), equipment);
        List<Tuple<EntityType<?>, Integer>> mobs = expeditionLog.getMobs();
        this.createMobList((View)this.findPaneOfTypeByID("mobs", View.class), mobs);
        List<ItemStorage> loot = expeditionLog.getLoot();
        this.createLootList((View)this.findPaneOfTypeByID("resources", View.class), loot);
    }

    private void clearChildren(@NotNull View parent, int size) {
        while (parent.getChildren().size() > size) {
            parent.removeChild((Pane)parent.getChildren().get(size));
        }
    }

    private void createEquipmentList(@NotNull View equipmentView, @NotNull List<ItemStack> equipment) {
        int ITEM_SIZE = 16;
        int ITEM_GRID = 18;
        int size = equipment.size();
        int margin = (equipmentView.getWidth() - 18 * size) / 2;
        for (int i = 0; i < size; ++i) {
            ItemIcon child;
            if (i < equipmentView.getChildren().size()) {
                child = (ItemIcon)equipmentView.getChildren().get(i);
            } else {
                child = new ItemIcon();
                equipmentView.addChild((Pane)child);
            }
            child.setItem(equipment.get(i));
            child.setSize(16, 16);
            child.setPosition(18 * i + margin, 0);
        }
        this.clearChildren(equipmentView, size);
    }

    private void createMobList(View mobsView, List<Tuple<EntityType<?>, Integer>> mobs) {
        int MOB_SIZE = 24;
        int size = mobs.size();
        int marginLeft = (mobsView.getWidth() - 24 * size) / 2;
        int marginTop = (mobsView.getHeight() - 24) / 2;
        for (int i = 0; i < size; ++i) {
            EntityIcon child;
            if (i < mobsView.getChildren().size()) {
                child = (EntityIcon)mobsView.getChildren().get(i);
            } else {
                child = new EntityIcon();
                mobsView.addChild((Pane)child);
            }
            child.setEntity(mobs.get(i).getA());
            child.setCount(mobs.get(i).getB().intValue());
            child.setSize(24, 24);
            child.setPosition(24 * i + marginLeft, marginTop);
        }
        this.clearChildren(mobsView, size);
    }

    private void createLootList(@NotNull View lootView, @NotNull List<ItemStorage> loot) {
        int LOOT_SIZE = 16;
        int LOOT_GRID = 18;
        int gridWidth = lootView.getInteriorWidth() / 18;
        int size = loot.size();
        int rows = Math.max(1, (size + gridWidth - 1) / gridWidth);
        int columns = Math.max(1, (size + rows - 1) / rows);
        int marginLeft = (lootView.getInteriorWidth() - columns * 18) / 2;
        int marginTop = (lootView.getInteriorHeight() - rows * 18) / 2;
        int row = 0;
        int column = 0;
        int i = 0;
        while (i < size) {
            ItemIcon child;
            if (column >= columns) {
                ++row;
                column = 0;
            }
            if (i < lootView.getChildren().size()) {
                child = (ItemIcon)lootView.getChildren().get(i);
            } else {
                child = new ItemIcon();
                lootView.addChild((Pane)child);
            }
            ItemStack stack = loot.get(i).getItemStack().m_41777_();
            stack.m_41764_(loot.get(i).getAmount());
            child.setItem(stack);
            child.setSize(16, 16);
            child.setPosition(18 * column + marginLeft + 1, 18 * row + marginTop + 1);
            ++i;
            ++column;
        }
        this.clearChildren(lootView, size);
    }
}

