/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.integration.emi;

import appeng.api.integrations.emi.EmiStackConverter;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.mojang.logging.LogUtils;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.jemi.JemiStack;
import dev.emi.emi.jemi.JemiUtil;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class ChemicalIngredientConverter
implements EmiStackConverter {
    private static final Logger LOGGER = LogUtils.getLogger();

    public Class<?> getKeyType() {
        return Chemical.class;
    }

    @Nullable
    public EmiStack toEmiStack(GenericStack stack) {
        try {
            AEKey aEKey = stack.what();
            if (aEKey instanceof MekanismKey) {
                MekanismKey key = (MekanismKey)aEKey;
                return JemiUtil.getStack(key.withAmount(Math.max(1L, stack.amount())));
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to convert GenericStack to EmiStack", (Throwable)e);
        }
        return null;
    }

    @Nullable
    public GenericStack toGenericStack(EmiStack stack) {
        try {
            if (stack instanceof JemiStack) {
                ChemicalStack chemicalStack;
                MekanismKey mekKey;
                JemiStack jemiStack = (JemiStack)stack;
                Object ing = jemiStack.ingredient;
                if (ing instanceof ChemicalStack && (mekKey = MekanismKey.of(chemicalStack = (ChemicalStack)ing)) != null) {
                    return new GenericStack((AEKey)mekKey, stack.getAmount());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to convert EmiStack to GenericStack", (Throwable)e);
        }
        return null;
    }
}

