/*
 * Decompiled with CFR 0.152.
 */
package net.night.auto_pickup_filter.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.night.auto_pickup_filter.PickupFilterManager;
import net.night.auto_pickup_filter.network.SyncBlacklistPacket;
import net.night.auto_pickup_filter.network.SyncOverridePacket;

public class NetworkHandler {
    public static void init() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)SyncBlacklistPacket.ID, (buf, context) -> {
            SyncBlacklistPacket packet = SyncBlacklistPacket.read(buf);
            context.queue(() -> {
                Player patt0$temp = context.getPlayer();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                    PickupFilterManager.setServerBlacklist(serverPlayer.m_20148_(), packet.blacklistedItems());
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)SyncOverridePacket.ID, (buf, context) -> {
            SyncOverridePacket packet = SyncOverridePacket.read(buf);
            context.queue(() -> {
                Player patt0$temp = context.getPlayer();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                    PickupFilterManager.setServerOverride(serverPlayer.m_20148_(), packet.override());
                }
            });
        });
    }

    public static void sendBlacklistToServer() {
        try {
            SyncBlacklistPacket packet = new SyncBlacklistPacket(PickupFilterManager.getBlacklistedItems());
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            SyncBlacklistPacket.write(buf, packet);
            NetworkManager.sendToServer((ResourceLocation)SyncBlacklistPacket.ID, (FriendlyByteBuf)buf);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendOverrideToServer(boolean override) {
        try {
            SyncOverridePacket packet = new SyncOverridePacket(override);
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            SyncOverridePacket.write(buf, packet);
            NetworkManager.sendToServer((ResourceLocation)SyncOverridePacket.ID, (FriendlyByteBuf)buf);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

