/*
 * Decompiled with CFR 0.152.
 */
package net.night.auto_pickup_filter.client;

import dev.architectury.event.events.client.ClientTickEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import net.night.auto_pickup_filter.PickupFilterManager;
import org.lwjgl.glfw.GLFW;

public class JeiInputHandler {
    private static Object jeiRuntime;
    private static boolean wasIPressed;
    private static boolean hasTriedReflection;
    private static boolean jeiAvailable;

    public static void setJeiRuntime(Object runtime) {
        if (jeiAvailable) {
            jeiRuntime = runtime;
        }
    }

    public static void init() {
        if (!jeiAvailable) {
            return;
        }
        ClientTickEvent.CLIENT_POST.register(minecraft -> {
            if (minecraft.f_91074_ == null) {
                return;
            }
            JeiInputHandler.tryInitializeJeiRuntime();
            if (jeiRuntime == null) {
                return;
            }
            JeiInputHandler.handleJeiItemClick(minecraft);
        });
    }

    private static void tryInitializeJeiRuntime() {
        if (jeiRuntime != null) {
            return;
        }
        if (hasTriedReflection) {
            return;
        }
        hasTriedReflection = true;
        try {
            try {
                Object runtime;
                Field instanceField2;
                Class<?> internalClass = Class.forName("mezz.jei.library.runtime.JeiRuntime");
                try {
                    instanceField2 = internalClass.getDeclaredField("INSTANCE");
                    instanceField2.setAccessible(true);
                    runtime = instanceField2.get(null);
                    if (runtime != null) {
                        jeiRuntime = runtime;
                        return;
                    }
                }
                catch (NoSuchFieldException instanceField2) {
                    // empty catch block
                }
                try {
                    instanceField2 = internalClass.getDeclaredField("instance");
                    instanceField2.setAccessible(true);
                    runtime = instanceField2.get(null);
                    if (runtime != null) {
                        jeiRuntime = runtime;
                        return;
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void handleJeiItemClick(Minecraft minecraft) {
        boolean isIPressed;
        long windowHandle = minecraft.m_91268_().m_85439_();
        int iKeyState = GLFW.glfwGetKey((long)windowHandle, (int)73);
        boolean bl = isIPressed = iKeyState == 1;
        if (isIPressed && !wasIPressed) {
            JeiInputHandler.tryToggleItemFromJei();
        }
        wasIPressed = isIPressed;
    }

    private static void tryToggleItemFromJei() {
        try {
            ItemStack stack;
            if (jeiRuntime == null) {
                return;
            }
            Class<?> runtimeClass = Class.forName("mezz.jei.api.runtime.IJeiRuntime");
            Method getOverlayMethod = runtimeClass.getMethod("getIngredientListOverlay", new Class[0]);
            Object overlay = getOverlayMethod.invoke(jeiRuntime, new Object[0]);
            if (overlay == null) {
                return;
            }
            Class<?> overlayClass = Class.forName("mezz.jei.api.runtime.IIngredientListOverlay");
            Method isDisplayedMethod = overlayClass.getMethod("isListDisplayed", new Class[0]);
            Boolean isDisplayed = (Boolean)isDisplayedMethod.invoke(overlay, new Object[0]);
            if (isDisplayed == null || !isDisplayed.booleanValue()) {
                return;
            }
            Class<?> vanillaTypesClass = Class.forName("mezz.jei.api.constants.VanillaTypes");
            Field itemStackField = vanillaTypesClass.getField("ITEM_STACK");
            Object itemStackType = itemStackField.get(null);
            Method getIngredientMethod = overlayClass.getMethod("getIngredientUnderMouse", Class.forName("mezz.jei.api.ingredients.IIngredientType"));
            Object hoveredItem = getIngredientMethod.invoke(overlay, itemStackType);
            if (hoveredItem instanceof ItemStack && !(stack = (ItemStack)hoveredItem).m_41619_()) {
                PickupFilterManager.toggleBlacklist(stack.m_41720_());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        wasIPressed = false;
        hasTriedReflection = false;
        jeiAvailable = false;
        try {
            Class.forName("mezz.jei.api.runtime.IJeiRuntime");
            jeiAvailable = true;
        }
        catch (ClassNotFoundException e) {
            jeiAvailable = false;
        }
    }
}

