/*
 * Decompiled with CFR 0.152.
 */
package net.night.auto_pickup_filter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.night.auto_pickup_filter.network.NetworkHandler;

public class PickupFilterManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Set<String> blacklistedItems = new HashSet<String>();
    private static final ConcurrentHashMap<UUID, Set<String>> serverBlacklists = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Boolean> serverOverrides = new ConcurrentHashMap();
    private static Path configPath;
    private static volatile boolean temporaryOverride;

    public static void setTemporaryOverride(boolean override) {
        temporaryOverride = override;
        try {
            NetworkHandler.sendOverrideToServer(override);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isTemporaryOverrideActive() {
        return temporaryOverride;
    }

    private static boolean shouldBypassBlacklist() {
        return temporaryOverride;
    }

    public static void init(Path configDir) {
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
            configPath = configDir.resolve("auto_pickup_filter.json");
            PickupFilterManager.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void reload() {
        PickupFilterManager.load();
    }

    public static boolean isBlacklisted(ItemStack stack) {
        if (PickupFilterManager.shouldBypassBlacklist()) {
            return false;
        }
        if (stack.m_41619_()) {
            return false;
        }
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        return blacklistedItems.contains(itemId.toString());
    }

    public static boolean isBlacklisted(Item item) {
        if (PickupFilterManager.shouldBypassBlacklist()) {
            return false;
        }
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        return blacklistedItems.contains(itemId.toString());
    }

    public static void addToBlacklist(Item item) {
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        if (blacklistedItems.add(itemId.toString())) {
            PickupFilterManager.save();
            PickupFilterManager.syncToServer();
        }
    }

    public static void removeFromBlacklist(Item item) {
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        if (blacklistedItems.remove(itemId.toString())) {
            PickupFilterManager.save();
            PickupFilterManager.syncToServer();
        }
    }

    private static void syncToServer() {
        try {
            NetworkHandler.sendBlacklistToServer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void toggleBlacklist(Item item) {
        if (PickupFilterManager.isBlacklisted(item)) {
            PickupFilterManager.removeFromBlacklist(item);
        } else {
            PickupFilterManager.addToBlacklist(item);
        }
    }

    public static Set<String> getBlacklistedItems() {
        return new HashSet<String>(blacklistedItems);
    }

    private static void load() {
        if (configPath == null || !Files.exists(configPath, new LinkOption[0])) {
            return;
        }
        try (FileReader reader = new FileReader(configPath.toFile());){
            Type setType = new TypeToken<Set<String>>(){}.getType();
            Set loaded = (Set)GSON.fromJson((Reader)reader, setType);
            if (loaded != null) {
                blacklistedItems.clear();
                blacklistedItems.addAll(loaded);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void save() {
        if (configPath == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(configPath.toFile());){
            GSON.toJson(blacklistedItems, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setServerBlacklist(UUID playerUUID, Set<String> items) {
        serverBlacklists.put(playerUUID, new HashSet<String>(items));
    }

    public static void setServerOverride(UUID playerUUID, boolean override) {
        if (override) {
            serverOverrides.put(playerUUID, true);
        } else {
            serverOverrides.remove(playerUUID);
        }
    }

    public static boolean isBlacklistedForPlayer(Player player, ItemStack stack) {
        if (player.m_9236_().f_46443_) {
            return PickupFilterManager.isBlacklisted(stack);
        }
        Boolean playerOverride = serverOverrides.get(player.m_20148_());
        if (playerOverride != null && playerOverride.booleanValue()) {
            return false;
        }
        Set<String> playerBlacklist = serverBlacklists.get(player.m_20148_());
        if (playerBlacklist == null) {
            return false;
        }
        if (stack.m_41619_()) {
            return false;
        }
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        return playerBlacklist.contains(itemId.toString());
    }

    static {
        temporaryOverride = false;
    }
}

