/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.new_slab_variants.core.common.entity;

import common.com.cursee.new_slab_variants.platform.Services;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.jetbrains.annotations.Nullable;

public class PrimedTNTSlab
extends Entity
implements TraceableEntity {
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.defineId(PrimedTNTSlab.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> SLAB_TYPE_ID = SynchedEntityData.defineId(PrimedTNTSlab.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final int DEFAULT_FUSE_TIME = 80;
    @Nullable
    private LivingEntity owner;

    public PrimedTNTSlab(EntityType<? extends PrimedTNTSlab> $$0, Level $$1) {
        super($$0, $$1);
        this.blocksBuilding = true;
    }

    public <T extends Comparable<T>> PrimedTNTSlab(Level $$0, double $$1, double $$2, double $$3, @Nullable LivingEntity $$4, T value) {
        this(Services.PLATFORM.getPrimedTNTSlabEntityType(), $$0);
        this.setSlabType(((SlabType)value).toString());
        this.setPos($$1, $$2, $$3);
        double $$5 = $$0.random.nextDouble() * 6.2831854820251465;
        this.setDeltaMovement(-Math.sin($$5) * 0.02, 0.2f, -Math.cos($$5) * 0.02);
        this.setFuse(80);
        this.xo = $$1;
        this.yo = $$2;
        this.zo = $$3;
        this.owner = $$4;
    }

    protected void defineSynchedData() {
        this.entityData.define(DATA_FUSE_ID, (Object)80);
        this.entityData.define(SLAB_TYPE_ID, (Object)"bottom");
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public void tick() {
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
        }
        int $$0 = this.getFuse() - 1;
        this.setFuse($$0);
        if ($$0 <= 0) {
            this.discard();
            if (!this.level().isClientSide) {
                this.explode();
            }
        } else {
            this.updateInWaterStateAndDoFluidPushing();
            if (this.level().isClientSide) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void explode() {
        float $$0 = 4.0f;
        this.level().explode((Entity)this, this.getX(), this.getY(0.0625), this.getZ(), 4.0f, Level.ExplosionInteraction.TNT);
    }

    protected void addAdditionalSaveData(CompoundTag $$0) {
        $$0.putShort("Fuse", (short)this.getFuse());
        $$0.putString("SlabType", this.getSlabType());
    }

    protected void readAdditionalSaveData(CompoundTag $$0) {
        this.setFuse($$0.getShort("Fuse"));
        this.setSlabType($$0.getString("SlabType"));
    }

    @javax.annotation.Nullable
    public LivingEntity getOwner() {
        return this.owner;
    }

    protected float getEyeHeight(Pose $$0, EntityDimensions $$1) {
        return 0.15f;
    }

    public void setFuse(int $$0) {
        this.entityData.set(DATA_FUSE_ID, (Object)$$0);
    }

    public void setSlabType(String $$0) {
        this.entityData.set(SLAB_TYPE_ID, (Object)$$0);
    }

    public int getFuse() {
        return (Integer)this.entityData.get(DATA_FUSE_ID);
    }

    public String getSlabType() {
        return (String)this.entityData.get(SLAB_TYPE_ID);
    }
}

