/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.new_slab_variants.core.common.block;

import common.com.cursee.new_slab_variants.core.common.entity.PrimedTNTSlab;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TNTSlabBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty UNSTABLE = BlockStateProperties.UNSTABLE;
    public static final EnumProperty<SlabType> TYPE = BlockStateProperties.SLAB_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape BOTTOM_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_AABB = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public TNTSlabBlock(BlockBehaviour.Properties $$0) {
        super($$0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UNSTABLE, (Comparable)Boolean.valueOf(false))).setValue(TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean useShapeForLightOcclusion(BlockState $$0) {
        return $$0.getValue(TYPE) != SlabType.DOUBLE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> $$0) {
        $$0.add(new Property[]{UNSTABLE, TYPE, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState $$0, BlockGetter $$1, BlockPos $$2, CollisionContext $$3) {
        SlabType $$4 = (SlabType)$$0.getValue(TYPE);
        switch ($$4) {
            case DOUBLE: {
                return Shapes.block();
            }
            case TOP: {
                return TOP_AABB;
            }
        }
        return BOTTOM_AABB;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext $$0) {
        BlockPos $$1 = $$0.getClickedPos();
        BlockState $$2 = $$0.getLevel().getBlockState($$1);
        if ($$2.is((Block)this)) {
            return (BlockState)((BlockState)$$2.setValue(TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState $$3 = $$0.getLevel().getFluidState($$1);
        BlockState $$4 = (BlockState)((BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf($$3.getType() == Fluids.WATER));
        Direction $$5 = $$0.getClickedFace();
        return !($$5 == Direction.DOWN || $$5 != Direction.UP && $$0.getClickLocation().y - (double)$$1.getY() > 0.5) ? $$4 : (BlockState)$$4.setValue(TYPE, (Comparable)SlabType.TOP);
    }

    public boolean canBeReplaced(BlockState $$0, BlockPlaceContext $$1) {
        ItemStack $$2 = $$1.getItemInHand();
        SlabType $$3 = (SlabType)$$0.getValue(TYPE);
        if ($$3 != SlabType.DOUBLE && $$2.is(this.asItem())) {
            if ($$1.replacingClickedOnBlock()) {
                boolean $$4 = $$1.getClickLocation().y - (double)$$1.getClickedPos().getY() > 0.5;
                Direction $$5 = $$1.getClickedFace();
                if ($$3 == SlabType.BOTTOM) {
                    return $$5 == Direction.UP || $$4 && $$5.getAxis().isHorizontal();
                }
                return $$5 == Direction.DOWN || !$$4 && $$5.getAxis().isHorizontal();
            }
            return true;
        }
        return false;
    }

    public FluidState getFluidState(BlockState $$0) {
        return (Boolean)$$0.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState($$0);
    }

    public boolean placeLiquid(LevelAccessor $$0, BlockPos $$1, BlockState $$2, FluidState $$3) {
        return $$2.getValue(TYPE) != SlabType.DOUBLE ? super.placeLiquid($$0, $$1, $$2, $$3) : false;
    }

    public boolean canPlaceLiquid(BlockGetter $$0, BlockPos $$1, BlockState $$2, Fluid $$3) {
        return $$2.getValue(TYPE) != SlabType.DOUBLE ? super.canPlaceLiquid($$0, $$1, $$2, $$3) : false;
    }

    public BlockState updateShape(BlockState $$0, Direction $$1, BlockState $$2, LevelAccessor $$3, BlockPos $$4, BlockPos $$5) {
        if (((Boolean)$$0.getValue((Property)WATERLOGGED)).booleanValue()) {
            $$3.scheduleTick($$4, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)$$3));
        }
        return super.updateShape($$0, $$1, $$2, $$3, $$4, $$5);
    }

    public boolean isPathfindable(BlockState $$0, BlockGetter $$1, BlockPos $$2, PathComputationType $$3) {
        switch ($$3) {
            case LAND: {
                return false;
            }
            case WATER: {
                return $$1.getFluidState($$2).is(FluidTags.WATER);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public void onPlace(BlockState $$0, Level $$1, BlockPos $$2, BlockState $$3, boolean $$4) {
        if (!$$3.is($$0.getBlock()) && $$1.hasNeighborSignal($$2)) {
            TNTSlabBlock.explode($$1, $$2);
            $$1.removeBlock($$2, false);
        }
    }

    public void neighborChanged(BlockState $$0, Level $$1, BlockPos $$2, Block $$3, BlockPos $$4, boolean $$5) {
        if ($$1.hasNeighborSignal($$2)) {
            TNTSlabBlock.explode($$1, $$2);
            $$1.removeBlock($$2, false);
        }
    }

    public void playerWillDestroy(Level $$0, BlockPos $$1, BlockState $$2, Player $$3) {
        if (!$$0.isClientSide() && !$$3.isCreative() && ((Boolean)$$2.getValue((Property)UNSTABLE)).booleanValue()) {
            TNTSlabBlock.explode($$0, $$1);
        }
        super.playerWillDestroy($$0, $$1, $$2, $$3);
    }

    public static void explode(Level $$0, BlockPos $$1) {
        TNTSlabBlock.explode($$0, $$1, null);
    }

    private static void explode(Level $$0, BlockPos $$1, @Nullable LivingEntity $$2) {
        if (!$$0.isClientSide) {
            PrimedTNTSlab $$3 = new PrimedTNTSlab($$0, (double)$$1.getX() + 0.5, $$1.getY(), (double)$$1.getZ() + 0.5, $$2, (SlabType)$$0.getBlockState($$1).getValue((Property)BlockStateProperties.SLAB_TYPE));
            $$0.addFreshEntity((Entity)$$3);
            $$0.playSound((Player)null, $$3.getX(), $$3.getY(), $$3.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
            $$0.gameEvent((Entity)$$2, GameEvent.PRIME_FUSE, $$1);
        }
    }

    public void wasExploded(Level $$0, BlockPos $$1, Explosion $$2) {
        if (!$$0.isClientSide) {
            if ($$0.getBlockState($$1).getBlock() instanceof TNTSlabBlock) {
                PrimedTNTSlab $$3 = new PrimedTNTSlab($$0, $$1.getX(), $$1.getY(), $$1.getZ(), $$2.getIndirectSourceEntity(), (SlabType)$$0.getBlockState($$1).getValue((Property)BlockStateProperties.SLAB_TYPE));
                int $$4 = $$3.getFuse();
                $$3.setFuse((short)($$0.random.nextInt($$4 / 4) + $$4 / 8));
                $$0.addFreshEntity((Entity)$$3);
                return;
            }
            PrimedTNTSlab $$3 = new PrimedTNTSlab($$0, $$1.getX(), $$1.getY(), $$1.getZ(), $$2.getIndirectSourceEntity(), SlabType.BOTTOM);
            int $$4 = $$3.getFuse();
            $$3.setFuse((short)($$0.random.nextInt($$4 / 4) + $$4 / 8));
            $$0.addFreshEntity((Entity)$$3);
        }
    }

    public InteractionResult use(BlockState $$0, Level $$1, BlockPos $$2, Player $$3, InteractionHand $$4, BlockHitResult $$5) {
        ItemStack $$6 = $$3.getItemInHand($$4);
        if (!$$6.is(Items.FLINT_AND_STEEL) && !$$6.is(Items.FIRE_CHARGE)) {
            return super.use($$0, $$1, $$2, $$3, $$4, $$5);
        }
        TNTSlabBlock.explode($$1, $$2, (LivingEntity)$$3);
        $$1.setBlock($$2, Blocks.AIR.defaultBlockState(), 11);
        Item $$7 = $$6.getItem();
        if (!$$3.isCreative()) {
            if ($$6.is(Items.FLINT_AND_STEEL)) {
                $$6.hurtAndBreak(1, (LivingEntity)$$3, $$1x -> $$1x.broadcastBreakEvent($$4));
            } else {
                $$6.shrink(1);
            }
        }
        $$3.awardStat(Stats.ITEM_USED.get((Object)$$7));
        return InteractionResult.sidedSuccess((boolean)$$1.isClientSide);
    }

    public void onProjectileHit(Level $$0, BlockState $$1, BlockHitResult $$2, Projectile $$3) {
        if (!$$0.isClientSide) {
            BlockPos $$4 = $$2.getBlockPos();
            Entity $$5 = $$3.getOwner();
            if ($$3.isOnFire() && $$3.mayInteract($$0, $$4)) {
                TNTSlabBlock.explode($$0, $$4, $$5 instanceof LivingEntity ? (LivingEntity)$$5 : null);
                $$0.removeBlock($$4, false);
            }
        }
    }

    public boolean dropFromExplosion(Explosion $$0) {
        return false;
    }
}

