/*
 * Decompiled with CFR 0.152.
 */
package net.night.multi_arrow_effects.recipe;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.night.multi_arrow_effects.config.MultiArrowConfig;
import net.night.multi_arrow_effects.recipe.ModRecipes;

public class ArrowCombiningRecipe
extends CustomRecipe {
    public ArrowCombiningRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ArrayList<ItemStack> tippedArrows = new ArrayList<ItemStack>();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(Items.f_42738_)) {
                tippedArrows.add(stack);
                continue;
            }
            return false;
        }
        if (tippedArrows.size() < 2) {
            return false;
        }
        MultiArrowConfig config = MultiArrowConfig.getInstance();
        ArrayList<String> effectIds = new ArrayList<String>();
        for (ItemStack arrow : tippedArrows) {
            List effects = PotionUtils.m_43547_((ItemStack)arrow);
            for (MobEffectInstance effect : effects) {
                ResourceLocation effectId = BuiltInRegistries.f_256974_.m_7981_((Object)effect.m_19544_());
                String effectIdString = effectId != null ? effectId.toString() : "";
                if (effectIds.contains(effectIdString)) continue;
                effectIds.add(effectIdString);
            }
        }
        return config.canCombineEffects(effectIds);
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ArrayList<ItemStack> tippedArrows = new ArrayList<ItemStack>();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || !stack.m_150930_(Items.f_42738_)) continue;
            tippedArrows.add(stack);
        }
        if (tippedArrows.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = new ItemStack((ItemLike)Items.f_42738_);
        ArrayList allEffects = new ArrayList();
        for (ItemStack arrow : tippedArrows) {
            List effects = PotionUtils.m_43547_((ItemStack)arrow);
            allEffects.addAll(effects);
        }
        MultiArrowConfig config = MultiArrowConfig.getInstance();
        int maxEffects = config.getMaxEffects();
        ArrayList<MobEffectInstance> uniqueEffects = new ArrayList<MobEffectInstance>();
        ArrayList<String> seenEffectIds = new ArrayList<String>();
        for (int i = allEffects.size() - 1; i >= 0; --i) {
            String effectIdString;
            MobEffectInstance effect = (MobEffectInstance)allEffects.get(i);
            ResourceLocation effectId = BuiltInRegistries.f_256974_.m_7981_((Object)effect.m_19544_());
            String string = effectIdString = effectId != null ? effectId.toString() : "";
            if (seenEffectIds.contains(effectIdString)) continue;
            uniqueEffects.add(0, effect);
            seenEffectIds.add(effectIdString);
        }
        List<Object> finalEffects = uniqueEffects.size() > maxEffects ? uniqueEffects.subList(uniqueEffects.size() - maxEffects, uniqueEffects.size()) : uniqueEffects;
        PotionUtils.m_43552_((ItemStack)result, finalEffects);
        result.m_41714_((Component)Component.m_237115_((String)"item.multi_arrow_effects.mixed_arrow"));
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.ARROW_COMBINING_SERIALIZER.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        return NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
    }
}

