/*
 * Decompiled with CFR 0.152.
 */
package net.night.multi_arrow_effects.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import dev.architectury.platform.Platform;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class MultiArrowConfig {
    private static final String CONFIG_FILE = "multi-arrow-effects-common.toml";
    private static MultiArrowConfig INSTANCE;
    private int maxEffects = 3;
    private final List<String> effectsBlacklist = new ArrayList<String>();
    private final List<String> blacklistGrouping = new ArrayList<String>();

    private MultiArrowConfig() {
        this.load();
    }

    public static MultiArrowConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MultiArrowConfig();
        }
        return INSTANCE;
    }

    private void load() {
        Path configPath = Platform.getConfigFolder().resolve(CONFIG_FILE);
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).sync().autosave().writingMode(WritingMode.REPLACE).build();
        config.load();
        if (!config.contains("arrow_combining.max_effects")) {
            config.set("arrow_combining.max_effects", (Object)3);
            config.setComment("arrow_combining.max_effects", " Maximum number of unique effects allowed per combined arrow\n Default: 3");
        }
        if (!config.contains("arrow_combining.effects_blacklist")) {
            config.set("arrow_combining.effects_blacklist", new ArrayList());
            config.setComment("arrow_combining.effects_blacklist", " List of effects that cannot be combined at all\n Example: [\"minecraft:poison\", \"minecraft:instant_damage\"]");
        }
        if (!config.contains("arrow_combining.blacklist_grouping")) {
            config.set("arrow_combining.blacklist_grouping", new ArrayList());
            config.setComment("arrow_combining.blacklist_grouping", " List of effect pairs that cannot be combined together\n Format: \"effect1,effect2\" for each pair\n Example: [\"minecraft:slowness,minecraft:speed\", \"minecraft:weakness,minecraft:strength\"]");
        }
        config.save();
        this.maxEffects = config.getIntOrElse("arrow_combining.max_effects", 3);
        this.effectsBlacklist.clear();
        List blacklistConfig = (List)config.get("arrow_combining.effects_blacklist");
        if (blacklistConfig != null) {
            this.effectsBlacklist.addAll(blacklistConfig);
        }
        this.blacklistGrouping.clear();
        List groupingConfig = (List)config.get("arrow_combining.blacklist_grouping");
        if (groupingConfig != null) {
            this.blacklistGrouping.addAll(groupingConfig);
        }
        System.out.println("[MultiArrowEffects] Config loaded: maxEffects=" + this.maxEffects + ", blacklisted=" + this.effectsBlacklist.size() + ", groupings=" + this.blacklistGrouping.size());
    }

    public int getMaxEffects() {
        return this.maxEffects;
    }

    public boolean isEffectBlacklisted(String effectId) {
        return this.effectsBlacklist.contains(effectId);
    }

    public boolean canCombineEffects(String effect1, String effect2) {
        for (String grouping : this.blacklistGrouping) {
            String[] effects = grouping.split(",");
            if (effects.length < 2) continue;
            String e1 = effects[0].trim();
            String e2 = effects[1].trim();
            if ((!effect1.equals(e1) || !effect2.equals(e2)) && (!effect1.equals(e2) || !effect2.equals(e1))) continue;
            return false;
        }
        return true;
    }

    public boolean canCombineEffects(List<String> effectIds) {
        for (String effectId : effectIds) {
            if (!this.isEffectBlacklisted(effectId)) continue;
            return false;
        }
        for (int i = 0; i < effectIds.size(); ++i) {
            for (int j = i + 1; j < effectIds.size(); ++j) {
                if (this.canCombineEffects(effectIds.get(i), effectIds.get(j))) continue;
                return false;
            }
        }
        return true;
    }
}

