/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;

public class GsonHelper2 {
    @NotNull
    public static <T> Optional<T> of(@NotNull JsonObject json, @NotNull String memberName, @NotNull BiFunction<JsonObject, String, T> function) {
        return json.has(memberName) ? Optional.of(function.apply(json, memberName)) : Optional.empty();
    }

    @NotNull
    public static <T> void ifPresent(@NotNull String memberName, @NotNull Optional<T> value, @NotNull BiConsumer<String, T> consumer) {
        value.ifPresent(v -> consumer.accept(memberName, v));
    }

    public static ResourceLocation convertToResourceLocation(@NotNull JsonElement json, @NotNull String memberName, @NotNull String fallbackNamespace) {
        if (json.isJsonPrimitive()) {
            String raw = json.getAsString();
            if (raw.contains(":")) {
                return new ResourceLocation(raw);
            }
            return new ResourceLocation(fallbackNamespace, raw);
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a ResourceLocation, was " + GsonHelper.m_13883_((JsonElement)json));
    }

    public static ResourceLocation getAsResourceLocation(@NotNull JsonObject json, @NotNull String memberName) {
        return GsonHelper2.getAsResourceLocation(json, memberName, "minecraft");
    }

    public static ResourceLocation getAsResourceLocation(@NotNull JsonObject json, @NotNull String memberName, @NotNull String fallbackNamespace) {
        if (json.has(memberName)) {
            return GsonHelper2.convertToResourceLocation(json.get(memberName), memberName, fallbackNamespace);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a ResourceLocation");
    }

    private GsonHelper2() {
    }
}

