/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_tweaks.core.common.item;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_tweaks.api.common.building.BuildingPos;
import steve_gall.minecolonies_tweaks.core.common.building.BuildingUtils;

public abstract class ItemBuildingLinkScroll
extends Item {
    public static final Component TOOLIP_HOW_TO_LINK = Component.m_237115_((String)"item.minecolonies_tweaks.buildingscroll.how_to_link");
    public static final Component MESSAGE_MISSING_POS = Component.m_237115_((String)"item.minecolonies_tweaks.buildingscroll.missing_pos");
    public static final Component MESSAGE_MISSING_BUILDING = Component.m_237115_((String)"item.minecolonies_tweaks.buildingscroll.missing_building");
    public static final Component TEXT_BUILDING_MISSING = Component.m_237115_((String)"item.minecolonies_tweaks.buildingscroll.building_missing").m_130940_(ChatFormatting.GRAY);
    public static final Component TEXT_LINKED = Component.m_237115_((String)"item.minecolonies_tweaks.buildingscroll.linked");
    public static final String TAG_POS = "pos";

    public ItemBuildingLinkScroll(Item.Properties properites) {
        super(properites.m_41487_(1));
    }

    @Nullable
    public static void setPos(@NotNull ItemStack stack, @Nullable BuildingPos pos) {
        CompoundTag tag = stack.m_41784_();
        if (pos != null) {
            tag.m_128365_(TAG_POS, (Tag)pos.serializeNBT());
        } else {
            tag.m_128473_(TAG_POS);
        }
    }

    @Nullable
    public static BuildingPos getPos(@NotNull ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        return new BuildingPos(tag.m_128469_(TAG_POS));
    }

    protected abstract void openWindow(@NotNull ItemStack var1, @Nullable Player var2, @Nullable IBuildingView var3);

    public abstract boolean testForLink(@NotNull IBuilding var1);

    public void openWindow(@NotNull ItemStack stack, @Nullable Player player) {
        BuildingPos pos = ItemBuildingLinkScroll.getPos(stack);
        if (pos == null) {
            if (player != null) {
                player.m_213846_(MESSAGE_MISSING_POS);
            }
            return;
        }
        IBuildingView buildingView = pos.getBuildingView();
        if (buildingView == null) {
            if (player != null) {
                player.m_213846_(MESSAGE_MISSING_BUILDING);
            }
            return;
        }
        this.openWindow(stack, player, buildingView);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        AbstractTileEntityColonyBuilding buildingEntity;
        IBuilding building;
        Level level = context.m_43725_();
        ItemStack stack = context.m_43722_();
        BlockEntity blockEntity = level.m_7702_(context.m_8083_());
        if (level.m_5776_()) {
            if (!(blockEntity instanceof AbstractTileEntityColonyBuilding)) {
                this.openWindow(stack, context.m_43723_());
            }
        } else if (blockEntity instanceof AbstractTileEntityColonyBuilding && (building = (buildingEntity = (AbstractTileEntityColonyBuilding)blockEntity).getBuilding()) != null && this.testForLink(building)) {
            ItemBuildingLinkScroll.setPos(stack, new BuildingPos(building));
            context.m_43723_().m_213846_(TEXT_LINKED);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.m_5776_()) {
            this.openWindow(stack, player);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add(TOOLIP_HOW_TO_LINK);
        if (level == null) {
            return;
        }
        BuildingPos pos = ItemBuildingLinkScroll.getPos(stack);
        if (pos == null) {
            return;
        }
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237110_((String)"item.minecolonies_tweaks.buildingscroll.linked_pos", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}));
        IBuildingView buildingView = pos.getBuildingView();
        Object buildingName = null;
        buildingName = buildingView == null ? TEXT_BUILDING_MISSING : Component.m_237119_().m_7220_((Component)BuildingUtils.getDisplayName(buildingView)).m_130940_(ChatFormatting.DARK_PURPLE);
        tooltip.add((Component)Component.m_237110_((String)"item.minecolonies_tweaks.buildingscroll.linked_building", (Object[])new Object[]{buildingName}));
    }
}

