/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.overclocked_watches.client.item.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.com.cursee.overclocked_watches.client.item.model.ArmsModel;
import forge.com.cursee.overclocked_watches.client.item.renderer.IWatchRenderer;
import forge.com.cursee.overclocked_watches.platform.Services;
import java.util.function.Function;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class WatchRenderer
implements IWatchRenderer {
    private final ResourceLocation wideTexture;
    private final ResourceLocation slimTexture;
    private final ArmsModel wideModel;
    private final ArmsModel slimModel;

    public WatchRenderer(String name, Function<Boolean, ArmsModel> model) {
        this(IWatchRenderer.getTexturePath(name, "%s_wide".formatted(name)), IWatchRenderer.getTexturePath(name, "%s_slim".formatted(name)), model);
    }

    public WatchRenderer(String wideTexture, String slimTexture, Function<Boolean, ArmsModel> model) {
        this(IWatchRenderer.getTexturePath(wideTexture), IWatchRenderer.getTexturePath(slimTexture), model);
    }

    public WatchRenderer(ResourceLocation wideTexture, ResourceLocation slimTexture, Function<Boolean, ArmsModel> model) {
        this.wideTexture = wideTexture;
        this.slimTexture = slimTexture;
        this.wideModel = model.apply(false);
        this.slimModel = model.apply(true);
    }

    @Nullable
    public static WatchRenderer getGloveRenderer(ItemStack stack) {
        IWatchRenderer iWatchRenderer;
        if (!stack.m_41619_() && (iWatchRenderer = Services.PLATFORM.getWatchRenderer(stack.m_41720_())) instanceof WatchRenderer) {
            WatchRenderer gloveRenderer = (WatchRenderer)iWatchRenderer;
            return gloveRenderer;
        }
        return null;
    }

    protected ResourceLocation getTexture(boolean hasSlimArms) {
        return hasSlimArms ? this.slimTexture : this.wideTexture;
    }

    protected ArmsModel getModel(boolean hasSlimArms) {
        return hasSlimArms ? this.slimModel : this.wideModel;
    }

    protected static boolean hasSlimArms(Entity entity) {
        AbstractClientPlayer player;
        return entity instanceof AbstractClientPlayer && (player = (AbstractClientPlayer)entity).m_108564_().equals("slim");
    }

    @Override
    public void render(ItemStack stack, LivingEntity entity, int slotIndex, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean hasSlimArms = WatchRenderer.hasSlimArms((Entity)entity);
        ArmsModel model = this.getModel(hasSlimArms);
        InteractionHand hand = slotIndex % 2 == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        HumanoidArm handSide = hand == InteractionHand.MAIN_HAND ? entity.m_5737_() : entity.m_5737_().m_20828_();
        model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        IWatchRenderer.followBodyRotations(entity, model);
        this.renderArm(model, poseStack, multiBufferSource, handSide, light, hasSlimArms, stack.m_41790_());
    }

    protected void renderArm(ArmsModel model, PoseStack matrixStack, MultiBufferSource buffer, HumanoidArm handSide, int light, boolean hasSlimArms, boolean hasFoil) {
        RenderType renderType = model.m_103119_(this.getTexture(hasSlimArms));
        VertexConsumer vertexBuilder = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)false, (boolean)hasFoil);
        model.renderArm(handSide, matrixStack, vertexBuilder, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public final void renderFirstPersonArm(PoseStack matrixStack, MultiBufferSource buffer, int light, AbstractClientPlayer player, HumanoidArm side, boolean hasFoil) {
        if (!player.m_5833_()) {
            boolean hasSlimArms = WatchRenderer.hasSlimArms((Entity)player);
            ArmsModel model = this.getModel(hasSlimArms);
            ModelPart arm = side == HumanoidArm.LEFT ? model.f_102812_ : model.f_102811_;
            model.m_8009_(false);
            arm.f_104207_ = true;
            model.f_102817_ = false;
            model.f_102818_ = 0.0f;
            model.f_102608_ = 0.0f;
            model.m_6973_((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            arm.f_104203_ = 0.0f;
            this.renderFirstPersonArm(model, arm, matrixStack, buffer, light, hasSlimArms, hasFoil);
        }
    }

    protected void renderFirstPersonArm(ArmsModel model, ModelPart arm, PoseStack matrixStack, MultiBufferSource buffer, int light, boolean hasSlimArms, boolean hasFoil) {
        RenderType renderType = model.m_103119_(this.getTexture(hasSlimArms));
        VertexConsumer builder = ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)false, (boolean)hasFoil);
        arm.m_104301_(matrixStack, builder, light, OverlayTexture.f_118083_);
    }
}

