/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.overclocked_watches.client.item;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public abstract class RendererUtil {
    public static ModelPart bakeLayer(ModelLayerLocation layerLocation) {
        return Minecraft.m_91087_().m_167973_().m_171103_(layerLocation);
    }

    public static HumanoidArm getArmSide(LivingEntity entity, InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? entity.m_5737_() : entity.m_5737_().m_20828_();
    }

    public static InteractionHand getInteractionHand(LivingEntity entity, HumanoidArm armSide) {
        return armSide == entity.m_5737_() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public static MeshDefinition createEmptyArms(CubeListBuilder leftArm, CubeListBuilder rightArm, boolean hasSlimArms) {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        mesh.m_171576_().m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        mesh.m_171576_().m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        float armWidth = hasSlimArms ? 3.0f : 4.0f;
        mesh.m_171576_().m_171597_("left_arm").m_171599_("artifact", leftArm, PartPose.m_171419_((float)(-1.0f + armWidth / 2.0f), (float)10.0f, (float)0.0f));
        mesh.m_171576_().m_171597_("right_arm").m_171599_("artifact", rightArm, PartPose.m_171419_((float)(1.0f - armWidth / 2.0f), (float)10.0f, (float)0.0f));
        return mesh;
    }

    static float calc(float value) {
        return -1.0f - value / 2.0f;
    }

    public static MeshDefinition createWatchModel(boolean hasSlimArms) {
        CubeListBuilder leftArm = CubeListBuilder.m_171558_();
        CubeListBuilder rightArm = CubeListBuilder.m_171558_();
        float armWidth = hasSlimArms ? 3.0f : 4.0f;
        float armDepth = 4.0f;
        float height = -4.0f;
        leftArm.m_171514_(0, 0);
        leftArm.m_171481_(RendererUtil.calc(armWidth), height, RendererUtil.calc(armDepth), armWidth + 2.0f, 2.0f, 1.0f);
        rightArm.m_171514_(16, 0);
        rightArm.m_171481_(RendererUtil.calc(armWidth), height, RendererUtil.calc(armDepth), armWidth + 2.0f, 2.0f, 1.0f);
        leftArm.m_171514_(0, 3);
        leftArm.m_171481_(RendererUtil.calc(armWidth), height, armDepth / 2.0f, armWidth + 2.0f, 2.0f, 1.0f);
        rightArm.m_171514_(16, 3);
        rightArm.m_171481_(RendererUtil.calc(armWidth), height, armDepth / 2.0f, armWidth + 2.0f, 2.0f, 1.0f);
        leftArm.m_171514_(0, 6);
        leftArm.m_171481_(armWidth / 2.0f, height, -armDepth / 2.0f, 1.0f, 2.0f, armDepth);
        rightArm.m_171514_(16, 6);
        rightArm.m_171481_(armWidth / 2.0f, height, -armDepth / 2.0f, 1.0f, 2.0f, armDepth);
        leftArm.m_171514_(0, 12);
        leftArm.m_171481_(RendererUtil.calc(armWidth), height, -armDepth / 2.0f, 1.0f, 2.0f, armDepth);
        rightArm.m_171514_(16, 12);
        rightArm.m_171481_(RendererUtil.calc(armWidth), height, -armDepth / 2.0f, 1.0f, 2.0f, armDepth);
        leftArm.m_171514_(0, 18);
        leftArm.m_171481_(RendererUtil.calc(armWidth) + 6.0f, -5.0f, -2.0f, -1.0f, 4.0f, 4.0f);
        rightArm.m_171514_(16, 18);
        rightArm.m_171481_(RendererUtil.calc(armWidth) - 1.0f, -5.0f, -2.0f, 1.0f, 4.0f, 4.0f);
        return RendererUtil.createEmptyArms(leftArm, rightArm, hasSlimArms);
    }
}

