/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.overclocked_watches.client.item;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public abstract class RendererUtil {
    public static ModelPart bakeLayer(ModelLayerLocation layerLocation) {
        return Minecraft.getInstance().getEntityModels().bakeLayer(layerLocation);
    }

    public static HumanoidArm getArmSide(LivingEntity entity, InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? entity.getMainArm() : entity.getMainArm().getOpposite();
    }

    public static InteractionHand getInteractionHand(LivingEntity entity, HumanoidArm armSide) {
        return armSide == entity.getMainArm() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public static MeshDefinition createEmptyArms(CubeListBuilder leftArm, CubeListBuilder rightArm, boolean hasSlimArms) {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        mesh.getRoot().addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.ZERO);
        mesh.getRoot().addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.ZERO);
        float armWidth = hasSlimArms ? 3.0f : 4.0f;
        mesh.getRoot().getChild("left_arm").addOrReplaceChild("artifact", leftArm, PartPose.offset((float)(-1.0f + armWidth / 2.0f), (float)10.0f, (float)0.0f));
        mesh.getRoot().getChild("right_arm").addOrReplaceChild("artifact", rightArm, PartPose.offset((float)(1.0f - armWidth / 2.0f), (float)10.0f, (float)0.0f));
        return mesh;
    }

    static float calc(float value) {
        return -1.0f - value / 2.0f;
    }

    public static MeshDefinition createWatchModel(boolean hasSlimArms) {
        CubeListBuilder leftArm = CubeListBuilder.create();
        CubeListBuilder rightArm = CubeListBuilder.create();
        float armWidth = hasSlimArms ? 3.0f : 4.0f;
        float armDepth = 4.0f;
        float height = -4.0f;
        leftArm.texOffs(0, 0);
        leftArm.addBox(RendererUtil.calc(armWidth), height, RendererUtil.calc(armDepth), armWidth + 2.0f, 2.0f, 1.0f);
        rightArm.texOffs(16, 0);
        rightArm.addBox(RendererUtil.calc(armWidth), height, RendererUtil.calc(armDepth), armWidth + 2.0f, 2.0f, 1.0f);
        leftArm.texOffs(0, 3);
        leftArm.addBox(RendererUtil.calc(armWidth), height, armDepth / 2.0f, armWidth + 2.0f, 2.0f, 1.0f);
        rightArm.texOffs(16, 3);
        rightArm.addBox(RendererUtil.calc(armWidth), height, armDepth / 2.0f, armWidth + 2.0f, 2.0f, 1.0f);
        leftArm.texOffs(0, 6);
        leftArm.addBox(armWidth / 2.0f, height, -armDepth / 2.0f, 1.0f, 2.0f, armDepth);
        rightArm.texOffs(16, 6);
        rightArm.addBox(armWidth / 2.0f, height, -armDepth / 2.0f, 1.0f, 2.0f, armDepth);
        leftArm.texOffs(0, 12);
        leftArm.addBox(RendererUtil.calc(armWidth), height, -armDepth / 2.0f, 1.0f, 2.0f, armDepth);
        rightArm.texOffs(16, 12);
        rightArm.addBox(RendererUtil.calc(armWidth), height, -armDepth / 2.0f, 1.0f, 2.0f, armDepth);
        leftArm.texOffs(0, 18);
        leftArm.addBox(RendererUtil.calc(armWidth) + 6.0f, -5.0f, -2.0f, -1.0f, 4.0f, 4.0f);
        rightArm.texOffs(16, 18);
        rightArm.addBox(RendererUtil.calc(armWidth) - 1.0f, -5.0f, -2.0f, 1.0f, 4.0f, 4.0f);
        return RendererUtil.createEmptyArms(leftArm, rightArm, hasSlimArms);
    }
}

