#!/bin/bash

# ─── USER-CONFIG ──────────────────────────────────────────────────────────────
# Edit the RAM and LOOP constants to fit your needs.
#  
# RAM allocation. 'G' for Gigabyte and 'M' for megabyte. 
# 4G recommended minimum, up to 8G. 
# You can go above 8 but can be unstable on some systems, diminishing returns
RAM="4G"
# Whether or not the server will restart automatically upon crash.
# Recommended: 'true'
LOOP=false
# ───────────────────────────────────────────────────────────────────────────────



# SCRIPT:
if [ ! -d "libraries" ]; then
    echo "[IMPORTANT] Forge libraries directory not found. Auto-installing..."
    java -jar forge-1.20.1-47.4.6-installer.jar --installServer
    echo "[IMPORTANT] Forge has been installed."
fi
FORGE_ARGS="@libraries/net/minecraftforge/forge/1.20.1-47.4.6/unix_args.txt"
while true; do
    echo "Starting server..."
    java -Xmx${RAM} -Xms${RAM} ${FORGE_ARGS} --nogui "$@"

    if [ "$LOOP" != true ]; then
        echo "Loop disabled; exiting."
        break
    fi
    for i in 5 4 3 2 1; do
        printf 'Server restarting in %s... (press CTRL-C to exit)\n' "${i}"
        sleep 1
    done
done
