@echo off
setlocal

REM ─── USER-CONFIG ──────────────────────────────────────────────────────────────
REM Edit the RAM and LOOP constants to fit your needs.
REM  
REM RAM allocation. 'G' for Gigabyte and 'M' for megabyte. 
REM 4G recommended minimum, up to 8G. 
REM You can go above 8 but can be unstable on some systems, diminishing returns
set "RAM=10G"

REM Whether to auto-restart the server on exit/crash. 
REM true = loop forever; false = run once and quit.
set "LOOP=true"
REM ───────────────────────────────────────────────────────────────────────────────


REM SCRIPT:

:check_libraries
if not exist "libraries" (
    echo [IMPORTANT] Forge libraries directory not found. Auto-installing...
    java -jar forge-1.20.1-47.4.6-installer.jar --installServer
    echo [IMPORTANT] Forge has been installed.
)

set "FORGE_ARGS=@libraries\net\minecraftforge\forge\1.20.1-47.4.6\win_args.txt"
:restart
echo Starting server...
java -Xms%RAM% -Xmx%RAM% %FORGE_ARGS% nogui %*
if /I "%LOOP%" NEQ "true" (
    echo Loop disabled; exiting.
    goto :after
)
for /L %%i in (5,-1,1) do (
    echo Server restarting in %%i... (press CTRL-C to abort)
    ping 127.0.0.1 -n 1 -w 1000 > nul
)
goto :restart
:after
echo.
echo Press any key to close this window.
pause >nul
endlocal
exit /b
