----------------------------
 Abyssal Ascent Server Pack
----------------------------

It is highly recommended to read the entire document before you follow the instructions, so you know what you are doing.
It will answer almost any question you have and recommends options that improve your server.

Note: this file assumes you at least know the very basics of minecraft server hosting. If not, watch any tutorial on hosting a vanilla minecraft server.

MINIMUM REQUIREMENTS (for 4 players): -> not tested, educated guess by my (Xtreme's) server experience
Java 21 (or 17, preferred is 21, NO HIGHER THAN 23)
!! Forge version 47.4.6 !!
8GB RAM
3.0 GHz single core clock speed

----------------------------
        Instructions
----------------------------

1. Accept Mojang's End User Licence Agreement:
-> Edit 'eula.txt' and change from 'false' to 'true'

2. Edit the start script to your needs:
-> If you are on Linux or MacOS, its 'start.sh'
-> If you are on Windows, its 'start.bat'
!!! IMPORTANT !!!: Installing Forge autogenerates a 'run.sh' and 'run.bat' file. You could use this but there's no auto-restart feature, and requires setting RAM allocation through 'user_jvm_args.txt' instead of the script.
Edit the RAM allocation to your discretion, and select autorestart to automatically restart after any possible server crash.

3. Edit server.properties:
-> If you are getting kicked for flying, set 'allow-flight' to true
-> Set 'view-distance': This is RAM dependent but can be bottlenecked by limited CPU speeds, 8 minimum is recommended.
-> Set 'simulation-distance': This is heavily CPU dependent, thus recommended to not increase above 10. Lower if TPS/MSPT is too low. The Spark mod records this metric well.

4. [OPTIONAL] Import your world:
-> WARNING: this has not been tested, and it may not work exactly as expected. In theory, problems can happen but they are rare. It is instead highly recommended to generate a new world.
-> Rename your world directory to 'world'

5. Run your start script. Have fun!
-> If you have questions and concerns regarding server hosting, read through the rest of the document before contacting me or any other helpers in the community

----------------------------
      Recommendations
----------------------------

It is STRONGLY recommended to download GraalVM Enterprise Edition as supposed to OpenJDK or most other java versions. In my experience of running a 60+ player server, the performance gains can be up to 20% for essentially free. 
However, with modpacks, if you have compatibility issues attributed to your JRE version (especially if you cant get your server to run), don't use it. GraalVM is faster but it comes at potential compatibility risk, so if you have issues then stick with OpenJDK or Temurin.
The best and easiest way (imo) to download any java version is with SDKMAN, which is HIGHLY recommended.
Download GraalVM: https://www.graalvm.org/downloads/

Optimization Mods I recommend checking out:

Note: unless you are struggling to maintain 20 TPS (>50 MSPT) there is little need for these mods. Their compatibility with this modpack is untested.

Does It Tick?: Ticking Entity Optimizations (will freeze ticking entities if you're far away, can break some afk farms)
https://cdn.modrinth.com/data/vmg6jaPW/versions/rijaJD4F/does_it_tick-forge-1.1.4-1.20.1.jar

----------------------------
    Additional Resources
----------------------------

General information about server optimization:
https://paper-chan.moe/paper-optimization/

Lots of information on java runtime optimization, flags, etc.
https://github.com/brucethemoose/Minecraft-Performance-Flags-Benchmarks

If you don't want to directly share an IP or just wanna make it look pretty, you may use a subdomain name (like 'mcserver.us.to' and such) where I recommend this site:
https://freedns.afraid.org/
Note that you can use 'e4mc' which is already shipped with the server and client, but it gives you a random domain every launch, instead of one constant.

----------------------------
	       Need Help?
----------------------------
Join Aimsell's discord server: https://discord.gg/Z35BDKFEXu

Read through #known-bugs
If you are crashing:
  Upload your 'logs/latest.log' file to 'mclo.gs'
  Look for blocks of red (errors) and read the top lines of the error

Open a ticket or ping me (@xtreme420) in Aimsell's server in #mc-general
