/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanshields.util;

import com.oblivioussp.spartanshields.item.IItemPoweredFE;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyCapabilityProviderItem
implements ICapabilityProvider {
    public IEnergyStorage storage;

    public EnergyCapabilityProviderItem(final ItemStack stack, final IItemPoweredFE item) {
        this.storage = new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                return item.receiveFE(stack, maxReceive, simulate);
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return item.extractFE(stack, maxExtract, simulate);
            }

            public int getEnergyStored() {
                return item.getFEStored(stack);
            }

            public int getMaxEnergyStored() {
                return item.getFECapacity(stack);
            }

            public boolean canExtract() {
                return item.canExtractFE(stack);
            }

            public boolean canReceive() {
                return item.canReceiveFE(stack);
            }
        };
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        if (capability == ForgeCapabilities.ENERGY) {
            return LazyOptional.of(() -> this.storage).cast();
        }
        return LazyOptional.empty();
    }
}

