/*
 * Decompiled with CFR 0.152.
 */
package krelox.spartantoolkit.mixin;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.item.SwordBaseItem;
import com.oblivioussp.spartanweaponry.util.WeaponArchetype;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import krelox.spartantoolkit.IBetterWeaponTrait;
import krelox.spartantoolkit.SpartanMaterial;
import krelox.spartantoolkit.WeaponItem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SwordBaseItem.class})
public abstract class SwordBaseItemMixin
extends SwordItem
implements WeaponItem {
    @Shadow(remap=false)
    protected double attackSpeed;
    @Shadow(remap=false)
    protected Multimap<Attribute, AttributeModifier> modifiers;

    @Shadow(remap=false)
    public abstract float getDirectAttackDamage();

    @Shadow(remap=false)
    public abstract Collection<WeaponTrait> getAllWeaponTraits();

    @Inject(method={"<init>(Lnet/minecraft/world/item/Item$Properties;Lcom/oblivioussp/spartanweaponry/api/WeaponMaterial;Lcom/oblivioussp/spartanweaponry/util/WeaponArchetype;FFD)V"}, at={@At(value="RETURN")}, remap=false)
    private void spartantoolkit_injectRarity(Item.Properties prop, WeaponMaterial material, WeaponArchetype archetypeIn, float weaponBaseDamage, float weaponDamageMultiplier, double weaponSpeed, CallbackInfo ci) {
        if (material instanceof SpartanMaterial) {
            SpartanMaterial spartanMaterial = (SpartanMaterial)material;
            this.f_41369_ = spartanMaterial.getRarity();
        }
    }

    @Inject(method={"getAttributeModifiers"}, at={@At(value="HEAD")}, remap=false)
    public void spartantoolkit_getAttributeModifiers(EquipmentSlot slot, ItemStack stack, CallbackInfoReturnable<Multimap<Attribute, AttributeModifier>> cir) {
        ImmutableMultimap.Builder mapBuilder = ImmutableMultimap.builder();
        mapBuilder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.getDirectAttackDamage(), AttributeModifier.Operation.ADDITION));
        double finalAttackSpeed = this.attackSpeed - 4.0;
        WeaponMaterial weaponMaterial = this.getMaterial();
        if (weaponMaterial instanceof SpartanMaterial) {
            SpartanMaterial material = (SpartanMaterial)weaponMaterial;
            finalAttackSpeed += material.getAttackSpeedModifier();
        }
        mapBuilder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", finalAttackSpeed, AttributeModifier.Operation.ADDITION));
        this.triggerEnabledTraits(this.getAllWeaponTraits(), trait -> trait.getMeleeCallback().ifPresent(callback -> callback.onModifyAttributesMelee(mapBuilder)), stack);
        this.modifiers = mapBuilder.build();
    }

    @Redirect(method={"inventoryTick"}, at=@At(value="INVOKE", target="Ljava/util/List;forEach(Ljava/util/function/Consumer;)V"))
    private void spartantoolkit_inventoryTick(List<WeaponTrait> traits, Consumer<WeaponTrait> consumer, ItemStack stack) {
        this.triggerEnabledTraits(traits, consumer, stack);
    }

    @Redirect(method={"appendHoverText"}, at=@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z"))
    private boolean spartantoolkit_appendHoverText(List<WeaponTrait> traits, ItemStack stack) {
        return traits.stream().noneMatch(trait -> ((IBetterWeaponTrait)trait).isEnabled(this.getMaterial(), stack));
    }

    @Redirect(method={"hurtEnemy"}, at=@At(value="INVOKE", target="Ljava/util/List;forEach(Ljava/util/function/Consumer;)V"))
    private void spartantoolkit_hurtEnemy(List<WeaponTrait> traits, Consumer<WeaponTrait> consumer, ItemStack stack) {
        this.triggerEnabledTraits(traits, consumer, stack);
    }

    @Redirect(method={"useOn"}, at=@At(value="INVOKE", target="Ljava/util/Optional;isPresent()Z"))
    private boolean spartantoolkit_useOn(Optional<IBetterWeaponTrait> optional, UseOnContext context) {
        if (optional.isEmpty()) {
            this.triggerFirstEnabledActionTrait(context.m_43722_(), trait -> trait.useOn(context));
            return false;
        }
        return optional.get().isEnabled(this.getMaterial(), context.m_43722_());
    }

    @Redirect(method={"useOn"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/SwordItem;useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;"))
    private InteractionResult spartantoolkit_useOn(SwordItem item, UseOnContext context) {
        return (InteractionResult)this.getFirstEnabledActionTraitResult(context.m_43722_(), callback -> callback.useOn(context), () -> super.m_6225_(context));
    }

    @Redirect(method={"use"}, at=@At(value="INVOKE", target="Ljava/util/Optional;isPresent()Z"))
    private boolean spartantoolkit_use(Optional<IBetterWeaponTrait> optional, Level level, Player player, InteractionHand hand) {
        if (optional.isEmpty()) {
            this.triggerFirstEnabledActionTrait(player.m_21120_(hand), trait -> trait.use(player.m_21120_(hand), level, player, hand));
            return false;
        }
        return optional.get().isEnabled(this.getMaterial(), player.m_21120_(hand));
    }

    @Redirect(method={"use"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/SwordItem;use(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;"))
    private InteractionResultHolder<ItemStack> spartantoolkit_use(SwordItem item, Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return (InteractionResultHolder)this.getFirstEnabledActionTraitResult(stack, callback -> callback.use(stack, level, player, hand), () -> super.m_7203_(level, player, hand));
    }

    @Redirect(method={"releaseUsing"}, at=@At(value="INVOKE", target="Ljava/util/Optional;ifPresent(Ljava/util/function/Consumer;)V"))
    private void spartantoolkit_releaseUsing(Optional<IBetterWeaponTrait> optional, Consumer<IBetterWeaponTrait> action, ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        optional.filter(trait -> trait.isEnabled(this.getMaterial(), stack)).ifPresentOrElse(action, () -> this.triggerFirstEnabledActionTrait(stack, trait -> trait.releaseUsing(stack, level, entityLiving, timeLeft, this.getDirectAttackDamage())));
    }

    @Redirect(method={"onUseTick"}, at=@At(value="INVOKE", target="Ljava/util/Optional;ifPresent(Ljava/util/function/Consumer;)V"))
    private void spartantoolkit_onUseTick(Optional<IBetterWeaponTrait> optional, Consumer<IBetterWeaponTrait> action, Level levelIn, LivingEntity player, ItemStack stack, int count) {
        optional.filter(trait -> trait.isEnabled(this.getMaterial(), stack)).ifPresentOrElse(action, () -> this.triggerFirstEnabledActionTrait(stack, trait -> trait.onUsingTick(stack, player, count, this.getDirectAttackDamage())));
    }

    @Redirect(method={"getUseDuration"}, at=@At(value="INVOKE", target="Ljava/util/Optional;isPresent()Z"))
    private boolean spartantoolkit_getUseDuration(Optional<IBetterWeaponTrait> optional, ItemStack stack) {
        return optional.isPresent() && optional.get().isEnabled(this.getMaterial(), stack);
    }

    @Redirect(method={"getUseDuration"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/SwordItem;getUseDuration(Lnet/minecraft/world/item/ItemStack;)I"))
    private int spartantoolkit_getUseDuration(SwordItem item, ItemStack stack) {
        return (Integer)this.getFirstEnabledActionTraitResult(stack, callback -> callback.getUseDuration(stack), () -> super.m_8105_(stack));
    }

    @Redirect(method={"getUseAnimation"}, at=@At(value="INVOKE", target="Ljava/util/Optional;isPresent()Z"))
    private boolean spartantoolkit_getUseAnimation(Optional<IBetterWeaponTrait> optional, ItemStack stack) {
        return optional.isPresent() && optional.get().isEnabled(this.getMaterial(), stack);
    }

    @Redirect(method={"getUseAnimation"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/SwordItem;getUseAnimation(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/UseAnim;"))
    private UseAnim spartantoolkit_getUseAnimation(SwordItem item, ItemStack stack) {
        return (UseAnim)this.getFirstEnabledActionTraitResult(stack, callback -> callback.getUseAnimation(stack), () -> super.m_6164_(stack));
    }

    @Redirect(method={"doesSneakBypassUse"}, at=@At(value="INVOKE", target="Ljava/util/Optional;isPresent()Z"), remap=false)
    private boolean spartantoolkit_doesSneakBypassUse(Optional<IBetterWeaponTrait> optional, ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return optional.isPresent() && optional.get().isEnabled(this.getMaterial(), stack);
    }

    @Redirect(method={"doesSneakBypassUse"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/SwordItem;doesSneakBypassUse(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;)Z"), remap=false)
    private boolean spartantoolkit_doesSneakBypassUse(SwordItem item, ItemStack stack, LevelReader levelReader, BlockPos blockPos, Player player) {
        return (Boolean)this.getFirstEnabledActionTraitResult(stack, callback -> callback.doesSneakBypassUse(stack, levelReader, blockPos, player), () -> super.doesSneakBypassUse(stack, levelReader, blockPos, player));
    }

    @Redirect(method={"onCraftedBy"}, at=@At(value="INVOKE", target="Ljava/util/List;forEach(Ljava/util/function/Consumer;)V"))
    private void spartantoolkit_onCraftedBy(List<WeaponTrait> traits, Consumer<WeaponTrait> consumer, ItemStack stack) {
        this.triggerEnabledTraits(traits, consumer, stack);
    }

    private SwordBaseItemMixin(Tier tier, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, properties);
    }
}

