/*
 * Decompiled with CFR 0.152.
 */
package krelox.spartantoolkit.mixin;

import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.item.HeavyCrossbowItem;
import com.oblivioussp.spartanweaponry.util.WeaponType;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import krelox.spartantoolkit.IBetterWeaponTrait;
import krelox.spartantoolkit.SpartanMaterial;
import krelox.spartantoolkit.WeaponItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HeavyCrossbowItem.class})
public class HeavyCrossbowItemMixin
extends CrossbowItem
implements WeaponItem {
    @Shadow(remap=false)
    protected WeaponMaterial material;
    @Shadow(remap=false)
    protected List<WeaponTrait> rangedTraits;
    @Shadow(remap=false)
    protected int loadTicks;
    @Shadow(remap=false)
    protected int aimTicks;

    @Inject(method={"<init>(Lnet/minecraft/world/item/Item$Properties;Lcom/oblivioussp/spartanweaponry/api/WeaponMaterial;)V"}, at={@At(value="RETURN")}, remap=false)
    private void spartantoolkit_injectRarity(Item.Properties prop, WeaponMaterial material, CallbackInfo ci) {
        if (material instanceof SpartanMaterial) {
            SpartanMaterial spartanMaterial = (SpartanMaterial)material;
            this.f_41369_ = spartanMaterial.getRarity();
        }
    }

    @Redirect(method={"spawnProjectile"}, at=@At(value="INVOKE", target="Ljava/util/Optional;ifPresent(Ljava/util/function/Consumer;)V"), remap=false)
    private void spartantoolkit_spawnProjectile(Optional<IBetterWeaponTrait> optional, Consumer<IBetterWeaponTrait> action, ItemStack crossbow) {
        optional.filter(trait -> trait.isEnabled(this.material, crossbow)).ifPresent(action);
    }

    @Redirect(method={"appendHoverText"}, at=@At(value="INVOKE", target="Lcom/oblivioussp/spartanweaponry/api/WeaponMaterial;hasAnyBonusTraits(Lcom/oblivioussp/spartanweaponry/util/WeaponType;)Z", remap=false))
    private boolean spartantoolkit_appendHoverText(WeaponMaterial material, WeaponType type) {
        return material.getBonusTraits(type).stream().anyMatch(trait -> ((IBetterWeaponTrait)trait).isEnabled(material, this.m_7968_()));
    }

    @Inject(method={"getFullLoadTicks"}, at={@At(value="HEAD")}, remap=false)
    private void spartantoolkit_getFullLoadTicks(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        this.loadTicks = 25;
        this.triggerEnabledTraits(this.rangedTraits, trait -> trait.getRangedCallback().ifPresent(callback -> {
            this.loadTicks = callback.modifyHeavyCrossbowLoadTime(this.material, this.loadTicks);
        }), stack);
    }

    @Inject(method={"getAimTicks"}, at={@At(value="HEAD")}, remap=false)
    private void spartantoolkit_getAimTicks(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        this.aimTicks = 10;
        this.triggerEnabledTraits(this.rangedTraits, trait -> trait.getRangedCallback().ifPresent(callback -> {
            this.aimTicks = callback.modifyHeavyCrossbowAimTime(this.material, this.aimTicks);
        }), stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        this.triggerEnabledTraits(this.rangedTraits, trait -> ((IBetterWeaponTrait)trait).onRangedItemUpdate(this.material, stack, level, (LivingEntity)entity, itemSlot, isSelected), stack);
    }

    @Override
    public WeaponMaterial getMaterial() {
        return this.material;
    }

    private HeavyCrossbowItemMixin(Item.Properties properties) {
        super(properties);
    }
}

