/*
 * Decompiled with CFR 0.152.
 */
package krelox.spartantoolkit;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import krelox.spartantoolkit.WeaponMap;
import krelox.spartantoolkit.WeaponType;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class WeaponAttributeProvider
implements DataProvider {
    protected static final ExistingFileHelper.ResourceType WEAPON_ATTRIBUTES = new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", "weapon_attributes");
    protected final PackOutput.PathProvider attributePathProvider;
    protected final Map<ResourceLocation, JsonObject> generatedAttributes = new HashMap<ResourceLocation, JsonObject>();
    protected final ExistingFileHelper existingFileHelper;

    protected abstract void registerAttributes();

    protected WeaponAttributeProvider(PackOutput output, ExistingFileHelper fileHelper) {
        this.attributePathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "weapon_attributes");
        Preconditions.checkNotNull((Object)output);
        Preconditions.checkNotNull((Object)fileHelper);
        this.existingFileHelper = fileHelper;
    }

    public void spartanAttributes(ResourceLocation location, WeaponType type) {
        if (type == WeaponType.BOOMERANG || type == WeaponType.HEAVY_CROSSBOW || type == WeaponType.LONGBOW) {
            return;
        }
        JsonObject attributes = new JsonObject();
        attributes.addProperty("parent", "spartanweaponry:base/" + type.name().toLowerCase(Locale.US));
        this.existingFileHelper.trackGenerated(location, (ExistingFileHelper.IResourceType)WEAPON_ATTRIBUTES);
        this.generatedAttributes.put(location, attributes);
    }

    public void spartanAttributes(WeaponMap map) {
        map.forEach((pair, item) -> this.spartanAttributes(item.getId(), (WeaponType)((Object)((Object)pair.second()))));
    }

    public String m_6055_() {
        return "Weapon Attributes";
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.generatedAttributes.clear();
        this.registerAttributes();
        return this.generateAll(cache);
    }

    protected CompletableFuture<Void> generateAll(CachedOutput cache) {
        CompletableFuture[] futures = new CompletableFuture[this.generatedAttributes.size()];
        int i = 0;
        for (Map.Entry<ResourceLocation, JsonObject> idJsonEntry : this.generatedAttributes.entrySet()) {
            JsonObject attributes = idJsonEntry.getValue();
            Path targetPath = this.attributePathProvider.m_245731_(idJsonEntry.getKey());
            futures[i++] = DataProvider.m_253162_((CachedOutput)cache, (JsonElement)attributes, (Path)targetPath);
        }
        return CompletableFuture.allOf(futures);
    }
}

