/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.azure.azurelib.rewrite.animation.impl.AzItemAnimator;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.render.AzProvider;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.item.AzItemGuiRenderUtil;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererConfig;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererPipeline;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererPipelineContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AzItemRenderer {
    private final AzItemRendererConfig config;
    private final AzProvider<ItemStack> provider;
    public final AzItemRendererPipeline rendererPipeline;
    @Nullable
    private AzItemAnimator reusedAzItemAnimator;

    protected AzItemRenderer(AzItemRendererConfig config) {
        this.rendererPipeline = this.createPipeline(config);
        this.provider = new AzProvider<ItemStack>(config::createAnimator, config::modelLocation);
        this.config = config;
    }

    protected AzItemRendererPipeline createPipeline(AzItemRendererConfig config) {
        return new AzItemRendererPipeline(config, this);
    }

    public void renderByGui(ItemStack stack, ItemDisplayContext transformType, @NotNull PoseStack poseStack, @NotNull MultiBufferSource source, int packedLight) {
        AzBakedModel model = this.provider.provideBakedModel(stack);
        AzRendererPipelineContext context = this.rendererPipeline.context();
        AzItemRendererPipelineContext itemContext = (AzItemRendererPipelineContext)context;
        itemContext.setTransformType(transformType);
        this.prepareAnimator(stack, model);
        AzItemGuiRenderUtil.renderInGui(this.config, this.rendererPipeline, stack, model, stack, poseStack, source, packedLight);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, @NotNull PoseStack poseStack, @NotNull MultiBufferSource source, int packedLight) {
        AzBakedModel model = this.provider.provideBakedModel(stack);
        float partialTick = Minecraft.m_91087_().m_91296_();
        ResourceLocation textureLocation = this.config.textureLocation(stack);
        RenderType renderType = this.rendererPipeline.context().getDefaultRenderType(stack, textureLocation, source, partialTick, this.config.getRenderType(stack), this.config.alpha(stack));
        boolean withGlint = stack != null && stack.m_41790_();
        VertexConsumer buffer = ItemRenderer.m_115222_((MultiBufferSource)source, (RenderType)renderType, (boolean)false, (boolean)withGlint);
        AzRendererPipelineContext context = this.rendererPipeline.context();
        AzItemRendererPipelineContext itemContext = (AzItemRendererPipelineContext)context;
        itemContext.setTransformType(transformType);
        this.prepareAnimator(stack, model);
        this.rendererPipeline.render(poseStack, model, stack, source, renderType, buffer, 0.0f, partialTick, packedLight);
    }

    private void prepareAnimator(ItemStack stack, AzBakedModel model) {
        AzItemAnimator cachedEntityAnimator = (AzItemAnimator)this.provider.provideAnimator(stack);
        if (cachedEntityAnimator != null && model != null) {
            cachedEntityAnimator.setActiveModel(model);
        }
        this.reusedAzItemAnimator = cachedEntityAnimator;
    }

    @Nullable
    public AzItemAnimator getAnimator() {
        return this.reusedAzItemAnimator;
    }

    public AzItemRendererConfig config() {
        return this.config;
    }
}

