/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import mod.azure.azurelib.core.object.Color;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public abstract class AzRendererPipelineContext<T> {
    public ResourceLocation textureOverride;
    private final AzRendererPipeline<T> rendererPipeline;
    protected T animatable;
    private AzBakedModel bakedModel;
    private MultiBufferSource multiBufferSource;
    private int packedLight;
    private int packedOverlay;
    private float partialTick;
    private PoseStack poseStack;
    private float red;
    private float green;
    private float blue;
    private float alpha;
    private RenderType renderType;
    private VertexConsumer vertexConsumer;
    protected static final Map<ResourceLocation, IntIntPair> TEXTURE_DIMENSIONS_CACHE = new Object2ObjectOpenHashMap();

    protected AzRendererPipelineContext(AzRendererPipeline<T> rendererPipeline) {
        this.rendererPipeline = rendererPipeline;
    }

    public void populate(T animatable, AzBakedModel bakedModel, MultiBufferSource multiBufferSource, int packedLight, float partialTick, PoseStack poseStack, RenderType renderType, VertexConsumer vertexConsumer) {
        this.animatable = animatable;
        this.bakedModel = bakedModel;
        this.multiBufferSource = multiBufferSource;
        this.packedLight = packedLight;
        this.packedOverlay = this.getPackedOverlay(animatable, 0.0f, partialTick);
        this.partialTick = partialTick;
        this.poseStack = poseStack;
        this.renderType = renderType;
        this.vertexConsumer = vertexConsumer;
        Color renderColor = this.getRenderColor(animatable, partialTick, packedLight);
        this.red = renderColor.getRedFloat();
        this.green = renderColor.getGreenFloat();
        this.blue = renderColor.getBlueFloat();
        this.alpha = renderColor.getAlphaFloat();
        if (renderType == null) {
            ResourceLocation textureLocation = this.rendererPipeline.config().textureLocation(animatable);
            this.renderType = this.getDefaultRenderType(animatable, textureLocation, multiBufferSource, partialTick, this.rendererPipeline.config().getRenderType(animatable), this.rendererPipeline.config().alpha(animatable));
        }
        Objects.requireNonNull(this.renderType);
        if (vertexConsumer == null) {
            this.vertexConsumer = multiBufferSource.m_6299_(this.renderType);
        }
    }

    public abstract RenderType getDefaultRenderType(T var1, ResourceLocation var2, MultiBufferSource var3, float var4, RenderType var5, float var6);

    public Color getRenderColor(T animatable, float partialTick, int packedLight) {
        return Color.WHITE;
    }

    protected int getPackedOverlay(T animatable, float u, float partialTick) {
        return OverlayTexture.f_118083_;
    }

    public AzRendererPipeline<T> rendererPipeline() {
        return this.rendererPipeline;
    }

    public T animatable() {
        return this.animatable;
    }

    public AzBakedModel bakedModel() {
        return this.bakedModel;
    }

    public MultiBufferSource multiBufferSource() {
        return this.multiBufferSource;
    }

    public float red() {
        return this.red;
    }

    public float green() {
        return this.green;
    }

    public float blue() {
        return this.blue;
    }

    public float alpha() {
        return this.alpha;
    }

    public void setRed(float red) {
        this.red = red;
    }

    public void setGreen(float green) {
        this.green = green;
    }

    public void setBlue(float blue) {
        this.blue = blue;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setColor(Color color) {
        this.red = color.getRedFloat();
        this.green = color.getGreenFloat();
        this.blue = color.getBlueFloat();
    }

    public int packedLight() {
        return this.packedLight;
    }

    public void setPackedLight(int packedLight) {
        this.packedLight = packedLight;
    }

    public int packedOverlay() {
        return this.packedOverlay;
    }

    public void setPackedOverlay(int packedOverlay) {
        this.packedOverlay = packedOverlay;
    }

    public float partialTick() {
        return this.partialTick;
    }

    public PoseStack poseStack() {
        return this.poseStack;
    }

    public RenderType renderType() {
        return this.renderType;
    }

    public void setRenderType(RenderType renderType) {
        this.renderType = renderType;
    }

    public VertexConsumer vertexConsumer() {
        return this.vertexConsumer;
    }

    public void setVertexConsumer(VertexConsumer vertexConsumer) {
        this.vertexConsumer = vertexConsumer;
    }

    public void setTextureOverride(ResourceLocation textureOverride) {
        this.textureOverride = textureOverride;
    }

    public ResourceLocation getTextureOverride() {
        return this.textureOverride;
    }

    public IntIntPair computeTextureSize(ResourceLocation texture) {
        return TEXTURE_DIMENSIONS_CACHE.computeIfAbsent(texture, RenderUtils::getTextureDimensions);
    }
}

