/*
 * Decompiled with CFR 0.152.
 */
package com.github.raverbury.aggroindicator.config;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

public class ClientConfig {
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec INSTANCE;
    public static ForgeConfigSpec.BooleanValue RENDER_ALERT_ICON;
    public static ForgeConfigSpec.IntValue RENDER_RANGE;
    public static ForgeConfigSpec.DoubleValue X_OFFSET;
    public static ForgeConfigSpec.DoubleValue Y_OFFSET;
    public static ForgeConfigSpec.DoubleValue ALERT_ICON_SIZE;
    public static ForgeConfigSpec.BooleanValue SCALE_WITH_MOB_SIZE;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> CLIENT_MOB_BLACKLIST;
    public static ForgeConfigSpec.BooleanValue TREAT_BLACKLIST_AS_WHITELIST;
    public static ForgeConfigSpec.EnumValue<AggroIconStyle> CLIENT_AGGRO_ICON_STYLE;
    public static ForgeConfigSpec.ConfigValue<String> ALERT_COLOR_HEX;
    public static ForgeConfigSpec.IntValue HIDE_ALERT_AFTER;

    static {
        CLIENT_BUILDER.push("Rendering");
        RENDER_ALERT_ICON = CLIENT_BUILDER.comment("Controls whether the client should render alert icons").translation("config.client.renderAlertIcon").define("renderAlertIcon", true);
        RENDER_RANGE = CLIENT_BUILDER.comment("Only render alert icons for mobs within this range").translation("config.client.renderRange").defineInRange("renderRange", 32, 8, 64);
        X_OFFSET = CLIENT_BUILDER.comment("Adjusts the horizontal placement of alert icons").translation("config.client.xOffset").defineInRange("xOffset", 0.0, -10.0, 10.0);
        Y_OFFSET = CLIENT_BUILDER.comment("Adjusts the vertical placement of alert icons").translation("config.client.yOffset").defineInRange("yOffset", 0.0, -10.0, 50.0);
        ALERT_ICON_SIZE = CLIENT_BUILDER.comment("Adjust the size of alert icons").translation("config.client.alertIconSize").defineInRange("alertIconSize", 30.0, 0.0, 100.0);
        SCALE_WITH_MOB_SIZE = CLIENT_BUILDER.comment("Controls whether alert icons should grow in size with mobs").translation("config.client.scaleWithMobSize").define("scaleWithMobSize", false);
        CLIENT_MOB_BLACKLIST = CLIENT_BUILDER.comment("Do not render alert icons for these mobs").translation("config.client.clientMobBlacklist").defineList("clientMobBlacklist", new ArrayList(), registry_name -> true);
        TREAT_BLACKLIST_AS_WHITELIST = CLIENT_BUILDER.comment("Draw alert icons only for the blacklisted mobs instead").translation("config.client.treatBlacklistAsWhitelist").define("treatBlacklistAsWhitelist", false);
        CLIENT_AGGRO_ICON_STYLE = CLIENT_BUILDER.comment("The texture of the aggro icon").translation("config.client.clientAggroIconStyle").defineEnum("clientAggroIconStyle", (Enum)AggroIconStyle.CLASSIC);
        ALERT_COLOR_HEX = CLIENT_BUILDER.comment("The color of the alert icon").translation("config.client.clientAlertColorHex").define("alertColorHex", (Object)"0xFF6666");
        HIDE_ALERT_AFTER = CLIENT_BUILDER.comment("Hide alert icon after X ticks, set to <= 0 to disable").translation("config.client.clientHideAlertAfterTicks").defineInRange("hideAlertAfterTicks", -1, -2, Integer.MAX_VALUE);
        CLIENT_BUILDER.pop();
        INSTANCE = CLIENT_BUILDER.build();
    }

    public static enum AggroIconStyle {
        CLASSIC,
        MGS,
        BLOCK_BENCH;

    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class Cached {
        public static boolean RENDER_ALERT_ICON = true;
        public static int RENDER_RANGE = 32;
        public static double X_OFFSET = 0.0;
        public static double Y_OFFSET = 5.0;
        public static double ALERT_ICON_SIZE = 30.0;
        public static boolean SCALE_WITH_MOB_SIZE = false;
        public static List<? extends String> CLIENT_MOB_BLACKLIST = new ArrayList<String>();
        public static boolean TREAT_BLACKLIST_AS_WHITELIST = false;
        public static AggroIconStyle CLIENT_AGGRO_ICON_STYLE = AggroIconStyle.CLASSIC;
        public static float[] COLORS = new float[]{1.0f, 1.0f, 1.0f};
        public static int hideAfterTicks = -1;

        public static void reload() {
            RENDER_ALERT_ICON = (Boolean)RENDER_ALERT_ICON.get();
            RENDER_RANGE = (Integer)RENDER_RANGE.get();
            X_OFFSET = (Double)X_OFFSET.get();
            Y_OFFSET = (Double)Y_OFFSET.get();
            ALERT_ICON_SIZE = (Double)ALERT_ICON_SIZE.get();
            SCALE_WITH_MOB_SIZE = (Boolean)SCALE_WITH_MOB_SIZE.get();
            CLIENT_MOB_BLACKLIST = (List)CLIENT_MOB_BLACKLIST.get();
            TREAT_BLACKLIST_AS_WHITELIST = (Boolean)TREAT_BLACKLIST_AS_WHITELIST.get();
            CLIENT_AGGRO_ICON_STYLE = (AggroIconStyle)((Object)CLIENT_AGGRO_ICON_STYLE.get());
            Color color = Color.decode((String)ALERT_COLOR_HEX.get());
            Cached.COLORS[0] = (float)color.getRed() / 255.0f;
            Cached.COLORS[1] = (float)color.getGreen() / 255.0f;
            Cached.COLORS[2] = (float)color.getBlue() / 255.0f;
            hideAfterTicks = (Integer)HIDE_ALERT_AFTER.get();
        }
    }
}

