/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.network;

import com.oblivioussp.spartanweaponry.inventory.QuiverBaseMenu;
import com.oblivioussp.spartanweaponry.util.QuiverHelper;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class QuiverPrioritySlotPacket {
    private final int prioritySlot;

    public QuiverPrioritySlotPacket(int slotIn) {
        this.prioritySlot = slotIn;
    }

    public static void encode(QuiverPrioritySlotPacket packet, FriendlyByteBuf buf) {
        buf.writeByte(packet.prioritySlot);
    }

    public static QuiverPrioritySlotPacket decode(FriendlyByteBuf buf) {
        return new QuiverPrioritySlotPacket(buf.readByte());
    }

    public static class Handler {
        public static void handle(QuiverPrioritySlotPacket packet, Supplier<NetworkEvent.Context> ctx) {
            if (packet == null) {
                return;
            }
            ctx.get().enqueueWork(() -> {
                AbstractContainerMenu menu = ((NetworkEvent.Context)ctx.get()).getSender().f_36096_;
                if (menu instanceof QuiverBaseMenu) {
                    QuiverBaseMenu quiverMenu = (QuiverBaseMenu)menu;
                    ItemStack quiver = quiverMenu.getQuiverStack();
                    quiver.m_41784_().m_128405_("PrioritySlot", packet.prioritySlot);
                    Slot slot = quiverMenu.m_38853_(packet.prioritySlot);
                    if (!slot.m_6657_()) {
                        return;
                    }
                    for (QuiverHelper.IQuiverInfo quiverInfo : QuiverHelper.info) {
                        InteractionHand ammoHand;
                        ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                        if (!quiverInfo.isQuiver(quiver) || (ammoHand = quiverInfo.isWeapon(player.m_21205_()) ? InteractionHand.OFF_HAND : (quiverInfo.isWeapon(player.m_21206_()) ? InteractionHand.MAIN_HAND : null)) == null) continue;
                        ItemStack priorityStack = slot.m_7993_();
                        ItemStack ammoStack = player.m_21120_(ammoHand);
                        player.m_21008_(ammoHand, priorityStack);
                        slot.m_5852_(ammoStack);
                    }
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }
}

