/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.entity.projectile;

import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.util.Config;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class DynamiteEntity
extends ThrowableItemProjectile {
    protected int timer;
    protected int fuseTicks = 60;

    public DynamiteEntity(EntityType<? extends DynamiteEntity> type, Level level) {
        super(type, level);
        this.fuseTicks = (Integer)Config.INSTANCE.fuseTicksDynamite.get();
    }

    public DynamiteEntity(double x, double y, double z, Level level) {
        super((EntityType)ModEntities.DYNAMITE.get(), x, y, z, level);
        this.fuseTicks = (Integer)Config.INSTANCE.fuseTicksDynamite.get();
    }

    public DynamiteEntity(LivingEntity thrower, Level level) {
        super((EntityType)ModEntities.DYNAMITE.get(), thrower, level);
        this.fuseTicks = (Integer)Config.INSTANCE.fuseTicksDynamite.get();
    }

    public DynamiteEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        super((EntityType)ModEntities.DYNAMITE.get(), level);
        this.fuseTicks = (Integer)Config.INSTANCE.fuseTicksDynamite.get();
    }

    public void m_8119_() {
        Level level = this.m_9236_();
        this.m_6075_();
        this.f_19790_ = this.m_20185_();
        this.f_19791_ = this.m_20186_();
        this.f_19792_ = this.m_20189_();
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82492_(0.0, 0.04, 0.0));
        }
        double drag = 0.98;
        if (this.m_20069_()) {
            Vec3 delta = this.m_20184_();
            double nextX = this.m_20185_() + delta.f_82479_;
            double nextY = this.m_20186_() + delta.f_82480_;
            double nextZ = this.m_20189_() + delta.f_82481_;
            for (int i = 0; i < 4; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123795_, nextX - delta.f_82479_ * 0.25, nextY - delta.f_82480_ * 0.25, nextZ - delta.f_82481_ * 0.25, delta.f_82479_, delta.f_82480_, delta.f_82481_);
            }
            drag = 0.8;
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(drag));
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
        }
        ++this.timer;
        if (this.timer >= this.fuseTicks) {
            this.explode();
        } else {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 0.0, 0.1, 0.0);
        }
    }

    protected void m_6532_(HitResult result) {
    }

    protected void explode() {
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            boolean mobGriefing = level.m_46469_().m_46207_(GameRules.f_46132_);
            level.m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), ((Double)Config.INSTANCE.explosionStrengthDynamite.get()).floatValue(), mobGriefing && (Boolean)Config.INSTANCE.disableTerrainDamage.get() == false ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE);
            this.m_146870_();
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Item m_7881_() {
        return (Item)ModItems.DYNAMITE.get();
    }
}

